/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io;

public enum Charset {
    US_ASCII("US-ASCII", "Seven-bit ASCII, a.k.a. ISO646-US, a.k.a. the Basic Latin block of the Unicode character set"),
    ISO_8859_1("ISO-8859-1", "ISO Latin Alphabet No. 1, a.k.a. ISO-LATIN-1"),
    UTF_8("UTF-8", "Eight-bit UCS Transformation Format"),
    UTF_16BE("UTF-16BE", "Sixteen-bit UCS Transformation Format, big-endian byte order"),
    UTF_16LE("UTF-16LE", "Sixteen-bit UCS Transformation Format, little-endian byte order"),
    UTF_16("UTF-16", "Sixteen-bit UCS Transformation Format, byte order identified by an optional byte-order mark");

    private final String charsetAsString;
    private final String description;

    private Charset(String string2, String string3) {
        this.charsetAsString = string2;
        this.description = string3;
    }

    public String getCharsetAsString() {
        return this.charsetAsString;
    }

    public String getDescription() {
        return this.description;
    }

    public static Charset getDefaultCharset() {
        return ISO_8859_1;
    }

    public static Charset detectFromNameString(String string) {
        try {
            return Charset.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Es ist kein Charset mit dem Namen '" + string + "' bekannt!");
        }
    }

    public static Charset detectFromCharsetAsString(String string) {
        for (Charset charset : Charset.values()) {
            if (!string.equalsIgnoreCase(charset.getCharsetAsString())) continue;
            return charset;
        }
        throw new IllegalArgumentException("Es ist kein Charset mit der angegebenen Stringform des Charsets '" + string + "' bekannt!");
    }

    public static String createCompleteCharsetDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u00dcbersicht \u00fcber die Charsets:\n");
        int n = 0;
        int n2 = 0;
        for (Charset charset : Charset.values()) {
            if (n < charset.name().length()) {
                n = charset.name().length();
            }
            if (n2 >= charset.getCharsetAsString().length()) continue;
            n2 = charset.getCharsetAsString().length();
        }
        String string = "%-" + n + "s";
        String string2 = "%-" + n2 + "s";
        for (Charset charset : Charset.values()) {
            String string3 = charset.name();
            String string4 = charset.getCharsetAsString();
            String string5 = charset.getDescription();
            stringBuilder.append(String.format(string + " - " + string2 + " - %s\n", string3, string4, string5));
        }
        return stringBuilder.toString();
    }

    public static String createCompleteCharsetDescriptionWithOnlyName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u00dcbersicht \u00fcber die Charsets:\n");
        int n = 0;
        for (Charset charset : Charset.values()) {
            if (n >= charset.name().length()) continue;
            n = charset.name().length();
        }
        String string = "%-" + n + "s";
        for (Charset charset : Charset.values()) {
            String string2 = charset.name();
            String string3 = charset.getDescription();
            stringBuilder.append(String.format(string + " - %s\n", string2, string3));
        }
        return stringBuilder.toString();
    }

    public static String createCompleteCharsetDescriptionWithOnlyCharsetAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u00dcbersicht \u00fcber die Charsets:\n");
        int n = 0;
        for (Charset charset : Charset.values()) {
            if (n >= charset.getCharsetAsString().length()) continue;
            n = charset.getCharsetAsString().length();
        }
        String string = "%-" + n + "s";
        for (Charset charset : Charset.values()) {
            String string2 = charset.getCharsetAsString();
            String string3 = charset.getDescription();
            stringBuilder.append(String.format(string + " - %s\n", string2, string3));
        }
        return stringBuilder.toString();
    }
}

