/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io;

import de.duehl.basics.text.Text;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FileSet
implements Iterable<String>,
Serializable {
    private static final long serialVersionUID = 3045240775849454776L;
    private final List<String> fileNames = new ArrayList<String>();

    public FileSet(List<String> list) {
        for (String string : list) {
            this.add(string);
        }
    }

    public FileSet(String ... stringArray) {
        this(Arrays.asList(stringArray));
    }

    public void add(String string) {
        String string2 = this.normalize(string);
        if (this.fileNames.contains(string2)) {
            throw new IllegalArgumentException("Die Datei " + string2 + " ist schon im FileSet vorhanden!");
        }
        this.fileNames.add(string2);
    }

    private String normalize(String string) {
        return Text.allBackslashesToSlashes(string);
    }

    public void addAll(FileSet fileSet) {
        for (String string : fileSet) {
            if (this.fileNames.contains(string)) continue;
            this.fileNames.add(string);
        }
    }

    public boolean contains(String string) {
        return this.fileNames.contains(this.normalize(string));
    }

    @Override
    public Iterator<String> iterator() {
        return this.fileNames.iterator();
    }

    public int size() {
        return this.fileNames.size();
    }

    public String get(int n) {
        return this.fileNames.get(n);
    }

    public String toString() {
        return "FileSet [fileNames=" + this.fileNames + "]";
    }

    public boolean remove(String string) {
        return this.fileNames.remove(this.normalize(string));
    }

    public void clear() {
        this.fileNames.clear();
    }

    public boolean isEmpty() {
        return this.fileNames.isEmpty();
    }

    public void sort() {
        Collections.sort(this.fileNames);
    }
}

