/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.lock;

import de.duehl.basics.io.exceptions.FileNotFoundRuntimeException;
import de.duehl.basics.io.exceptions.IORuntimeException;
import de.duehl.basics.io.lock.LockBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;

public class FileLock
extends LockBase {
    private static final boolean DEBUG = false;
    private final String rights;
    private java.nio.channels.FileLock lock;
    private RandomAccessFile file;

    public FileLock(String string) {
        this(string, "rw");
    }

    public FileLock(String string, String string2) {
        super(string);
        this.rights = string2;
        this.lock = null;
        this.file = null;
    }

    @Override
    public boolean lock() {
        this.checkInternalStateLock();
        if (null != this.lock) {
            return false;
        }
        this.say("Versuche Lock auf " + this.filename + " zu erhalten ...");
        boolean bl = this.lockInternal();
        if (bl) {
            this.say("Lock auf " + this.filename + " erhalten.");
            this.say("Lock is shared: " + this.lock.isShared());
        } else {
            this.say("Kein Lock erhalten, lock = " + this.lock);
            this.lock = null;
        }
        this.say("lock null ? " + (this.lock == null));
        this.say("file null ? " + (this.file == null));
        return bl;
    }

    private void checkInternalStateLock() {
        boolean bl;
        boolean bl2 = this.file == null;
        boolean bl3 = bl = this.lock == null;
        if (bl2 != bl) {
            throw new RuntimeException("Interner Fehler. fileIsNull = " + bl2 + ", lockIsNull = " + bl);
        }
    }

    private boolean lockInternal() {
        this.file = this.openRandomAccessFile();
        FileChannel fileChannel = this.file.getChannel();
        this.say("Versuch den exclusiven Lock zu erhalten...");
        this.tryToLock(fileChannel);
        if (null == this.lock) {
            this.say("Lock kann nicht erhalten werden. lock == null.");
            this.closeFile();
            return false;
        }
        return true;
    }

    private RandomAccessFile openRandomAccessFile() {
        try {
            return new RandomAccessFile(this.filename, this.rights);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundRuntimeException(fileNotFoundException);
        }
    }

    private boolean tryToLock(FileChannel fileChannel) {
        try {
            this.lock = fileChannel.tryLock();
        }
        catch (IOException iOException) {
            this.say("Lock kann nicht erhalten werden. IOException.");
            return false;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.say("Lock kann nicht erhalten werden. OverlappingFileLockException.");
            return false;
        }
        return true;
    }

    @Override
    public boolean unlock() {
        this.checkInternalStateLock();
        if (null == this.lock) {
            return false;
        }
        this.say("Versuche Lock auf " + this.filename + " zu l\u00f6sen ...");
        boolean bl = this.tryToUnlock();
        if (bl) {
            this.say("Lock auf " + this.filename + " gel\u00f6st.");
        }
        this.lock = null;
        this.closeFile();
        this.say("lock null ? " + (this.lock == null));
        this.say("file null ? " + (this.file == null));
        return bl;
    }

    private boolean tryToUnlock() {
        try {
            this.lock.release();
        }
        catch (IOException iOException) {
            this.say("L\u00f6sen war nicht erfolgreich: " + iOException.getMessage());
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private void closeFile() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        this.file = null;
    }

    private void say(String string) {
    }
}

