/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.walker;

import de.duehl.basics.collections.Stack;
import de.duehl.basics.io.walker.CaseIgnoringStringComparator;
import de.duehl.basics.io.walker.DirWalkerException;
import de.duehl.basics.io.walker.DirWalkerObserver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DirWalker {
    private final List<DirWalkerObserver> observers;
    private final String startPath;
    private final Stack<String> directories;
    private final List<String> localSubDirectories;
    private final List<String> localFiles;

    public DirWalker(String string) {
        this.startPath = string;
        this.observers = new ArrayList<DirWalkerObserver>();
        this.directories = new Stack();
        this.localSubDirectories = new ArrayList<String>();
        this.localFiles = new ArrayList<String>();
        this.checkIfStartPathIsADirectory();
    }

    private void checkIfStartPathIsADirectory() {
        if (!new File(this.startPath).isDirectory()) {
            throw new DirWalkerException("Das \u00fcbergebene Verzeichnis '" + this.startPath + "' ist kein Verzeichnis im Dateisystem!");
        }
    }

    public void addObserver(DirWalkerObserver dirWalkerObserver) {
        this.observers.add(dirWalkerObserver);
    }

    public void removeObserver(DirWalkerObserver dirWalkerObserver) {
        this.observers.remove(dirWalkerObserver);
    }

    public void walk() {
        this.directories.clear();
        this.directories.push(this.startPath);
        this.walkDirectories();
    }

    private void walkDirectories() {
        while (!this.directories.isEmpty()) {
            String string = this.directories.pop();
            this.workOnDirectory(string);
        }
    }

    private void workOnDirectory(String string) {
        File file = this.buildDirAsFile(string);
        this.clearLocalFilesAndDirectoriesLists();
        this.determineLocalFilesAndDirectories(file);
        this.workOnLocalFilesAndDirectories(string);
    }

    private File buildDirAsFile(String string) {
        File file = new File(string);
        return file;
    }

    private void clearLocalFilesAndDirectoriesLists() {
        this.localSubDirectories.clear();
        this.localFiles.clear();
    }

    private void determineLocalFilesAndDirectories(File file) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                this.localSubDirectories.add(file2.getPath());
                continue;
            }
            this.localFiles.add(file2.getPath());
        }
    }

    private void workOnLocalFilesAndDirectories(String string) {
        if (this.localSubDirectories.isEmpty() && this.localFiles.isEmpty()) {
            this.visitEmptyDir(string);
        } else {
            this.visitNotEmptyDir(string);
            this.workOnLocalSubDirectories();
            this.workOnLocalFiles();
        }
    }

    private void workOnLocalSubDirectories() {
        Collections.sort(this.localSubDirectories, new CaseIgnoringStringComparator());
        Collections.reverse(this.localSubDirectories);
        for (String string : this.localSubDirectories) {
            this.directories.push(string);
        }
    }

    private void workOnLocalFiles() {
        Collections.sort(this.localFiles, new CaseIgnoringStringComparator());
        for (String string : this.localFiles) {
            this.visitFile(string);
        }
    }

    private void visitFile(String string) {
        for (DirWalkerObserver dirWalkerObserver : this.observers) {
            dirWalkerObserver.visitFile(string);
        }
    }

    private void visitEmptyDir(String string) {
        for (DirWalkerObserver dirWalkerObserver : this.observers) {
            dirWalkerObserver.visitEmptyDir(string);
        }
    }

    private void visitNotEmptyDir(String string) {
        for (DirWalkerObserver dirWalkerObserver : this.observers) {
            dirWalkerObserver.visitNotEmptyDir(string);
        }
    }
}

