/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.java;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.java.data.EnumAnalyseState;
import de.duehl.basics.java.data.EnumDefinition;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaEnumAnalyser {
    private final List<String> lines;
    private List<EnumDefinition> enumDefinitons;
    private EnumAnalyseState state;
    private String actualLine;
    private String rest;
    private String actualDefiniton;
    private String actualBraceContent;
    private static final String DEFINITION_LINE_START = "    ";
    private static final String DEFINITION_LINE_END_KOMMA = ",";
    private static final String DEFINITION_LINE_END_SEMIKOLON = ";";
    private static final String ENUM_DEFINITION_WORD_REGEX = "[A-Z\u00c4\u00d6\u00dc][_A-Z\u00c4\u00d6\u00dc0-9]*";
    private static final Pattern ENUM_DEFINITION_WORD_PATTERN = Pattern.compile("[A-Z\u00c4\u00d6\u00dc][_A-Z\u00c4\u00d6\u00dc0-9]*");
    private static final String OPTIONAL_BRACE_START = "(";
    private static final String OPTIONAL_BRACE_END = ")";

    public JavaEnumAnalyser(String string) {
        this.lines = FileHelper.readFileToList(string, Charset.UTF_8);
    }

    public JavaEnumAnalyser(List<String> list) {
        this.lines = list;
    }

    public void analyse() {
        this.enumDefinitons = new ArrayList<EnumDefinition>();
        this.state = EnumAnalyseState.FIRST_NOT_FOUND;
        Iterator<String> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            String string;
            this.actualLine = string = iterator.next();
            this.analyseLine();
        }
        this.checkDefinitionsAreDisjunct();
    }

    private void analyseLine() {
        switch (this.state) {
            case FIRST_NOT_FOUND: 
            case DEFINITION_CLOSED: {
                this.searchForDefinitonStart();
                break;
            }
            case DEFINITION_STARTED_BUT_NOT_CLOSED: {
                this.analyseLineWithAdditionalBraceContent();
                break;
            }
            case ALL_DEFINITIONS_CLOSED: {
                break;
            }
            default: {
                throw new RuntimeException("Unbekannter EnumAnalyseState '" + this.state + "'");
            }
        }
    }

    private void searchForDefinitonStart() {
        if (this.actualLine.startsWith(DEFINITION_LINE_START)) {
            this.rest = this.actualLine.substring(DEFINITION_LINE_START.length());
            this.rest = this.rest.strip();
            if (!this.rest.isEmpty()) {
                this.analyseLineWithStartingDefiniton();
            }
        }
    }

    private void analyseLineWithStartingDefiniton() {
        if (this.rest.startsWith(DEFINITION_LINE_END_SEMIKOLON)) {
            this.state = EnumAnalyseState.ALL_DEFINITIONS_CLOSED;
            return;
        }
        this.state = EnumAnalyseState.DEFINITION_STARTED_BUT_NOT_CLOSED;
        Matcher matcher = ENUM_DEFINITION_WORD_PATTERN.matcher(this.rest);
        boolean bl = matcher.find();
        if (!bl) {
            throw new RuntimeException("Analysefehler bei Definition, sie wird nicht gefunden:\n\tactualLine = '" + this.actualLine + "'\n\trest       = '" + this.rest + "'\n");
        }
        if (matcher.start() > 0) {
            throw new RuntimeException("Analysefehler bei Definition, sie wird zu weit hinten gefunden:\n\tactualLine      = '" + this.actualLine + "'\n\trest            = '" + this.rest + "'\n\tmatcher.start() = '" + matcher.start() + "'\n");
        }
        this.actualDefiniton = matcher.group();
        this.rest = this.rest.substring(this.actualDefiniton.length());
        this.rest = this.rest.strip();
        this.analyseAfterDefintion();
    }

    private void analyseAfterDefintion() {
        if (this.rest.startsWith(OPTIONAL_BRACE_START)) {
            this.actualBraceContent = "";
            this.rest = this.rest.substring(OPTIONAL_BRACE_START.length());
            this.analyseInBrace();
        } else {
            this.actualBraceContent = "";
            this.analyseRestAfterBraceOrWithoutBrace();
        }
    }

    private void analyseInBrace() {
        int n;
        int n2 = Text.countPartInString(this.actualBraceContent, OPTIONAL_BRACE_START);
        int n3 = Text.countPartInString(this.actualBraceContent, OPTIONAL_BRACE_END);
        int n4 = Text.countPartInString(this.rest, OPTIONAL_BRACE_START);
        int n5 = Text.countPartInString(this.rest, OPTIONAL_BRACE_END);
        int n6 = n3 + n5;
        if (n6 > (n = n2 + n4)) {
            int n7 = this.rest.lastIndexOf(OPTIONAL_BRACE_END);
            this.actualBraceContent = Text.concatenate(this.actualBraceContent, this.rest.substring(0, n7));
            this.rest = this.rest.substring(n7 + 1);
            this.analyseRestAfterBraceOrWithoutBrace();
        } else {
            this.actualBraceContent = Text.concatenate(this.actualBraceContent, this.rest);
            this.state = EnumAnalyseState.DEFINITION_STARTED_BUT_NOT_CLOSED;
        }
    }

    private void analyseRestAfterBraceOrWithoutBrace() {
        if (this.rest.equals(DEFINITION_LINE_END_KOMMA)) {
            this.state = EnumAnalyseState.DEFINITION_CLOSED;
        } else if (this.rest.equals(DEFINITION_LINE_END_SEMIKOLON)) {
            this.state = EnumAnalyseState.ALL_DEFINITIONS_CLOSED;
        } else if (!this.rest.isEmpty()) {
            throw new RuntimeException("Analysefehler bei Definition ohne Klammer:\n\tactualLine = '" + this.actualLine + "'\n\trest  = '" + this.rest + "'\n");
        }
        EnumDefinition enumDefinition = new EnumDefinition(this.actualDefiniton, this.actualBraceContent);
        this.enumDefinitons.add(enumDefinition);
    }

    private void analyseLineWithAdditionalBraceContent() {
        this.rest = this.actualLine.strip();
        this.analyseInBrace();
    }

    private void checkDefinitionsAreDisjunct() {
        List list;
        HashMap hashMap = new HashMap();
        for (EnumDefinition object : this.enumDefinitons) {
            String string = object.getDefinition();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            list = (List)hashMap.get(string);
            list.add(object);
        }
        ArrayList arrayList = new ArrayList();
        for (String string : hashMap.keySet()) {
            list = (List)hashMap.get(string);
            if (list.size() == 1) continue;
            arrayList.add("Zur Definition '" + string + "' wurde nicht genau ein Eintrag gefunden.");
            for (EnumDefinition enumDefinition : list) {
                arrayList.add(DEFINITION_LINE_START + enumDefinition.getDefinition() + OPTIONAL_BRACE_START + enumDefinition.getBraceContent() + OPTIONAL_BRACE_END);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new RuntimeException("Analysefehler: Mehrfach gefundene Definitionen:\n" + Text.joinWithLineBreak(arrayList));
        }
    }

    public int getNumberOfDefinitions() {
        return this.enumDefinitons.size();
    }

    public List<EnumDefinition> getEnumDefinitons() {
        return this.enumDefinitons;
    }

    public int countDefinitionsWithPartInBrace(String string) {
        int n = 0;
        for (EnumDefinition enumDefinition : this.enumDefinitons) {
            String string2 = enumDefinition.getBraceContent();
            if (!string2.contains(string)) continue;
            ++n;
        }
        return n;
    }
}

