/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.logging;

import de.duehl.basics.datetime.Timestamp;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logging.LogEntry;
import de.duehl.basics.logging.StructuredLogger;
import de.duehl.basics.logging.eraser.LogEraser;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public class FileLogger
extends StructuredLogger {
    private String logFileName;
    private final List<String> columnHeaders;

    FileLogger(String string) {
        this.logFileName = string;
        FileHelper.createEmptyFile(string);
        this.columnHeaders = new ArrayList<String>();
        this.initColumnHeaders();
    }

    private void initColumnHeaders() {
        this.columnHeaders.add("Datum");
        this.columnHeaders.add("Zeit");
        this.columnHeaders.add("Klasse");
        this.columnHeaders.add("Methode");
        this.columnHeaders.add("Zeilennummer");
        this.columnHeaders.add("Nachricht");
    }

    @Override
    public void log(String string) {
        this.log(string, 1);
    }

    @Override
    public synchronized void log(String string, int n) {
        super.log(string, n);
        LogEntry logEntry = this.getLastLogEntry();
        String string2 = logEntry.asLine();
        this.logInternal(string2);
    }

    void logTitle() {
        String string = Text.joinWithTabulator(this.columnHeaders);
        this.logInternal(string);
    }

    private synchronized void logInternal(String string) {
        FileLogger.checkNoLineBreaks(string);
        FileHelper.appendLineToFile(string, this.logFileName);
    }

    static void checkNoLineBreaks(String string) {
        if (Text.countLineBreaks(string) > 0) {
            throw new RuntimeException("Zeilenumbr\u00fcche in Lognachricht!");
        }
    }

    public void switchLogPath(String string) {
        FileLogger.checkIfPathExistsAndIsDirectory(string);
        String string2 = this.getLogFileName();
        String string3 = FileHelper.getBareName(string2);
        String string4 = FileHelper.getDirName(string2);
        String string5 = Timestamp.switchDateTimePartInName(string3);
        String string6 = FileHelper.concatPathes(string, string5);
        FileLogger.checkThatFileDoesNotExists(string6);
        this.log("Wechsel des Pfades der Logdateien von " + string4 + " nach " + string + ".", 0);
        this.log("Alte Logdatei: " + string2, 0);
        this.log("Neue Logdatei: " + string6, 0);
        this.logFileName = string6;
        this.log("Im laufenden Programm wurde der Pfad der Logdateien von " + string4 + " auf " + string + " ge\u00e4ndert.", 0);
        this.log("Alte Logdatei: " + string2, 0);
        this.log("Neue Logdatei: " + this.getLogFileName(), 0);
    }

    static void checkIfPathExistsAndIsDirectory(String string) {
        if (FileHelper.isNotADirectory(string)) {
            throw new IllegalArgumentException("Pfad '" + string + "' nicht gefunden!");
        }
    }

    private static void checkThatFileDoesNotExists(String string) {
        if (FileHelper.exists(string)) {
            throw new IllegalArgumentException("Datei '" + string + "' existiert bereits!");
        }
    }

    @Override
    public String getLogFileName() {
        return this.logFileName;
    }

    @Override
    public String getLogPath() {
        return FileHelper.getDirName(this.logFileName);
    }

    @Override
    public int getLastWrittenLineNumber() {
        return super.getLastWrittenLineNumber() + 1;
    }

    public String toString() {
        return "FileLogger [logFileName=" + this.logFileName + "]";
    }

    public static FileLogger create(String string, String string2, String string3) {
        FileHelper.createDirectoryWithMissingSubdirectoriesIfNotExists(string3);
        FileLogger.checkIfPathExistsAndIsDirectory(string3);
        FileLogger fileLogger = new FileLogger(FileLogger.createLogFileName(string, string2, string3));
        fileLogger.logTitle();
        fileLogger.log("Gestartet");
        LogEraser logEraser = new LogEraser(string3, string, string2, fileLogger);
        logEraser.erase();
        return fileLogger;
    }

    static String createLogFileName(String string, String string2, String string3) {
        Object object = string.endsWith("_") ? string : string + "_";
        String string4 = string2.startsWith("_") || string2.startsWith(".") ? string2 : "_" + string2;
        String string5 = (String)object + Timestamp.fullTimestamp() + string4;
        String string6 = FileHelper.concatPathes(string3, string5);
        return string6;
    }
}

