/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.replacements;

import de.duehl.basics.text.NumberString;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplacementHelper {
    public static <T> T matcherGroupWithPositionToListElement(Matcher matcher, int n, List<T> list) {
        String string = matcher.group(n);
        int n2 = NumberString.parseInt(string);
        int n3 = n2 - 1;
        T t = list.get(n3);
        return t;
    }

    public static int determinePlaceholderEndIndex(String string, int n) {
        int n2 = string.indexOf(">>", n);
        if (n2 == -1) {
            return -1;
        }
        return n2 + ">>".length();
    }

    public static int determinePlaceholderPosition(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            throw new RuntimeException("Keinen Doppelpunkt in einem Platzhalter der Art <<begriff:13>> gefunden.\n\tplaceholder : '" + string + "'\n");
        }
        int n2 = string.indexOf(">>");
        if (n2 == -1) {
            throw new RuntimeException("Kein >> in einem Platzhalter der Art <<begriff:13>> gefunden.\n\tplaceholder : '" + string + "'\n");
        }
        if (n2 <= n) {
            throw new RuntimeException("In einem Platzhalter der Art <<begriff:13>> wurde >> vor dem Doppelpunkt gefunden.\n\tplaceholder : '" + string + "'\n");
        }
        String string2 = string.substring(n + 1, n2);
        if (!NumberString.isDigitSequence(string2)) {
            throw new RuntimeException("In einem Platzhalter der Art <<begriff:13>> wurde die Position falsch ermittelt.\n\tplaceholder   : '" + string + "'\n\tpositionString: '" + string2 + "'\n");
        }
        return NumberString.parseInt(string2);
    }

    public static int searchStartIndexToEndIndexOfPlaceholder(String string, int n) {
        String string2 = string.substring(0, n);
        if (!string2.endsWith(">>")) {
            throw new RuntimeException("Der Text endet an der angegebenen Position nicht auf '>>'.\n\ttext    : '" + string + "'\n\tendIndex: " + n + "\n");
        }
        return string2.lastIndexOf("<<");
    }

    public static boolean endsTextWithPlaceholder(String string, int n, String string2) {
        String string3 = string.substring(0, n);
        Pattern pattern = Pattern.compile("<<" + string2 + ":\\d+>>$");
        Matcher matcher = pattern.matcher(string3);
        return matcher.find();
    }

    public static String determinePlaceholderFrontPart(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            throw new RuntimeException("Keinen Doppelpunkt in einem Platzhalter der Art <<begriff:13>> gefunden.\n\tplaceholder : '" + string + "'\n");
        }
        if (!string.startsWith("<<")) {
            throw new RuntimeException("Der Platzhalter der Art <<begriff:13>> beginnt nicht mit '<<'.\n\tplaceholder : '" + string + "'\n");
        }
        String string2 = string.substring("<<".length(), n);
        if (string2.isBlank()) {
            throw new RuntimeException("Der vordere Teil im Platzhalter der Art <<begriff:13>> ist leer.\n\tplaceholder : '" + string + "'\n");
        }
        return string2;
    }

    public static int countPlaceholders(String string, String string2) {
        String string3 = "<<" + string2 + ":(\\d+)>>";
        Pattern pattern = Pattern.compile(string3);
        return ReplacementHelper.countPlaceholders(string, pattern);
    }

    public static int countPlaceholders(String string, Pattern pattern) {
        int n = 0;
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            ++n;
        }
        return n;
    }

    public static List<Integer> getPositionsOfPlaceholders(String string, Pattern pattern) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int n = NumberString.parseIntIgnore(matcher.group(1), -1);
            arrayList.add(n);
        }
        return arrayList;
    }
}

