/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.replacements;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.replacements.ReplacementsAnalyser;
import de.duehl.basics.replacements.data.FoundPlaceholder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ReplacementSorter<T> {
    private String text;
    private final String tag;
    private final List<T> foundDataList;
    private List<FoundPlaceholder> foundPlaceholdersWithTag;

    public ReplacementSorter(String string, String string2, List<T> list) {
        this.text = string;
        this.tag = string2;
        this.foundDataList = list;
    }

    public void sort() {
        this.findReplacementsOfTag();
        if (this.sizesAreEqual() && !this.foundDataList.isEmpty()) {
            this.reallySort();
        }
    }

    private void findReplacementsOfTag() {
        ReplacementsAnalyser replacementsAnalyser = new ReplacementsAnalyser(this.text);
        replacementsAnalyser.analyse();
        Map<String, List<FoundPlaceholder>> map = replacementsAnalyser.getPlaceHoldersByName();
        this.foundPlaceholdersWithTag = map.containsKey(this.tag) ? map.get(this.tag) : new ArrayList<FoundPlaceholder>();
    }

    private boolean sizesAreEqual() {
        return this.foundDataList.size() == this.foundPlaceholdersWithTag.size();
    }

    private void reallySort() {
        List<Integer> list = this.createPositions();
        List<Integer> list2 = this.createWantedPositions(list);
        this.checkPositionsAndWantedPositions(list, list2);
        this.sortFoundDataList(list, list2);
        this.changeText(list, list2);
    }

    private List<Integer> createPositions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (FoundPlaceholder foundPlaceholder : this.foundPlaceholdersWithTag) {
            int n = foundPlaceholder.getPosition();
            arrayList.add(n);
        }
        return arrayList;
    }

    private List<Integer> createWantedPositions(List<Integer> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(list);
        Collections.sort(arrayList);
        return arrayList;
    }

    private void checkPositionsAndWantedPositions(List<Integer> list, List<Integer> list2) {
        for (int n : list2) {
            if (n >= 1 && n <= list.size()) continue;
            throw new RuntimeException("Die gew\u00fcnschte Position ist unzul\u00e4ssig.\n\tgew\u00fcnschte Position: " + n + "\n\tkleinste zul\u00e4ssige Position: 1\n\tgr\u00f6\u00dfte zul\u00e4ssige Position: " + list.size() + "\n\ttext: " + this.text + "\n\ttag: " + this.tag + "\nListe mit den Positionen:\n" + CollectionsHelper.listListNice(list) + "Liste mit den gew\u00fcnschten Positionen:\n" + CollectionsHelper.listListNice(list2) + "Liste mit den gefundenen Informationen:\n" + CollectionsHelper.listListNice(this.foundDataList) + "Liste mit den Platzhaltern im Text zum Tag:\n" + CollectionsHelper.listListNice(this.foundPlaceholdersWithTag));
        }
    }

    private void sortFoundDataList(List<Integer> list, List<Integer> list2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int n : list2) {
            int n2 = list.get(n - 1);
            int n3 = n2 - 1;
            T t = this.foundDataList.get(n3);
            arrayList.add(t);
        }
        this.foundDataList.clear();
        this.foundDataList.addAll(arrayList);
    }

    private void changeText(List<Integer> list, List<Integer> list2) {
        int n = list2.get(list2.size() - 1) + 10;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n2 : list) {
            int n3 = n2 + n;
            arrayList.add(n3);
        }
        this.replacePlaceholdersInText(list, arrayList);
        this.replacePlaceholdersInText(arrayList, list2);
    }

    private void replacePlaceholdersInText(List<Integer> list, List<Integer> list2) {
        for (int i = 0; i < list.size(); ++i) {
            int n = list.get(i);
            int n2 = list2.get(i);
            String string = "<<" + this.tag + ":" + n + ">>";
            String string2 = "<<" + this.tag + ":" + n2 + ">>";
            this.text = this.text.replace(string, string2);
        }
    }

    public String getText() {
        return this.text;
    }

    public static ReplacementSorter<String> createSorterWithoutFoundDataList(String string, String string2) {
        return new ReplacementSorter<String>(string, string2, ReplacementSorter.createDummyfoundDataList(string, string2));
    }

    private static List<String> createDummyfoundDataList(String string, String string2) {
        List<Object> list;
        ReplacementsAnalyser replacementsAnalyser = new ReplacementsAnalyser(string);
        replacementsAnalyser.analyse();
        Map<String, List<FoundPlaceholder>> map = replacementsAnalyser.getPlaceHoldersByName();
        int n = 0;
        if (map.containsKey(string2)) {
            list = map.get(string2);
            n = list.size();
        }
        list = new ArrayList();
        for (int i = 0; i < n; ++i) {
            list.add("dummy");
        }
        return list;
    }
}

