/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.system.starter;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FineFileWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ProgramStarter {
    private static final boolean DEBUG = false;
    private final String programBinary;
    private final List<String> parameters;
    private final String logFilename;
    private final String errorLogfilename;

    public ProgramStarter(String string, List<String> list, String string2, String string3) {
        this.programBinary = string;
        this.parameters = list;
        this.logFilename = string2;
        this.errorLogfilename = string3;
    }

    public void runAndWait() {
        List<String> list = this.createParameterList();
        String[] stringArray = CollectionsHelper.stringListToArray(list);
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        Process process = this.startProcessBuilder(processBuilder);
        this.waitForProcessAndWriteStreams(process);
    }

    private List<String> createParameterList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.programBinary.contains(" ")) {
            arrayList.add("\"" + this.programBinary + "\"");
        } else {
            arrayList.add(this.programBinary);
        }
        arrayList.addAll(this.parameters);
        ProgramStarter.say("Parameterliste:");
        for (String string : arrayList) {
            ProgramStarter.say("    " + string);
        }
        return arrayList;
    }

    private Process startProcessBuilder(ProcessBuilder processBuilder) {
        try {
            return processBuilder.start();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Es trat ein Fehler bei der Ausf\u00fchrung des Programms auf.", iOException);
        }
    }

    private void waitForProcessAndWriteStreams(Process process) {
        this.waitForProcess(process);
        this.writeOutputStream(process);
        this.writeErrorStream(process);
    }

    private void waitForProcess(Process process) {
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void writeOutputStream(Process process) {
        ProgramStarter.writeStream(process.getInputStream(), this.logFilename, "Outputs");
    }

    private void writeErrorStream(Process process) {
        ProgramStarter.writeStream(process.getErrorStream(), this.errorLogfilename, "Fehler-Outputs");
    }

    private static void writeStream(InputStream inputStream, String string, String string2) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        FineFileWriter fineFileWriter = new FineFileWriter(string);
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                fineFileWriter.writeln(string3);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Es trat ein Fehler bei der Ausf\u00fchrung des Programms beim Ermitteln des " + string2 + " auf.", iOException);
        }
        fineFileWriter.close();
    }

    private static void say(String string) {
    }
}

