/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.xml;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Lines;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.xml.NamedXmlParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlAnalyser {
    private static final Pattern ANY_PARAMETER_PATTERN = Pattern.compile("[-_A-Za-z0-9]+ *= *(?:\"([^\"]+)\"|(\\d+))");
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("([-_A-Za-z0-9]+) *= *\"([^\"]+)\"");
    private static final Pattern PARAMETER_WITHOUT_QUOTES_PATTERN = Pattern.compile("([-_A-Za-z0-9]+) *= *(\\d+)");

    private XmlAnalyser() {
    }

    public static List<String> getLinesInTag(List<String> list, String string) {
        String string2 = "<" + string + ">";
        String string3 = "<" + string + " ";
        String string4 = "</" + string + ">";
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (String string5 : list) {
            if (string5.contains(string2) || string5.contains(string3)) {
                arrayList.add(string5);
                bl = true;
                continue;
            }
            if (string5.contains(string4)) {
                arrayList.add(string5);
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(string5);
        }
        if (arrayList.isEmpty()) {
            throw new RuntimeException("In den eingelesenen Zeilen wurde kein Abschnitt mit dem Tag '" + string + "' gefunden! Die Zeilen sind:\n\t" + Text.joinWithLineBreak(list));
        }
        return arrayList;
    }

    public static Lines getLinesInTag(Lines lines, String string) {
        List<String> list = lines.getLines();
        List<String> list2 = XmlAnalyser.getLinesInTag(list, string);
        return new Lines(list2);
    }

    public static List<List<String>> getMultipleLinesInTag(List<String> list, String string) {
        List<List<String>> list2 = XmlAnalyser.getMultipleLinesInTagAllowEmptyList(list, string);
        if (list2.isEmpty()) {
            throw new RuntimeException("In den eingelesenen Zeilen wurde kein Abschnitt mit dem Tag '" + string + "' gefunden! Die Zeilen sind:\n\t" + Text.joinWithLineBreak(list));
        }
        return list2;
    }

    public static List<List<String>> getMultipleLinesInTagAllowEmptyList(List<String> list, String string) {
        String string2 = "<" + string + ">";
        String string3 = "<" + string + " ";
        String string4 = "</" + string + ">";
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = null;
        boolean bl = false;
        for (String string5 : list) {
            if (string5.contains(string2) || string5.contains(string3)) {
                arrayList2 = new ArrayList<String>();
                arrayList2.add(string5);
                if (string5.contains(string4)) {
                    arrayList.add(arrayList2);
                    arrayList2 = null;
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (string5.contains(string4)) {
                arrayList2.add(string5);
                arrayList.add(arrayList2);
                arrayList2 = null;
                bl = false;
                continue;
            }
            if (!bl) continue;
            arrayList2.add(string5);
        }
        return arrayList;
    }

    public static List<Lines> getMultipleLinesInTag(Lines lines, String string) {
        List<String> list = lines.getLines();
        List<List<String>> list2 = XmlAnalyser.getMultipleLinesInTag(list, string);
        return Lines.createListOfLinesFromListOfListOfStrings(list2);
    }

    public static List<List<String>> getMultipleLinesInTagWithoutOpeningAndClosingTag(List<String> list, String string) {
        List<List<String>> list2 = XmlAnalyser.getMultipleLinesInTag(list, string);
        for (List<String> list3 : list2) {
            if (list3.size() > 2) {
                list3.remove(list3.size() - 1);
                list3.remove(0);
                continue;
            }
            String string2 = list3.get(0);
            string2 = string2.replaceAll("<" + Pattern.quote(string) + "[^<>]*>", "");
            string2 = string2.replaceAll("</" + Pattern.quote(string) + ">", "");
            string2 = string2.trim();
            list3.remove(0);
            list3.add(string2);
        }
        return list2;
    }

    public static List<Lines> getMultipleLinesInTagWithoutOpeningAndClosingTag(Lines lines, String string) {
        List<String> list = lines.getLines();
        List<List<String>> list2 = XmlAnalyser.getMultipleLinesInTagWithoutOpeningAndClosingTag(list, string);
        return Lines.createListOfLinesFromListOfListOfStrings(list2);
    }

    public static String getFullTagInLine(List<String> list, String string) {
        String string2 = "<" + string + ">";
        String string3 = "<" + string + " ";
        String string4 = "</" + string + ">";
        for (String string5 : list) {
            if (!string5.contains(string2) && !string5.contains(string3) || !string5.contains(string4)) continue;
            return string5;
        }
        throw new RuntimeException("In den eingelesenen Zeilen wurde keine Zeile mit dem Tag '" + string + "' gefunden! Die Zeilen sind:\n\t" + Text.joinWithLineBreak(list));
    }

    public static String getContentInTag(String string, String string2) {
        String string3 = "<" + string2 + ">";
        String string4 = "<" + string2 + " ";
        String string5 = "</" + string2 + ">";
        int n = string.indexOf(string5);
        if (n == -1) {
            throw new RuntimeException("Keinen schlie\u00dfenden Tag '" + string5 + "' in der Zeile '" + string + "' gefunden!");
        }
        int n2 = string.indexOf(string3);
        int n3 = string.indexOf(string4);
        if (n2 == -1 && n3 == -1) {
            throw new RuntimeException("Keinen \u00f6ffnenden Tag (weder '" + string3 + "'  noch '" + string4 + "') in der Zeile '" + string + "' gefunden!");
        }
        int n4 = 0;
        if (n2 > 0) {
            n4 = n2 + string3.length();
        } else {
            n4 = string.indexOf(">", n3);
            if (n4 == -1) {
                throw new RuntimeException("Es wurde kein '>' hinter dem \u00f6ffnenden Tag '" + string4 + "' in der Zeile '" + string + "' gefunden!");
            }
            ++n4;
        }
        String string6 = string.substring(n4, n);
        return string6;
    }

    public static String getContentInFullTagLine(List<String> list, String string) {
        String string2 = XmlAnalyser.getFullTagInLine(list, string);
        String string3 = XmlAnalyser.getContentInTag(string2, string);
        return string3;
    }

    public static String getContentInFullTagLineErrorToBlank(List<String> list, String string) {
        try {
            return XmlAnalyser.getContentInFullTagLine(list, string);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static List<NamedXmlParameter> getParametersFromOpeningTag(String string, String string2) {
        String string3 = "<" + string2 + " ";
        int n = string.indexOf(string3);
        if (n == -1) {
            throw new RuntimeException("Zum Tag '" + string2 + "' wurd das \u00f6ffnenden Tag '" + string3 + "' nicht gefunden in der Zeile '" + string + "'!");
        }
        int n2 = string.indexOf(">", n);
        if (n2 == -1) {
            throw new RuntimeException("Nach dem \u00f6ffnenden Tag '" + string3 + "' wurde kein '>' mehr gefunden in der Zeile '" + string + "'!");
        }
        String string4 = string.substring(n + 2 + string2.length(), n2);
        ArrayList<NamedXmlParameter> arrayList = new ArrayList<NamedXmlParameter>();
        Matcher matcher = ANY_PARAMETER_PATTERN.matcher(string4);
        while (matcher.find()) {
            Object object;
            String string5;
            Object object2;
            String string6 = matcher.group();
            Matcher matcher2 = PARAMETER_PATTERN.matcher(string6);
            if (matcher2.find()) {
                object2 = matcher2.group(1);
                string5 = matcher2.group(2);
                object = new NamedXmlParameter((String)object2, string5);
                arrayList.add((NamedXmlParameter)object);
                continue;
            }
            object2 = PARAMETER_WITHOUT_QUOTES_PATTERN.matcher(string6);
            if (((Matcher)object2).find()) {
                string5 = ((Matcher)object2).group(1);
                object = ((Matcher)object2).group(2);
                NamedXmlParameter namedXmlParameter = new NamedXmlParameter(string5, (String)object);
                arrayList.add(namedXmlParameter);
                continue;
            }
            throw new RuntimeException("Ein gefundener Parameter war weder eine mit noch ohne Anf\u00fchrungszeichen.\n\tline      = " + string + "\n\ttag       = " + string2 + "\n\tparamPart = " + string4 + "\n\tfound     = " + string6 + "\n");
        }
        return arrayList;
    }

    public static String determineLineWithOpeningTag(List<String> list, String string) {
        for (String string2 : list) {
            if (!string2.contains("<" + string)) continue;
            return string2;
        }
        throw new RuntimeException("Es wurde kein \u00f6ffnendes Tag '" + string + "' in den \u00fcbergebenen Zeilen gefunden.\n\tlines = " + list);
    }

    public static boolean existsOpeningTag(List<String> list, String string) {
        for (String string2 : list) {
            if (!XmlAnalyser.existsOpeningTag(string2, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean existsOpeningTag(String string, String string2) {
        return string.contains("<" + string2);
    }

    public static boolean existsClosingTag(String string, String string2) {
        return string.contains("</" + string2);
    }

    public static int getFirstOpeningTagIndex(List<String> list, String string) {
        return XmlAnalyser.getFirstOpeningTagIndex(list, string, 0);
    }

    public static int getFirstOpeningTagIndex(List<String> list, String string, int n) {
        String string2 = "<" + string + ">";
        String string3 = "<" + string + " ";
        int n2 = CollectionsHelper.determineIndexOfFirstElementContaining(list, string2, n);
        int n3 = CollectionsHelper.determineIndexOfFirstElementContaining(list, string3, n);
        if (n2 == -1) {
            return n3;
        }
        if (n3 == -1) {
            return n2;
        }
        return Math.min(n2, n3);
    }

    public static int getFirstClosingTagIndex(List<String> list, String string) {
        return XmlAnalyser.getFirstClosingTagIndex(list, string, 0);
    }

    public static int getFirstClosingTagIndex(List<String> list, String string, int n) {
        String string2 = "</" + string;
        return CollectionsHelper.determineIndexOfFirstElementContaining(list, string2, n);
    }

    public static List<Integer> getAllOpeningTagIndices(List<String> list, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = true;
        int n = 0;
        while (bl) {
            int n2 = XmlAnalyser.getFirstOpeningTagIndex(list, string, n);
            if (n2 == -1) {
                bl = false;
                continue;
            }
            arrayList.add(n2);
            n = n2 + 1;
        }
        return arrayList;
    }

    public static List<List<String>> cutAtOpeningTag(List<String> list, String string) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        List<Integer> list2 = XmlAnalyser.getAllOpeningTagIndices(list, string);
        if (list2.isEmpty()) {
            arrayList.add(list);
        } else {
            int n;
            int n2 = list2.get(0);
            if (n2 > 0) {
                List<String> list3 = CollectionsHelper.sublist(list, 0, n2);
                arrayList.add(list3);
            }
            for (n = 0; n < list2.size() - 1; ++n) {
                int n3 = list2.get(n);
                int n4 = list2.get(n + 1);
                List<String> list4 = CollectionsHelper.sublist(list, n3, n4);
                arrayList.add(list4);
            }
            n = list2.get(list2.size() - 1);
            List<String> list5 = CollectionsHelper.sublist(list, n, list.size());
            arrayList.add(list5);
        }
        return arrayList;
    }

    public static List<String> getInnerPartIfStartsAndEndsWithTag(List<String> list, String string) {
        if (list.isEmpty()) {
            throw new RuntimeException("Wurde mit leerer Liste aufgerufen.");
        }
        if (XmlAnalyser.linesStartsWithTag(list, string) && XmlAnalyser.linesEndsWithTag(list, string)) {
            List<String> list2 = CollectionsHelper.sublistWithoutFirstAndLastLine(list);
            return list2;
        }
        return new ArrayList<String>();
    }

    public static boolean linesStartsWithTag(List<String> list, String string) {
        if (list.isEmpty()) {
            throw new RuntimeException("Wurde mit leerer Liste aufgerufen.");
        }
        String string2 = "<" + string + ">";
        String string3 = "<" + string + " ";
        String string4 = list.get(0);
        return string4.contains(string2) || string4.contains(string3);
    }

    public static boolean linesEndsWithTag(List<String> list, String string) {
        if (list.isEmpty()) {
            throw new RuntimeException("Wurde mit leerer Liste aufgerufen.");
        }
        String string2 = list.get(list.size() - 1);
        String string3 = "</" + string;
        return string2.contains(string3);
    }
}

