/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.html.download;

import de.duehl.basics.debug.Assure;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.system.ExceptionHelper;
import de.duehl.basics.text.html.UrlHelper;
import de.duehl.html.download.Downloader;
import de.duehl.html.download.data.DownloadInfo;
import de.duehl.html.download.data.DownloadInfoWithRedirects;
import de.duehl.html.download.proxy.DownloadProxyList;
import de.duehl.html.download.proxy.Proxy;
import java.util.List;

public class DownloaderWithOwnRedirectHandling {
    private static final String NAVIGATIONSHILFE1_T_ONLINE = "http://navigationshilfe1.t-online.de/";
    private static final int NUMBER_OF_TRIES = 10;
    private static final int SECONDS_TO_SLEEP_BETWEEN_TRIES = 120;
    private static final int SECONDS_BEFORE_KILL_DOWNLOAD = 30;
    private static final long MILLISECONDS_BETWEEN_WATCHING_DOWNLOAD = 10L;
    private static final int MAXIMUM_HOP_NUMBER = 10;
    private String url;
    private final List<Proxy> proxies;
    private final Logger logger;
    private int hopCount = 0;
    private boolean downloadDone = false;
    private DownloadInfoWithRedirects infoWithRedirects;

    private DownloaderWithOwnRedirectHandling(String string, DownloadProxyList downloadProxyList, Logger logger) {
        this.url = string;
        this.logger = logger;
        this.proxies = downloadProxyList.getDownloadProxies();
        this.hopCount = 0;
        this.downloadDone = false;
        this.infoWithRedirects = new DownloadInfoWithRedirects(string);
    }

    DownloadInfoWithRedirects download() {
        try {
            this.tryToDownload();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return this.infoWithRedirects;
    }

    private void tryToDownload() {
        this.log("downloading url " + this.url);
        Assure.isFalse(this.downloadDone);
        while (!this.downloadDone) {
            this.downloadLoop();
        }
    }

    private void downloadLoop() {
        ++this.hopCount;
        this.log("Loop-Start, hopCount = " + this.hopCount);
        this.log("url = " + this.url);
        if (this.hopCount > 10) {
            this.log("Zu viele redirects, Abbruch!");
            this.infoWithRedirects.tooMuchRedirects();
            this.downloadDone = true;
            return;
        }
        DownloadInfo downloadInfo = this.downloadActualUrlAndStoreDownloadInfo();
        this.handleRedirects(downloadInfo);
        this.handelCanceledDownload(downloadInfo);
    }

    private DownloadInfo downloadActualUrlAndStoreDownloadInfo() {
        DownloadInfo downloadInfo = this.downloadUrl();
        if (this.infoWithRedirects.isHopKnown(downloadInfo)) {
            this.infoWithRedirects.redirectCycleDetected();
            this.downloadDone = true;
        } else {
            this.infoWithRedirects.addHop(downloadInfo);
        }
        return downloadInfo;
    }

    private DownloadInfo downloadUrl() {
        this.log("downloading url " + this.url);
        Downloader downloader = new Downloader(this.url).setLogger(this.logger).useRotatingProxies(this.proxies).disableRedirectHandling().multipleDownloadTries(10, 120L).cancelAfter(30, 10L);
        DownloadInfo downloadInfo = downloader.download();
        return downloadInfo;
    }

    private void handleRedirects(DownloadInfo downloadInfo) {
        if (downloadInfo.isRedirect()) {
            this.log("Redirect");
            String string = downloadInfo.getRedirectUrlToFollow();
            if (string.startsWith(NAVIGATIONSHILFE1_T_ONLINE)) {
                this.handleRedirectToUrlStartingWithNavigationsHilfeTOnline();
            } else if (string.startsWith("/") || string.matches("[A-Za-z]+/") || string.matches("[A-Za-z]+\\.(?:html?|php)") || string.matches("[A-Za-z]+/[A-Za-z]+\\.(?:html?|php)")) {
                this.handleRedirectToUrlStartingWithSlash(downloadInfo, string);
            } else {
                this.handleNormalRedirect(string);
            }
        } else {
            this.downloadDone = true;
        }
    }

    private void handleRedirectToUrlStartingWithNavigationsHilfeTOnline() {
        this.log("Redirect auf Navigationshilfe T-Online wird nicht gefolgt.");
        this.downloadDone = true;
        this.infoWithRedirects.redirectToNavigationshilfeTOnline();
    }

    private void handleRedirectToUrlStartingWithSlash(DownloadInfo downloadInfo, String string) {
        this.log("redirect auf " + string + ", aber das ist keine g\u00fcltige Adresse!");
        String string2 = downloadInfo.getReturnedUrl();
        this.log("returnedUrl = " + string2);
        if (UrlHelper.urlEndsWithHtmlOrPhp(string2) || UrlHelper.urlContainsOtherUrl(string2, string)) {
            String string3 = downloadInfo.getUrl();
            if (UrlHelper.urlEndsWithHtmlOrPhp(string3) || UrlHelper.urlContainsOtherUrl(string3, string)) {
                String string4 = UrlHelper.determineBaseUrl(string2);
                this.log("baseUrl = " + string4);
                this.url = UrlHelper.concatUrlAndAdditional(string4, string);
                this.log("redirect mit base Url zusammengesetzt: " + this.url);
            } else {
                this.url = UrlHelper.concatUrlAndAdditional(string3, string);
                this.log("redirect mit originaler Url zusammengesetzt: " + this.url);
            }
        } else {
            this.url = UrlHelper.concatUrlAndAdditional(string2, string);
            this.log("redirect mit returnter Url zusammengesetzt: " + this.url);
        }
        this.url = UrlHelper.normalizeUrl(this.url);
        this.log("redirect normalisiert: " + this.url);
    }

    private void handleNormalRedirect(String string) {
        this.log("redirect auf " + string);
        this.url = string;
    }

    private void handelCanceledDownload(DownloadInfo downloadInfo) {
        if (downloadInfo.isDownloadCanceled()) {
            this.infoWithRedirects.downloadCanceled();
            this.downloadDone = true;
        }
    }

    private void handleException(Exception exception) {
        this.infoWithRedirects.exceptionOccured(exception);
        System.err.println("Abgefangene Ausnahme in ImpressumDownloader#handleException:");
        exception.printStackTrace(System.err);
        this.log("Ausnahme w\u00e4hrend des Downloads " + ExceptionHelper.getExceptionNameAndMessage(exception));
    }

    private void log(String string) {
        if (this.logger != null) {
            this.logger.log(string, 1);
        }
    }

    public static DownloadInfoWithRedirects download(String string, DownloadProxyList downloadProxyList, Logger logger) {
        DownloaderWithOwnRedirectHandling downloaderWithOwnRedirectHandling = new DownloaderWithOwnRedirectHandling(string, downloadProxyList, logger);
        return downloaderWithOwnRedirectHandling.download();
    }

    public static DownloadInfoWithRedirects download(String string, DownloadProxyList downloadProxyList) {
        return DownloaderWithOwnRedirectHandling.download(string, downloadProxyList, null);
    }
}

