/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.debug.dialog;

import de.duehl.swing.debug.data.DebugMessage;
import de.duehl.swing.debug.dialog.table.DebugMessagesColumnModel;
import de.duehl.swing.debug.dialog.table.DebugMessagesTableModel;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.tables.DifferentBackgroundsTableRendererWithChangingSize;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;

class CategoryPanel {
    private static final Color TABLE_FOREGROUND = new Color(0, 0, 255);
    private static final Color TABLE_BACKGROUND = new Color(240, 240, 255);
    private final JPanel panel = new JPanel();
    private final JTable table = new JTable();
    private final DebugMessagesTableModel tableModel;
    private final DifferentBackgroundsTableRendererWithChangingSize tableRenderer;
    private boolean showCategory;

    public CategoryPanel(List<DebugMessage> list) {
        this.tableModel = new DebugMessagesTableModel(list);
        this.tableRenderer = new DifferentBackgroundsTableRendererWithChangingSize(TABLE_FOREGROUND, TABLE_BACKGROUND);
        this.showCategory = false;
        this.init();
    }

    private void init() {
        this.panel.setLayout(new BorderLayout());
    }

    public void showCategory() {
        this.showCategory = true;
        this.tableModel.showCategory();
    }

    public void crateGui() {
        this.initTable();
        this.panel.add((Component)GuiTools.createScrollPane(this.table), "Center");
    }

    private void initTable() {
        this.initTableModel();
        this.initTableColumnModel();
        this.initTableRenderer();
        this.setTableSelectionMode();
        this.setTableRowHight();
        this.switchReorderingOfTableColumnsOff();
        this.initTableSorter();
    }

    private void initTableModel() {
        this.table.setModel(this.tableModel);
    }

    private void initTableColumnModel() {
        this.table.setColumnModel(new DebugMessagesColumnModel(this.showCategory));
    }

    private void initTableRenderer() {
        this.tableRenderer.setFontSize(15.0f);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
    }

    private void setTableSelectionMode() {
        this.table.setSelectionMode(0);
    }

    private void setTableRowHight() {
        this.tableRenderer.initRowHeightOfTable(this.table);
    }

    private void switchReorderingOfTableColumnsOff() {
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    private void initTableSorter() {
        TableRowSorter<DebugMessagesTableModel> tableRowSorter = new TableRowSorter<DebugMessagesTableModel>(this.tableModel);
        this.table.setRowSorter(tableRowSorter);
    }

    public void increaseFontSize() {
        this.tableRenderer.increaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    public void standardFontSize() {
        this.tableRenderer.setFontSize(15.0f);
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    public void decreaseFontSize() {
        this.tableRenderer.decreaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

