/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.debug.dialog.table;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.swing.debug.data.DebugMessage;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class DebugMessagesTableModel
extends AbstractTableModel {
    private static final int NUMBER_OF_COLUMNS_WITHOUT_CATEGORY = 6;
    private static final long serialVersionUID = 1L;
    private final List<DebugMessage> messages;
    private boolean showCategory;

    public DebugMessagesTableModel(List<DebugMessage> list) {
        this.messages = list;
        this.showCategory = false;
    }

    public void showCategory() {
        this.showCategory = true;
    }

    @Override
    public int getRowCount() {
        return this.messages.size();
    }

    @Override
    public int getColumnCount() {
        if (this.showCategory) {
            return 7;
        }
        return 6;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.showCategory) {
            return this.getValueAtWithCategory(n, n2);
        }
        return this.getValueAtWithoutCategory(n, n2);
    }

    private Object getValueAtWithCategory(int n, int n2) {
        DebugMessage debugMessage = this.messages.get(n);
        switch (n2) {
            case 0: {
                return debugMessage.getDate();
            }
            case 1: {
                return debugMessage.getTime();
            }
            case 2: {
                return debugMessage.getCategory();
            }
            case 3: {
                return debugMessage.getClassName();
            }
            case 4: {
                return debugMessage.getMethodName();
            }
            case 5: {
                return debugMessage.getLineNumber();
            }
            case 6: {
                return debugMessage.getMessage();
            }
        }
        throw new RuntimeException("Unzul\u00e4siger Spaltenindex '" + n2 + "'.");
    }

    private Object getValueAtWithoutCategory(int n, int n2) {
        DebugMessage debugMessage = this.messages.get(n);
        switch (n2) {
            case 0: {
                return debugMessage.getDate();
            }
            case 1: {
                return debugMessage.getTime();
            }
            case 2: {
                return debugMessage.getClassName();
            }
            case 3: {
                return debugMessage.getMethodName();
            }
            case 4: {
                return debugMessage.getLineNumber();
            }
            case 5: {
                return debugMessage.getMessage();
            }
        }
        throw new RuntimeException("Unzul\u00e4siger Spaltenindex '" + n2 + "'.");
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return ImmutualDate.class;
            }
            case 1: {
                return ImmutualTime.class;
            }
        }
        return String.class;
    }
}

