/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.text.html.characteristic;

import de.duehl.basics.text.handling.BooleanHandling;
import de.duehl.swing.ui.colors.ColorTool;
import java.util.Objects;
import java.util.Properties;

public class OpticalTextPartCharacteristic {
    private static final String FOREGROUND_PROPERTY_NAME = "foregroundHexColor";
    private static final String BACKGROUND_PROPERTY_NAME = "backgroundHexColor";
    private static final String USE_BACKGROUND_PROPERTY_NAME = "useBackgroundHexColor";
    private static final String BOLD_PROPERTY_NAME = "bold";
    private static final String ITALIC_PROPERTY_NAME = "italic";
    private static final String UNDERLINE_PROPERTY_NAME = "underline";
    private String foregroundHexColor;
    private String backgroundHexColor;
    private boolean useBackgroundColor;
    private boolean bold;
    private boolean italic;
    private boolean underline;

    public OpticalTextPartCharacteristic() {
        this.foregroundHexColor = ColorTool.getHexColorByName("black");
        this.backgroundHexColor = ColorTool.getHexColorByName("white");
        this.useBackgroundColor = false;
        this.bold = false;
        this.italic = false;
        this.underline = false;
    }

    public OpticalTextPartCharacteristic(OpticalTextPartCharacteristic opticalTextPartCharacteristic) {
        this.copyFrom(opticalTextPartCharacteristic);
    }

    public void copyFrom(OpticalTextPartCharacteristic opticalTextPartCharacteristic) {
        this.foregroundHexColor = opticalTextPartCharacteristic.foregroundHexColor;
        this.backgroundHexColor = opticalTextPartCharacteristic.backgroundHexColor;
        this.useBackgroundColor = opticalTextPartCharacteristic.useBackgroundColor;
        this.bold = opticalTextPartCharacteristic.bold;
        this.italic = opticalTextPartCharacteristic.italic;
        this.underline = opticalTextPartCharacteristic.underline;
    }

    public String getForegroundHexColor() {
        return this.foregroundHexColor;
    }

    public void setForegroundHexColor(String string) {
        this.foregroundHexColor = string;
    }

    public String getBackgroundHexColor() {
        return this.backgroundHexColor;
    }

    public void setBackgroundHexColor(String string) {
        this.backgroundHexColor = string;
    }

    public boolean isUseBackgroundColor() {
        return this.useBackgroundColor;
    }

    public void setUseBackgroundColor(boolean bl) {
        this.useBackgroundColor = bl;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bl) {
        this.bold = bl;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean bl) {
        this.italic = bl;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean bl) {
        this.underline = bl;
    }

    public String createOpeningSpan() {
        return "<span style=\"" + this.createHtmlStyle() + "\">";
    }

    public String createHtmlStyle() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("color:").append(this.foregroundHexColor);
        if (this.useBackgroundColor) {
            stringBuilder.append(";background-color:").append(this.backgroundHexColor);
        }
        if (this.bold) {
            stringBuilder.append(";font-weight:bold");
        }
        if (this.italic) {
            stringBuilder.append(";font-style:italic");
        }
        if (this.underline) {
            stringBuilder.append(";text-decoration:underline");
        }
        return stringBuilder.toString();
    }

    public void loadCharacteristicsFromProperties(Properties properties, String string, String string2) {
        boolean bl;
        String string3;
        String string4 = this.createFullPropertyName(string, string2, FOREGROUND_PROPERTY_NAME);
        if (properties.containsKey(string4)) {
            string3 = properties.getProperty(string4);
            this.setForegroundHexColor(string3);
        }
        if (properties.containsKey(string4 = this.createFullPropertyName(string, string2, BACKGROUND_PROPERTY_NAME))) {
            string3 = properties.getProperty(string4);
            this.setBackgroundHexColor(string3);
        }
        if (properties.containsKey(string4 = this.createFullPropertyName(string, string2, USE_BACKGROUND_PROPERTY_NAME))) {
            string3 = properties.getProperty(string4);
            bl = BooleanHandling.stringToBoolean(string3);
            this.setUseBackgroundColor(bl);
        }
        if (properties.containsKey(string4 = this.createFullPropertyName(string, string2, BOLD_PROPERTY_NAME))) {
            string3 = properties.getProperty(string4);
            bl = BooleanHandling.stringToBoolean(string3);
            this.setBold(bl);
        }
        if (properties.containsKey(string4 = this.createFullPropertyName(string, string2, ITALIC_PROPERTY_NAME))) {
            string3 = properties.getProperty(string4);
            bl = BooleanHandling.stringToBoolean(string3);
            this.setItalic(bl);
        }
        if (properties.containsKey(string4 = this.createFullPropertyName(string, string2, UNDERLINE_PROPERTY_NAME))) {
            string3 = properties.getProperty(string4);
            bl = BooleanHandling.stringToBoolean(string3);
            this.setUnderline(bl);
        }
    }

    public void saveCharacteristicsToProperties(Properties properties, String string, String string2) {
        properties.setProperty(this.createFullPropertyName(string, string2, FOREGROUND_PROPERTY_NAME), this.getForegroundHexColor());
        properties.setProperty(this.createFullPropertyName(string, string2, BACKGROUND_PROPERTY_NAME), this.getBackgroundHexColor());
        properties.setProperty(this.createFullPropertyName(string, string2, USE_BACKGROUND_PROPERTY_NAME), BooleanHandling.booleanToString(this.isUseBackgroundColor()));
        properties.setProperty(this.createFullPropertyName(string, string2, BOLD_PROPERTY_NAME), BooleanHandling.booleanToString(this.isBold()));
        properties.setProperty(this.createFullPropertyName(string, string2, ITALIC_PROPERTY_NAME), BooleanHandling.booleanToString(this.isItalic()));
        properties.setProperty(this.createFullPropertyName(string, string2, UNDERLINE_PROPERTY_NAME), BooleanHandling.booleanToString(this.isUnderline()));
    }

    String createFullPropertyName(String string, String string2, String string3) {
        return string + "." + string2 + "." + string3;
    }

    public OpticalTextPartCharacteristic copy() {
        OpticalTextPartCharacteristic opticalTextPartCharacteristic = new OpticalTextPartCharacteristic();
        opticalTextPartCharacteristic.foregroundHexColor = this.foregroundHexColor;
        opticalTextPartCharacteristic.backgroundHexColor = this.backgroundHexColor;
        opticalTextPartCharacteristic.useBackgroundColor = this.useBackgroundColor;
        opticalTextPartCharacteristic.bold = this.bold;
        opticalTextPartCharacteristic.italic = this.italic;
        opticalTextPartCharacteristic.underline = this.underline;
        return opticalTextPartCharacteristic;
    }

    public String toString() {
        return "OpticalTextPartCharacteristic [bold=" + this.bold + ", italic=" + this.italic + ", underline=" + this.underline + ", foregroundHexColor=" + this.foregroundHexColor + ", backgroundHexColor=" + this.backgroundHexColor + ", useBackgroundColor=" + this.useBackgroundColor + "]";
    }

    public int hashCode() {
        return Objects.hash(this.backgroundHexColor, this.bold, this.foregroundHexColor, this.italic, this.underline, this.useBackgroundColor);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OpticalTextPartCharacteristic opticalTextPartCharacteristic = (OpticalTextPartCharacteristic)object;
        return Objects.equals(this.backgroundHexColor, opticalTextPartCharacteristic.backgroundHexColor) && this.bold == opticalTextPartCharacteristic.bold && Objects.equals(this.foregroundHexColor, opticalTextPartCharacteristic.foregroundHexColor) && this.italic == opticalTextPartCharacteristic.italic && this.underline == opticalTextPartCharacteristic.underline && this.useBackgroundColor == opticalTextPartCharacteristic.useBackgroundColor;
    }
}

