/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.colors;

import de.duehl.swing.ui.colors.ColorTool;
import de.duehl.swing.ui.colors.NamedColorList;
import de.duehl.swing.ui.colors.NamedColorListFabric;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class Colorator {
    private List<String> colors = new ArrayList<String>();
    private int index = 0;

    public Colorator() {
        this.initColorSequenze();
        if (!this.isColorSequenzOk()) {
            throw new RuntimeException("Nullwerte in Farben!");
        }
    }

    protected void initColorSequenze() {
        NamedColorList namedColorList = new NamedColorListFabric().genrateColorList();
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("red"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("blue"));
        this.addColor("FF6600");
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("green"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("purple"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("maroon"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("olive"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("navy"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("teal"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("fuchsia"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("blueviolet"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("cadetblue"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("chocolate"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("crimson"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("darkblue"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("darkcyan"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("darkgreen"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("darkolivegreen"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("darkorange"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("cornflowerblue"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("darksalmon"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("darkseagreen"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("darkviolet"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("darkslategray"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("firebrick"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("forestgreen"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("indigo"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("lightseagreen"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("midnightblue"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("olivedrab"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("saddlebrown"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("seagreen"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("sienna"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("tomato"));
        this.addColor(namedColorList.getHexCodeFromNamedColorByName("violet"));
    }

    protected final void addColor(String string) {
        if (this.colors.contains(string)) {
            throw new IllegalArgumentException("Farbe " + string + " wird wiederholt in Liste eingef\u00fcgt!");
        }
        this.colors.add(string);
    }

    private boolean isColorSequenzOk() {
        for (String string : this.colors) {
            if (null != string) continue;
            return false;
        }
        return true;
    }

    public Color getNextColor() {
        return this.hexColorToJavaColor(this.getNextColorAsHex());
    }

    public String getNextColorAsHex() {
        String string = this.colors.get(this.index);
        ++this.index;
        if (this.index == this.colors.size()) {
            this.index = 0;
        }
        return string;
    }

    public Color getColor(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Index darf nicht negativ sein! index = " + n);
        }
        for (n2 = n; n2 >= this.colors.size(); n2 -= this.colors.size()) {
        }
        return this.hexColorToJavaColor(this.colors.get(n2));
    }

    private Color hexColorToJavaColor(String string) {
        return ColorTool.hexColorToJavaColor(string);
    }

    public void restartColorSequenze() {
        this.index = 0;
    }

    public List<String> getColors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.colors) {
            arrayList.add(string);
        }
        return arrayList;
    }
}

