/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.elements;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TextFieldWithChangeButton {
    private final JTextField textField = TextFieldWithChangeButton.createTextField();
    private final JButton changeButton = TextFieldWithChangeButton.createChangeButton();
    private final Component panel = this.createPanel();

    private static JTextField createTextField() {
        JTextField jTextField = new JTextField();
        GuiTools.setEditFieldColors(jTextField);
        return jTextField;
    }

    private static JButton createChangeButton() {
        JButton jButton = new JButton("\u00e4ndern");
        return jButton;
    }

    private Component createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.textField, "Center");
        jPanel.add((Component)this.changeButton, "East");
        return jPanel;
    }

    public void addButtonActionListener(ActionListener actionListener) {
        this.changeButton.addActionListener(actionListener);
    }

    public void addTextFieldActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }

    public String getText() {
        String string = this.textField.getText();
        string = string.trim();
        return string;
    }

    public void setText(String string) {
        this.textField.setText(string);
    }

    public void setEnabled(boolean bl) {
        this.textField.setEnabled(bl);
        this.changeButton.setEnabled(bl);
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this.panel);
        colorizer.setColors(this.textField);
        colorizer.setColors(this.changeButton);
        colorizer.setEditFieldColors(this.textField);
    }

    public Component getPanel() {
        return this.panel;
    }

    public void setPreferredSize(Dimension dimension) {
        this.textField.setPreferredSize(dimension);
    }

    public void setButtonText(String string) {
        this.changeButton.setText(string);
    }

    public void clickButton() {
        this.changeButton.doClick();
    }

    public void setButtonPreferredSize(Dimension dimension) {
        this.changeButton.setPreferredSize(dimension);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.textField.addKeyListener(keyListener);
    }

    public void addReturnKeyClickButtonListener() {
        this.addKeyListener(this.createClickButtonKeyListener());
    }

    private KeyListener createClickButtonKeyListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    TextFieldWithChangeButton.this.clickButton();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        };
    }

    public void addFocusListener(FocusListener focusListener) {
        this.textField.addFocusListener(focusListener);
    }

    public void setToolTipText(String string) {
        this.changeButton.setToolTipText(string);
        this.textField.setToolTipText(string);
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void requestFocusLater() {
        SwingUtilities.invokeLater(() -> this.requestFocus());
    }
}

