/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.elements;

import de.duehl.swing.ui.colors.Colorizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TitleWithChangeButton {
    private final JLabel titleLabel;
    private final JButton changeButton;
    private final Component panel;

    public TitleWithChangeButton(String string) {
        this.titleLabel = new JLabel(string);
        this.changeButton = new JButton("\u00e4ndern");
        this.panel = this.createPanel();
    }

    private Component createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.titleLabel, "Center");
        jPanel.add((Component)this.changeButton, "East");
        return jPanel;
    }

    public Component getPanel() {
        return this.panel;
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this.panel);
        colorizer.setColors(this.titleLabel);
        colorizer.setColors(this.changeButton);
    }

    public void addButtonActionListener(ActionListener actionListener) {
        this.changeButton.addActionListener(actionListener);
    }

    public void setButtonText(String string) {
        this.changeButton.setText(string);
    }

    public void setButtonPreferredSize(Dimension dimension) {
        this.changeButton.setPreferredSize(dimension);
    }

    public void clickButton() {
        this.changeButton.doClick();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.changeButton.addKeyListener(keyListener);
    }
}

