/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class LongStringSelection {
    private final JLabel titleLabel;
    private final Component mainPanel;
    private final JTextArea textArea;

    public LongStringSelection(String string) {
        this.titleLabel = new JLabel(string);
        this.textArea = new JTextArea();
        GuiTools.setEditAreaColors(this.textArea);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.mainPanel = this.createPanel();
    }

    private Component createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.titleLabel, "North");
        jPanel.add(this.createTextArea(), "Center");
        return jPanel;
    }

    private Component createTextArea() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.textArea, "Center");
        return jPanel;
    }

    public String getText() {
        String string = this.textArea.getText();
        string = string.trim();
        return string;
    }

    public void setText(String string) {
        this.textArea.setText(string);
    }

    public Component getPanel() {
        return this.mainPanel;
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this.mainPanel);
        colorizer.setColors(this.titleLabel);
        colorizer.setColors(this.textArea);
        colorizer.setEditAreaColors(this.textArea);
    }

    public void setPreferredSize(Dimension dimension) {
        this.textArea.setPreferredSize(dimension);
    }

    public void addTextFieldFocuslistener(FocusListener focusListener) {
        this.textArea.addFocusListener(focusListener);
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
    }
}

