/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections.base;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.elements.TextFieldWithChangeButtonAndTitle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;

public abstract class FileOrPathSelection {
    private final TextFieldWithChangeButtonAndTitle elements;
    private boolean weHaveActionAfterButtonPressed = false;
    private Runnable actionAfterButtonPressed;
    private String startDirForEmptyText = "";

    public FileOrPathSelection(String string) {
        this.elements = new TextFieldWithChangeButtonAndTitle(string);
        this.elements.addButtonActionListener(actionEvent -> this.changeDirectory());
    }

    public void setStartDirForEmptyText(String string) {
        this.startDirForEmptyText = string;
    }

    private void changeDirectory() {
        String string;
        String string2 = this.getText();
        if (string2.isEmpty()) {
            string2 = this.startDirForEmptyText;
        }
        if (!(string = this.openPath(string2)).isEmpty()) {
            this.setText(string);
            if (this.weHaveActionAfterButtonPressed) {
                this.actionAfterButtonPressed.run();
            }
        }
    }

    protected abstract String openPath(String var1);

    public Component getPanel() {
        return this.elements.getPanel();
    }

    public void colorize(Colorizer colorizer) {
        this.elements.colorize(colorizer);
    }

    public String getText() {
        return this.elements.getText();
    }

    public void setText(String string) {
        this.elements.setText(Text.nicePath(string));
    }

    public void addKeyListener(KeyListener keyListener) {
        this.elements.addKeyListener(keyListener);
    }

    public void addReturnKeyClickButtonListener() {
        this.elements.addReturnKeyClickButtonListener();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.elements.addFocusListener(focusListener);
    }

    public void addTextFieldActionListener(ActionListener actionListener) {
        this.elements.addTextFieldActionListener(actionListener);
    }

    public void addActionToButton(Runnable runnable) {
        this.weHaveActionAfterButtonPressed = true;
        this.actionAfterButtonPressed = runnable;
    }

    public void setToolTipText(String string) {
        this.elements.setToolTipText(string);
    }

    public void setButtonText(String string) {
        this.elements.setButtonText(string);
    }

    public void setPreferredSize(Dimension dimension) {
        this.elements.setPreferredSize(dimension);
    }
}

