/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections.base;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.elements.TextFieldWithChangeButtonAndTitle;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class MultipleFileOrPathSelection {
    private final TextFieldWithChangeButtonAndTitle elements;
    private final JPanel filesOrDirsPanel;
    private final JPanel listPanel;
    private final List<String> fileOrDirNames;
    private final String frameTitle;

    public MultipleFileOrPathSelection(String string, String string2) {
        this.frameTitle = string2;
        this.elements = new TextFieldWithChangeButtonAndTitle(string);
        this.elements.addReturnKeyClickButtonListener();
        this.elements.addButtonActionListener(this.createActionListener());
        this.elements.setButtonText("hinzuf\u00fcgen");
        this.fileOrDirNames = new ArrayList<String>();
        this.listPanel = this.createListPanel();
        this.filesOrDirsPanel = this.createFilesOrDirsPanel();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleFileOrPathSelection.this.addFileOrDir();
            }
        };
    }

    private void addFileOrDir() {
        String string = this.openPath(this.elements.getText());
        if (!string.isEmpty()) {
            this.elements.setText("");
            string = Text.nicePath(string);
            this.addFileOrDirSubPanel(string);
            this.filesOrDirsPanel.revalidate();
        }
    }

    protected abstract String openPath(String var1);

    public void addInitialFileOrDirs(List<String> list) {
        for (String string : list) {
            this.addFileOrDirSubPanel(string);
        }
    }

    private void addFileOrDirSubPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createNameOfFileOrDir(string), "Center");
        jPanel.add((Component)this.createRemoveButton(string, jPanel), "East");
        this.listPanel.add(jPanel);
    }

    private JLabel createNameOfFileOrDir(String string) {
        this.fileOrDirNames.add(string);
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(new EmptyBorder(0, 20, 0, 2));
        return jLabel;
    }

    private JButton createRemoveButton(final String string, final JPanel jPanel) {
        JButton jButton = new JButton("entfernen");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleFileOrPathSelection.this.fileOrDirNames.remove(string);
                MultipleFileOrPathSelection.this.listPanel.remove(jPanel);
                MultipleFileOrPathSelection.this.filesOrDirsPanel.revalidate();
                MultipleFileOrPathSelection.this.filesOrDirsPanel.repaint();
                MultipleFileOrPathSelection.this.listPanel.revalidate();
                MultipleFileOrPathSelection.this.listPanel.repaint();
            }
        });
        return jButton;
    }

    private JPanel createListPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        return jPanel;
    }

    private JPanel createFilesOrDirsPanel() {
        JPanel jPanel = new JPanel();
        GuiTools.createTitle(this.frameTitle, jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.elements.getPanel(), "North");
        jPanel.add((Component)this.listPanel, "Center");
        return jPanel;
    }

    public Component getPanel() {
        return this.filesOrDirsPanel;
    }

    public void colorize(Colorizer colorizer) {
        this.elements.colorize(colorizer);
        colorizer.setColors(this.listPanel);
        colorizer.setColors(this.filesOrDirsPanel);
    }

    public String getText() {
        return this.elements.getText();
    }

    public void setText(String string) {
        this.elements.setText(string);
    }

    public List<String> getFileOrDirNames() {
        return this.fileOrDirNames;
    }

    public void setButtonPreferredSize(Dimension dimension) {
        this.elements.setButtonPreferredSize(dimension);
    }
}

