/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections.datetime;

import de.duehl.swing.data.DailyWeeklyNot;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.datetime.QuarterlyTimeSelection;
import de.duehl.swing.ui.components.selections.datetime.WeekdaySelection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class DailyWeeklyNotSelector {
    private final WeekdaySelection weeklyWeekdaySelection;
    private final QuarterlyTimeSelection weeklyTimeSelection;
    private final QuarterlyTimeSelection dailyTimeSelection;
    private JRadioButton dailyRadioButton;
    private JRadioButton weeklyRadioButton;
    private JRadioButton notRadioButton;
    private final JPanel panel;

    public DailyWeeklyNotSelector() {
        GuiTools.setNiceLayoutManager();
        this.weeklyWeekdaySelection = new WeekdaySelection();
        this.weeklyTimeSelection = new QuarterlyTimeSelection();
        this.dailyTimeSelection = new QuarterlyTimeSelection();
        this.initRadioButtons();
        this.panel = this.createPanel();
    }

    public void initValues(DailyWeeklyNot dailyWeeklyNot) {
        if (dailyWeeklyNot.isDaily()) {
            this.dailyRadioButton.setSelected(true);
        }
        if (dailyWeeklyNot.isWeekly()) {
            this.weeklyRadioButton.setSelected(true);
        }
        if (dailyWeeklyNot.isNot()) {
            this.notRadioButton.setSelected(true);
        }
        this.dailyTimeSelection.setTime(dailyWeeklyNot.getDailyTime());
        this.weeklyWeekdaySelection.setText(dailyWeeklyNot.getWeeklyWeekdayAsGermanName());
        this.weeklyTimeSelection.setTime(dailyWeeklyNot.getWeeklyTime());
    }

    private void initRadioButtons() {
        this.dailyRadioButton = new JRadioButton("T\u00e4gliche Sicherung");
        this.weeklyRadioButton = new JRadioButton("W\u00f6chentliche Sicherung");
        this.notRadioButton = new JRadioButton("Keine automatische Sicherung");
        this.dailyRadioButton.setBorder(new EmptyBorder(3, 0, 10, 0));
        this.weeklyRadioButton.setBorder(new EmptyBorder(3, 0, 10, 0));
        this.notRadioButton.setBorder(new EmptyBorder(3, 0, 10, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.dailyRadioButton);
        buttonGroup.add(this.weeklyRadioButton);
        buttonGroup.add(this.notRadioButton);
        this.dailyRadioButton.setSelected(true);
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 2, 2));
        jPanel.add(this.createDailyPart());
        jPanel.add(this.createWeeklyPart());
        jPanel.add(this.createNotPart());
        return jPanel;
    }

    private Component createDailyPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.dailyRadioButton, "North");
        jPanel.add(this.createDailyTimePart(), "Center");
        return jPanel;
    }

    private Component createDailyTimePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("Zeit f\u00fcr das t\u00e4gliche Backup:"), "North");
        jPanel.add(this.dailyTimeSelection.getPanel());
        return jPanel;
    }

    private Component createWeeklyPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.weeklyRadioButton, "North");
        jPanel.add(this.createWeeklyDayAndTimePart(), "Center");
        return jPanel;
    }

    private Component createWeeklyDayAndTimePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createWeeklyTimePart(), "North");
        jPanel.add(this.createWeeklyDayPart(), "Center");
        return jPanel;
    }

    private Component createWeeklyTimePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("Zeit f\u00fcr das w\u00f6chentliche Backup:"), "North");
        jPanel.add(this.weeklyTimeSelection.getPanel());
        return jPanel;
    }

    private Component createWeeklyDayPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("Tag f\u00fcr das w\u00f6chentliche Backup:"), "North");
        jPanel.add(this.weeklyWeekdaySelection.getPanel());
        return jPanel;
    }

    private Component createNotPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.notRadioButton, "North");
        return jPanel;
    }

    public Component getPanel() {
        return this.panel;
    }

    public DailyWeeklyNot getUserSelection() {
        DailyWeeklyNot dailyWeeklyNot = new DailyWeeklyNot();
        this.fillUserSelectionInResult(dailyWeeklyNot);
        return dailyWeeklyNot;
    }

    private void fillUserSelectionInResult(DailyWeeklyNot dailyWeeklyNot) {
        dailyWeeklyNot.isDaily();
        if (this.dailyRadioButton.isSelected()) {
            dailyWeeklyNot.setDaily();
        }
        if (this.weeklyRadioButton.isSelected()) {
            dailyWeeklyNot.setWeekly();
        }
        if (this.notRadioButton.isSelected()) {
            dailyWeeklyNot.setNot();
        }
        dailyWeeklyNot.setDailyTime(this.dailyTimeSelection.getTime());
        dailyWeeklyNot.setWeeklyWeekday(this.weeklyWeekdaySelection.getWeekday());
        dailyWeeklyNot.setWeeklyTime(this.weeklyTimeSelection.getTime());
    }
}

