/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordDialog
extends ModalDialogBase {
    private final String message;
    private final JPasswordField passwordField;
    private String password;

    public PasswordDialog(String string, String string2) {
        this(new Point(150, 100), null, string, string2);
    }

    public PasswordDialog(Point point, Image image, String string, String string2) {
        super(point, image, string);
        this.message = string2;
        this.passwordField = new JPasswordField(16);
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.password = "";
        GuiTools.biggerFont(this.passwordField, 10);
        GuiTools.addReturnListener(this.passwordField, () -> this.ok());
    }

    @Override
    protected void populateDialog() {
        this.add(this.createMessagePart(), "North");
        this.add(this.passwordField, "Center");
        this.add(this.createButtonPart(), "South");
    }

    private Component createMessagePart() {
        JLabel jLabel = new JLabel(this.message);
        GuiTools.biggerFont(jLabel, 5);
        return jLabel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createQuitButton(), "West");
        jPanel.add(this.createOKButton(), "East");
        return jPanel;
    }

    private JButton createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        this.setColors(jButton);
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private Component createOKButton() {
        JButton jButton = new JButton("OK");
        this.setColors(jButton);
        jButton.addActionListener(actionEvent -> this.ok());
        return jButton;
    }

    private void ok() {
        char[] cArray = this.passwordField.getPassword();
        this.password = new String(cArray).strip();
        this.closeDialog();
    }

    public String getPassword() {
        return this.password;
    }
}

