/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.datetime.SimpleDateAndTimeSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SimpleDateAndTimeSelectionDialog
extends ModalDialogBase {
    private final SimpleDateAndTimeSelection dateAndTimeSelection;
    private DateAndTime selectedDateAndTime;

    public SimpleDateAndTimeSelectionDialog() {
        this("Bitte Uhrzeit und Datum ausw\u00e4hlen");
    }

    public SimpleDateAndTimeSelectionDialog(String string) {
        this(new Point(250, 100), string);
    }

    public SimpleDateAndTimeSelectionDialog(Point point, String string) {
        this(point, null, string);
    }

    public SimpleDateAndTimeSelectionDialog(Point point, Image image, String string) {
        super(point, image, string);
        this.ignoreSize();
        this.setMinimumWidth(400);
        this.dateAndTimeSelection = new SimpleDateAndTimeSelection();
        this.dateAndTimeSelection.addReturnListener(() -> this.apply());
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.add(this.createMainPart(), "Center");
    }

    private Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createDateAndTimeSelectionPart(), "Center");
        jPanel.add(this.createButtonPart(), "South");
        return jPanel;
    }

    private Component createDateAndTimeSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.dateAndTimeSelection.getPanel(), "Center");
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createOkButton(), "East");
        return jPanel;
    }

    private JButton createOkButton() {
        JButton jButton = new JButton("OK");
        this.setColors(jButton);
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        if (this.dateAndTimeSelection.checkValidity()) {
            this.selectedDateAndTime = this.dateAndTimeSelection.getDateAndTime();
            this.closeDialog();
        } else {
            this.createErrorHandler().warning(this.dateAndTimeSelection.getValidityCheckFailedCause());
        }
    }

    public void initWithNow() {
        this.dateAndTimeSelection.initWithNow();
        this.repaint();
    }

    public void initWithSmoothTimeInAbout10Minutes() {
        this.dateAndTimeSelection.initWithSmoothTimeInAbout10Minutes();
        this.repaint();
    }

    public DateAndTime getSelectedDateAndTime() {
        return this.selectedDateAndTime;
    }

    public void setSelectedDateAndTime(DateAndTime dateAndTime) {
        this.selectedDateAndTime = dateAndTime;
    }
}

