/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.lists;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.lists.EditableListDialogBase;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableList;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableListElement;
import de.duehl.swing.ui.dialogs.lists.ui.EditableListElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class SelectFromEditableListDialog<Element extends LogicalEditableListElement>
extends EditableListDialogBase<Element> {
    private boolean userHasSelected = false;
    private Element userSelectedElement = null;

    public SelectFromEditableListDialog(Dimension dimension, Point point, Image image, String string, LogicalEditableList<Element> logicalEditableList) {
        super(dimension, point, image, string, logicalEditableList);
    }

    @Override
    protected final Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getElementsPanel(), "Center");
        return jPanel;
    }

    @Override
    protected Component createRealElementPart(Element Element2) {
        EditableListElement<Element> editableListElement = this.createUiElement(Element2);
        JButton jButton = editableListElement.createSelectButton();
        GuiTools.biggerFont(jButton, 3);
        jButton.addActionListener(actionEvent -> this.selectElement(Element2));
        return jButton;
    }

    private void selectElement(Element Element2) {
        this.userSelectedElement = Element2;
        this.userHasSelected = true;
        this.closeDialog();
    }

    public final boolean hasUserSelected() {
        return this.userHasSelected;
    }

    public final Element getUserSelection() {
        if (!this.hasUserSelected()) {
            throw new RuntimeException("Kein Element ausgew\u00e4hlt! Der Aufruf von getUserSelection() muss vorher durch hasUserSelected() \u00fcberpr\u00fcft werden!");
        }
        if (null == this.userSelectedElement) {
            throw new RuntimeException("Interner Fehler: Der Benutzer hat ausgew\u00e4hlt, das Objekt ist aber nicht definiert!");
        }
        return this.userSelectedElement;
    }
}

