/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.values;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ComboBoxDialog
extends ModalDialogBase {
    private final JComboBox<String> comboBox;
    private final String question;
    private final String presetting;

    public ComboBoxDialog(Point point, Image image, String string, String string2, String string3, List<String> list) {
        super(point, image, string);
        this.question = string2;
        this.presetting = string3;
        String[] stringArray = CollectionsHelper.stringListToArray(list);
        this.comboBox = new JComboBox<String>(stringArray);
        this.fillDialog();
        this.addClosingWindowListener(() -> this.escape());
    }

    public void allowEnteringOwnValues() {
        this.comboBox.setEditable(true);
    }

    @Override
    protected void populateDialog() {
        this.add(this.createQuestionPart(), "North");
        this.add(this.createEnterValuePart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.setKeyBindings();
    }

    private Component createQuestionPart() {
        JLabel jLabel = new JLabel(this.question);
        return jLabel;
    }

    private Component createEnterValuePart() {
        this.comboBox.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    ComboBoxDialog.this.closeDialog();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.comboBox.setSelectedItem(this.presetting);
        return this.comboBox;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createQuitButton(), "West");
        jPanel.add((Component)this.createOkButton(), "East");
        return jPanel;
    }

    private JButton createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.escape());
        return jButton;
    }

    private JButton createOkButton() {
        JButton jButton = new JButton("OK");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private void setKeyBindings() {
        this.setKeyBindingEscape(() -> this.escape());
    }

    private void escape() {
        this.comboBox.setSelectedItem("");
        this.closeDialog();
    }

    public String getEnteredValue() {
        String string = this.comboBox.isEditable() ? this.comboBox.getEditor().getItem().toString() : this.comboBox.getSelectedItem().toString();
        return string.trim();
    }
}

