/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.navigator;

import de.duehl.basics.logic.ErrorHandler;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.navigator.NavigatorPanel;
import de.duehl.swing.ui.elements.navigator.ReactOnUserElementNumberSelection;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NavigatorPanelWithDocumentPosition
extends NavigatorPanel {
    private static final long serialVersionUID = 1L;
    private static final int NO_NUMBER_OF_ELEMENTS_DETECTED = -2;
    private final ErrorHandler error;
    private final JTextField goToNumberOfElementsIndexField;
    private final JTextField totalNumberOfElementsIndexField;
    private ReactOnUserElementNumberSelection reactOnUnserElementNumberSelection;
    private int actualShownNumberOfElement;
    private int totalNumberOfElements;

    public NavigatorPanelWithDocumentPosition(ErrorHandler errorHandler) {
        this(DEFAULT_BUTTON_SIZE, errorHandler);
    }

    public NavigatorPanelWithDocumentPosition(Dimension dimension, ErrorHandler errorHandler) {
        super(dimension);
        this.error = errorHandler;
        this.goToNumberOfElementsIndexField = new JTextField("", 4);
        this.totalNumberOfElementsIndexField = new JTextField("", 4);
        this.addFirstActionListener(actionEvent -> this.first());
        this.addPreviousActionListener(actionEvent -> this.previous());
        this.addNextActionListener(actionEvent -> this.next());
        this.addLastActionListener(actionEvent -> this.last());
    }

    private void first() {
        this.setActualShownNumberOfElement(1);
    }

    private void previous() {
        if (this.actualShownNumberOfElement > 1) {
            this.setActualShownNumberOfElement(this.actualShownNumberOfElement - 1);
        }
    }

    private void next() {
        if (this.actualShownNumberOfElement < this.totalNumberOfElements) {
            this.setActualShownNumberOfElement(this.actualShownNumberOfElement + 1);
        }
    }

    private void last() {
        this.setActualShownNumberOfElement(this.totalNumberOfElements);
    }

    @Override
    protected int calculatePreferredWidth() {
        int n = super.calculatePreferredWidth();
        int n2 = 3;
        int n3 = 50;
        int n4 = 15;
        return n += (n2 + 1) * 5 + 2 * n3 + n4;
    }

    @Override
    protected void addElements() {
        this.addLeftNavigationElements();
        this.addDocumentPositionElements();
        this.addRightNavigationElements();
    }

    private void addDocumentPositionElements() {
        this.add(this.goToNumberOfElementsIndexField);
        this.add(new JLabel("/"));
        this.add(this.totalNumberOfElementsIndexField);
    }

    @Override
    protected void initElelents() {
        super.initElelents();
        this.goToNumberOfElementsIndexField.addActionListener(actionEvent -> this.reactOnDocumentIndexInput());
        GuiTools.biggerFont(this.goToNumberOfElementsIndexField, 5);
        this.totalNumberOfElementsIndexField.setFocusable(false);
        this.totalNumberOfElementsIndexField.setEditable(false);
        GuiTools.biggerFont(this.totalNumberOfElementsIndexField, 5);
        this.setActualShownNumberOfElement(1);
    }

    private void reactOnDocumentIndexInput() {
        int n;
        String string = this.goToNumberOfElementsIndexField.getText().trim();
        if (!string.isEmpty() && (n = this.determineShownNumberOfElements(string)) != -2) {
            this.reactOnUnserElementNumberSelection.reactOnUserElementNumberSelection(n);
            this.setActualShownNumberOfElement(n);
        }
    }

    private int determineShownNumberOfElements(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n > 0 && n <= this.totalNumberOfElements) {
                return n;
            }
            return -2;
        }
        catch (NumberFormatException numberFormatException) {
            this.error.warning(string + " ist keine valide Nummer.");
            return -2;
        }
    }

    public void setReactOnUserElementNumberSelection(ReactOnUserElementNumberSelection reactOnUserElementNumberSelection) {
        this.reactOnUnserElementNumberSelection = reactOnUserElementNumberSelection;
    }

    public void setTotalNumberOfElements(int n) {
        this.totalNumberOfElements = n;
        this.totalNumberOfElementsIndexField.setText(Integer.toString(n));
    }

    public int getTotalNumberOfElements() {
        return this.totalNumberOfElements;
    }

    public void setActualShownNumberOfElement(int n) {
        this.actualShownNumberOfElement = n;
        this.goToNumberOfElementsIndexField.setText(Integer.toString(n));
    }

    public void clearActualShownNumberOfElement() {
        this.goToNumberOfElementsIndexField.setText("");
    }

    public int getActualShownNumberOfElement() {
        return this.actualShownNumberOfElement;
    }
}

