/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.handler.error;

import de.duehl.basics.logging.Logger;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.basics.system.ExceptionHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.elements.DisabledGlassPane;
import de.duehl.swing.ui.error.ErrorDialog;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GlassPaneDeactivatingErrorHandler
implements ErrorHandler {
    private static final Point DEFAULT_PARENT_LOCATION = new Point(400, 150);
    private final Image programImage;
    private final Component parentComponent;
    private final DisabledGlassPane glassPane;
    protected final Logger logger;
    private boolean weHaveSpecialReactOnError;
    private Runnable specialReactOnError;

    public GlassPaneDeactivatingErrorHandler(Image image, Component component, DisabledGlassPane disabledGlassPane) {
        this(image, component, disabledGlassPane, null);
    }

    public GlassPaneDeactivatingErrorHandler(Image image, Component component, DisabledGlassPane disabledGlassPane, Logger logger) {
        this.programImage = image;
        this.parentComponent = component;
        this.glassPane = disabledGlassPane;
        this.logger = logger;
        this.weHaveSpecialReactOnError = false;
    }

    public GlassPaneDeactivatingErrorHandler setReactOnError(Runnable runnable) {
        this.weHaveSpecialReactOnError = true;
        this.specialReactOnError = runnable;
        return this;
    }

    @Override
    public void warning(String string) {
        this.log("Warnung: " + string);
        SwingUtilities.invokeLater(() -> this.warningInEDT(string));
    }

    private void warningInEDT(String string) {
        this.glassPane.deactivate();
        String string2 = Text.addLineBreaks(string, 80);
        JOptionPane.showMessageDialog(this.parentComponent, string2, "Warnung", 2);
    }

    @Override
    public void error(String string) {
        this.error(string, null);
    }

    @Override
    public void error(String string, Exception exception) {
        ErrorDialog errorDialog = this.createErrorDialog(string, exception);
        if (null != this.logger) {
            errorDialog.addLogger(this.logger);
        }
        this.log("Fehler: " + string + (String)(null == exception ? "" : " - " + ExceptionHelper.getExceptionNameAndMessage(exception)));
        SwingUtilities.invokeLater(() -> this.errorInEDT(errorDialog));
    }

    protected ErrorDialog createErrorDialog(String string, Exception exception) {
        return new ErrorDialog(string, exception, this.programImage, this.calculateLocation());
    }

    private void errorInEDT(ErrorDialog errorDialog) {
        this.glassPane.deactivate();
        errorDialog.setVisible(true);
        if (this.weHaveSpecialReactOnError) {
            this.specialReactOnError.run();
        }
    }

    protected Point calculateLocation() {
        if (this.parentComponent == null) {
            return DEFAULT_PARENT_LOCATION;
        }
        return this.parentComponent.getLocation();
    }

    private void log(String string) {
        if (null != this.logger) {
            this.logger.log(string);
        }
    }
}

