/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.gotoline;

import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;

public class GotoLine {
    private HighlightingEditor editor;

    public GotoLine() {
    }

    public GotoLine(HighlightingEditor highlightingEditor) {
        this.editor = highlightingEditor;
    }

    public void switchEditor(HighlightingEditor highlightingEditor) {
        this.editor = highlightingEditor;
    }

    public void gotoLine(String string) {
        if (!string.isEmpty() && NumberString.isDigitSequence(string)) {
            this.gotoLine(NumberString.parseIntIgnore(string, 0));
        }
    }

    private void gotoLine(int n) {
        if (n >= 1) {
            int n2 = this.determineStartPositionOfSentence(n);
            this.editor.setCaretPosition(n2);
        }
    }

    private int determineStartPositionOfSentence(int n) {
        if (n == 1) {
            return 0;
        }
        int n2 = n - 1;
        String string = this.getTextWithInternalLineBreaks();
        int n3 = 0;
        for (int i = 0; n3 != -1 && i < n2; ++i) {
            int n4 = n3;
            if ((n3 = string.indexOf("\n", n3) + "\n".length()) >= n4) continue;
            return string.length();
        }
        return n3;
    }

    private String getTextWithInternalLineBreaks() {
        String string = this.editor.getText();
        string = Text.lineBreaksToBackslashN(string);
        return string;
    }
}

