/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.menu.collection;

import de.duehl.swing.ui.menu.collection.AutomaticMyMenuItemCollection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class StoredMyMenuItem {
    private static final char NOT_STORED_MNEMONIC = '\u0000';
    private static final int NOT_STORED_KEY_CODE = Integer.MAX_VALUE;
    private static final int NOT_STORED_MODIFIERS = Integer.MAX_VALUE;
    private static final ActionListener NOT_STORED_ACTIONLISTENER = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    private String text;
    private char mnemonic;
    private int keyCode;
    private int modifiers;
    private ActionListener actionListener;

    public StoredMyMenuItem(String string) {
        this.text = string;
        this.mnemonic = '\u0000';
        this.keyCode = Integer.MAX_VALUE;
        this.modifiers = Integer.MAX_VALUE;
        this.actionListener = NOT_STORED_ACTIONLISTENER;
        AutomaticMyMenuItemCollection.collect(this);
    }

    public void mnemonic(char c) {
        this.mnemonic = c;
    }

    public void accelerator(int n, int n2) {
        this.keyCode = n;
        this.modifiers = n2;
        AutomaticMyMenuItemCollection.checkAccelerator(this);
    }

    public void actionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public String getText() {
        return this.text;
    }

    public boolean isMnemonicStored() {
        return this.mnemonic != '\u0000';
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public boolean isKeyCodeAndModifiersStored() {
        return this.keyCode != Integer.MAX_VALUE && this.modifiers != Integer.MAX_VALUE;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isActionListenerStored() {
        return !this.actionListener.equals(NOT_STORED_ACTIONLISTENER);
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public String toString() {
        return "StoredMyMenuItem [text=" + this.text + ", mnemonic=" + this.mnemonic + ", keyCode=" + this.keyCode + ", modifiers=" + this.modifiers + "]";
    }
}

