/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tabs.bars.generic;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.tabs.bars.generic.TabBar;
import de.duehl.swing.ui.tabs.bars.growing.GrowingTabbedPane;
import de.duehl.swing.ui.tabs.bars.growing.TabCreator;
import de.duehl.swing.ui.tabs.elements.TabElements;
import java.awt.Component;
import javax.swing.JTabbedPane;

public class GrowingTabBar<T extends Component>
extends TabBar<T> {
    public GrowingTabBar(TabCreator tabCreator) {
        super(GrowingTabBar.createTabs(tabCreator));
    }

    public GrowingTabBar(boolean bl, TabCreator tabCreator) {
        super(bl, GrowingTabBar.createTabs(tabCreator));
    }

    private static JTabbedPane createTabs(TabCreator tabCreator) {
        return new GrowingTabbedPane(tabCreator, 1, 1);
    }

    @Override
    public String generateNotUsedTitle(String string) {
        if (string.matches("new \\d+")) {
            return this.generateNotUsedTitleForNewTabs(string);
        }
        return super.generateNotUsedTitle(string);
    }

    private String generateNotUsedTitleForNewTabs(String string) {
        String string2 = string.substring(0, 4);
        String string3 = string.substring(4);
        int n = NumberString.parseIntIgnore(string3, 0);
        String string4 = string2 + Integer.toString(n);
        while (this.isTitleAlreadyInUse(string4)) {
            string4 = string2 + Integer.toString(++n);
        }
        return string4;
    }

    @Override
    public TabElements<T> getSelectedTabElements() {
        if (this.isPlusButtonTabulatorSelected()) {
            return null;
        }
        return super.getSelectedTabElements();
    }

    private boolean isPlusButtonTabulatorSelected() {
        int n = this.getSelectedIndex();
        return this.isIndexOfPlusButtonTabulator(n);
    }

    private boolean isIndexOfPlusButtonTabulator(int n) {
        return n == this.getTabCount() - 1;
    }
}

