/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tabs.logic;

import de.duehl.basics.debug.DebugHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditorWithoutButtonBar;
import de.duehl.swing.ui.highlightingeditor.HighlightingViewer;
import de.duehl.swing.ui.highlightingeditor.syntax.SyntaxHighlighting;
import de.duehl.swing.ui.highlightingeditor.syntax.highlighting.HighlightingFactory;
import de.duehl.swing.ui.tabs.Tabulator;
import de.duehl.swing.ui.tabs.bars.editors.TabBarWithEditors;
import de.duehl.swing.ui.tabs.elements.TabElementsWithEditor;
import de.duehl.swing.ui.tabs.logic.EditorAndFilename;
import java.util.ArrayList;
import java.util.List;

public class EditorBarAndEditors {
    private static final int DEFAULT_FONT_SIZE = 20;
    private static final boolean DEBUG = true;
    private final List<EditorAndFilename> editors;
    private final TabBarWithEditors tabBar;

    public EditorBarAndEditors(TabBarWithEditors tabBarWithEditors) {
        this.tabBar = tabBarWithEditors;
        this.editors = new ArrayList<EditorAndFilename>();
    }

    public HighlightingEditor addEditor(String string) {
        this.checkForKnownBarename(string);
        HighlightingEditor highlightingEditor = this.createEditor(string);
        this.addToTabBar(highlightingEditor);
        this.addToEditors(string, highlightingEditor);
        return highlightingEditor;
    }

    private HighlightingEditor createEditor(String string) {
        HighlightingEditor highlightingEditor = new HighlightingEditor();
        this.initEditorFont(highlightingEditor);
        highlightingEditor.useSyntaxHighlighting(this.generateSyntaxHighlighting());
        highlightingEditor.setFilenameButDoNotDoAnythingElse(string);
        return highlightingEditor;
    }

    public HighlightingEditor addEditorWithoutButtonBar(String string) {
        this.checkForKnownBarename(string);
        HighlightingEditor highlightingEditor = this.createEditorWithoutButtonBar(string);
        this.addToTabBar(highlightingEditor);
        this.addToEditors(string, highlightingEditor);
        return highlightingEditor;
    }

    private HighlightingEditor createEditorWithoutButtonBar(String string) {
        HighlightingEditorWithoutButtonBar highlightingEditorWithoutButtonBar = new HighlightingEditorWithoutButtonBar();
        this.initEditorFont(highlightingEditorWithoutButtonBar);
        highlightingEditorWithoutButtonBar.useSyntaxHighlighting(this.generateSyntaxHighlighting());
        highlightingEditorWithoutButtonBar.setFilenameButDoNotDoAnythingElse(string);
        return highlightingEditorWithoutButtonBar;
    }

    public HighlightingEditor addViewer(String string) {
        String string2 = FileHelper.getBareName(string);
        this.checkForKnownBarename(string2);
        HighlightingViewer highlightingViewer = this.createViewer(string2);
        this.addToTabBar(highlightingViewer);
        this.addToEditors(string2, highlightingViewer);
        return highlightingViewer;
    }

    private HighlightingViewer createViewer(String string) {
        HighlightingViewer highlightingViewer = new HighlightingViewer();
        this.initEditorFont(highlightingViewer);
        highlightingViewer.setFilenameButDoNotDoAnythingElse(string);
        return highlightingViewer;
    }

    private void checkForKnownBarename(String string) {
        for (EditorAndFilename editorAndFilename : this.editors) {
            String string2 = editorAndFilename.getBarename();
            if (!string2.equals(string)) continue;
            throw new IllegalArgumentException("Der Dateiname ohne Pfad '" + string + "' ist bereits in verwendung, daher wird die Aufnahme von '" + string + "' abgelent.");
        }
    }

    private void initEditorFont(HighlightingEditor highlightingEditor) {
        highlightingEditor.useMonospaceFont();
        highlightingEditor.setFontSize(20);
    }

    private SyntaxHighlighting generateSyntaxHighlighting() {
        HighlightingFactory highlightingFactory = new HighlightingFactory();
        String string = "WZ_PREPARATION";
        SyntaxHighlighting syntaxHighlighting = highlightingFactory.create(string);
        return syntaxHighlighting;
    }

    private HighlightingEditor addToTabBar(HighlightingEditor highlightingEditor) {
        TabElementsWithEditor tabElementsWithEditor = this.tabBar.addTab(highlightingEditor);
        Tabulator tabulator = tabElementsWithEditor.getTabulator();
        highlightingEditor.addChangeStateDisplayer(tabulator);
        return highlightingEditor;
    }

    private void addToEditors(String string, HighlightingEditor highlightingEditor) {
        EditorAndFilename editorAndFilename = new EditorAndFilename(highlightingEditor, string);
        this.editors.add(editorAndFilename);
    }

    public void updateFilennameForBarename(String string, String string2) {
        this.say("update filename " + string + " -> " + string2);
        EditorAndFilename editorAndFilename = this.getByBarename(string);
        editorAndFilename.setFilename(string2);
    }

    private EditorAndFilename getByBarename(String string) {
        for (EditorAndFilename editorAndFilename : this.editors) {
            if (!string.equals(editorAndFilename.getBarename())) continue;
            return editorAndFilename;
        }
        throw new IllegalArgumentException("Der Dateiname ohne Pfad '" + string + "' ist nicht bekannt.");
    }

    public void loadAllEditorFiles() {
        for (EditorAndFilename editorAndFilename : this.editors) {
            this.loadEditorFile(editorAndFilename);
        }
    }

    public void loadAllEditorFilesInThreads() {
        for (EditorAndFilename editorAndFilename : this.editors) {
            this.loadEditorFileInThread(editorAndFilename);
        }
    }

    private void loadEditorFileInThread(EditorAndFilename editorAndFilename) {
        new Thread(() -> this.loadEditorFile(editorAndFilename)).start();
    }

    private void loadEditorFile(EditorAndFilename editorAndFilename) {
        HighlightingEditor highlightingEditor = editorAndFilename.getEditor();
        String string = editorAndFilename.getFilename();
        this.say("lese Datei " + string);
        highlightingEditor.openFile(string);
    }

    public void removeEditorByBarename(String string) {
        this.removeEditorByBarenameFromEditorList(string);
        this.tabBar.removeTab(string);
    }

    private void removeEditorByBarenameFromEditorList(String string) {
        for (EditorAndFilename editorAndFilename : this.editors) {
            if (!string.equals(editorAndFilename.getBarename())) continue;
            this.editors.remove(editorAndFilename);
            return;
        }
    }

    public List<String> getBarenames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EditorAndFilename editorAndFilename : this.editors) {
            String string = editorAndFilename.getBarename();
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<HighlightingEditor> getEditors() {
        ArrayList<HighlightingEditor> arrayList = new ArrayList<HighlightingEditor>();
        for (EditorAndFilename editorAndFilename : this.editors) {
            arrayList.add(editorAndFilename.getEditor());
        }
        return arrayList;
    }

    public boolean contains(HighlightingEditor highlightingEditor) {
        return this.getEditors().contains(highlightingEditor);
    }

    public void focusSelectedEditor() {
        this.tabBar.focusSelectedEditor();
    }

    public boolean containsBarename(String string) {
        for (EditorAndFilename editorAndFilename : this.editors) {
            String string2 = editorAndFilename.getBarename();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public HighlightingEditor getEditorByBarename(String string) {
        for (EditorAndFilename editorAndFilename : this.editors) {
            String string2 = editorAndFilename.getBarename();
            if (!string.equals(string2)) continue;
            return editorAndFilename.getEditor();
        }
        throw new IllegalArgumentException("Der Barename '" + string + "' ist unbekannt.");
    }

    private void say(String string) {
        DebugHelper.sayWithClassAndMethodAndTime(string);
    }
}

