/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.text.TextComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class TextPanel {
    private final TextComponent textComponent = new TextComponent();
    private final JScrollPane scroll = new JScrollPane(this.textComponent.getComponent());
    private final JPanel panel = new JPanel();

    public TextPanel() {
        this.initPanel();
    }

    public void setColors(Colorizer colorizer) {
        if (null != colorizer) {
            this.textComponent.setColors(colorizer);
            colorizer.setColors(this.scroll);
            colorizer.setColors(this.panel);
        }
    }

    protected void switchToEditable() {
        this.textComponent.setEditable(true);
    }

    public void useMonoscpacedText() {
        this.textComponent.useMonoscpacedText();
    }

    public void setFontSize(int n) {
        this.textComponent.setFontSize(n);
    }

    public void biggerFont(int n) {
        this.textComponent.biggerFont(n);
    }

    public void useNoWordWrap() {
        this.textComponent.useNoWordWrap();
    }

    public void setText(String string) {
        this.textComponent.setText(string);
        this.scrollScrollbarToMinimumLater();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.panel.add((Component)this.scroll, "Center");
    }

    public void setPreferredSize(int n, int n2) {
        this.scroll.setPreferredSize(new Dimension(n, n2));
    }

    public void setEditable(boolean bl) {
        this.textComponent.setEditable(bl);
    }

    public Component getComponent() {
        return this.scroll;
    }

    public String getText() {
        return this.textComponent.getText();
    }

    public void scrollScrollbarToMinimumLater() {
        GuiTools.scrollScrollbarToMinimumLater(this.scroll);
    }

    public void scrollScrollbarToMaximumLater() {
        GuiTools.scrollScrollbarToMaximumLater(this.scroll);
    }

    public void scrollScrollbarToPreviousSectionLater() {
        GuiTools.scrollScrollbarToPreviousSectionLater(this.scroll);
    }

    public void scrollScrollbarToNextSectionLater() {
        GuiTools.scrollScrollbarToNextSectionLater(this.scroll);
    }

    public void setCaretPosition(int n) {
        this.textComponent.setCaretPosition(n);
    }

    public void repaint() {
        this.textComponent.repaint();
        this.scroll.validate();
    }

    public void setBackground(Color color) {
        this.textComponent.setBackground(color);
    }

    public void ignorePageUpAndPageDown() {
        this.textComponent.ignorePageUpAndPageDown();
    }

    public void ignoreUpAndDown() {
        this.textComponent.ignoreUpAndDown();
    }

    public void ignoreCtrlPos1AndCtrlEnd() {
        this.textComponent.ignoreCtrlPos1AndCtrlEnd();
    }

    public void setRows(int n) {
        this.textComponent.setRows(n);
    }

    public void setColumns(int n) {
        this.textComponent.setColumns(n);
    }
}

