/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text.html;

import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.text.html.HtmlAndSourceCodePanel;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;

public final class HtmlYesNoDialog
extends ModalDialogBase {
    private final HtmlAndSourceCodePanel htmlPanel;
    private boolean answer;
    private JButton noButton;
    private JButton yesButton;

    public HtmlYesNoDialog(String string) {
        this(string, new Point(100, 100));
    }

    public HtmlYesNoDialog(String string, Point point) {
        this(string, null, point);
    }

    public HtmlYesNoDialog(String string, Image image, Point point) {
        super(point, image, string);
        this.addEscapeBehaviour();
        this.answer = false;
        this.noButton = this.createNoButton();
        this.yesButton = this.createYesButton();
        this.htmlPanel = HtmlAndSourceCodePanel.create();
        this.htmlPanel.setKeyBindings(this.getRootPane());
        this.htmlPanel.addButtonOnLeft(this.noButton);
        this.htmlPanel.addButtonOnRight(this.yesButton);
        this.fillDialog();
    }

    private JButton createNoButton() {
        JButton jButton = new JButton("Nein");
        jButton.addActionListener(actionEvent -> this.no());
        return jButton;
    }

    private JButton createYesButton() {
        JButton jButton = new JButton("Ja");
        jButton.addActionListener(actionEvent -> this.yes());
        return jButton;
    }

    private void no() {
        this.answer = false;
        this.closeDialog();
    }

    private void yes() {
        this.answer = true;
        this.closeDialog();
    }

    @Override
    protected void populateDialog() {
        this.add(this.htmlPanel.getComponent(), "Center");
    }

    public void setText(String string) {
        this.htmlPanel.setText(string);
        this.htmlPanel.scrollScrollbarToMinimumLater();
    }

    public boolean getUserAnswer() {
        return this.answer;
    }
}

