/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.undoredo;

import de.duehl.basics.history.HistoryStateDisplayer;
import de.duehl.basics.history.HistoryUser;
import de.duehl.swing.ui.resources.IconLoader;
import de.duehl.swing.ui.undoredo.resources.IconDefinitions;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class UndoRedoBar
implements HistoryStateDisplayer {
    private final HistoryUser historyUser;
    private final IconLoader iconLoader;
    private final JPanel panel;
    private JButton undoButton;
    private JButton redoButton;

    public UndoRedoBar(HistoryUser historyUser) {
        this.historyUser = historyUser;
        IconDefinitions iconDefinitions = new IconDefinitions();
        this.iconLoader = iconDefinitions.createIconLoader();
        this.panel = new JPanel();
        this.populatePanel();
    }

    private void populatePanel() {
        this.panel.setLayout(new GridLayout(1, 0, 2, 2));
        this.panel.add(this.createUndoButton());
        this.panel.add(this.createRedoButton());
    }

    private Component createUndoButton() {
        this.undoButton = this.createButton("HISTORY_PREVIOUS");
        this.undoButton.addActionListener(actionEvent -> this.historyUser.undo());
        this.undoButton.setToolTipText("R\u00fcckg\u00e4ngig");
        return this.undoButton;
    }

    private Component createRedoButton() {
        this.redoButton = this.createButton("HISTORY_NEXT");
        this.redoButton.addActionListener(actionEvent -> this.historyUser.redo());
        this.redoButton.setToolTipText("Wiederherstellen");
        return this.redoButton;
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(this.iconLoader.loadIcon(string));
        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        jButton.setOpaque(true);
        return jButton;
    }

    @Override
    public void enableUndo() {
        this.undoButton.setEnabled(true);
    }

    @Override
    public void disableUndo() {
        this.undoButton.setEnabled(false);
    }

    @Override
    public void enableRedo() {
        this.redoButton.setEnabled(true);
    }

    @Override
    public void disableRedo() {
        this.redoButton.setEnabled(false);
    }

    public Component getComponent() {
        return this.panel;
    }
}

