/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.update.dialog;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChangeUpdateIntervalDialog
extends ModalDialogBase {
    private static final String UNITY_SECONDS = "Sekunden";
    private static final String UNITY_MINUTES = "Minuten";
    private static final String UNITY_HOURS = "Stunden";
    private static final String UNITY_DAYS = "Tage";
    private int updateIntervalInSeconds;
    private final Component parentDialog;
    private final StringSelection updateIntervalSelection;
    private final JComboBox<String> intervalUnityComboBox;
    private boolean applied;

    public ChangeUpdateIntervalDialog(int n, Component component) {
        super("Aktualisierungsintervall festlegen");
        this.updateIntervalInSeconds = n;
        this.parentDialog = component;
        this.updateIntervalSelection = new StringSelection("Updateintervall in der angezeigten Einheit");
        this.intervalUnityComboBox = new JComboBox();
        this.applied = false;
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.init();
        this.add(this.createDummyWidthPart(), "North");
        this.add(this.createMainPart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.pack();
    }

    private void init() {
        this.initSelections();
        this.initComboBox();
        this.fillComboBox();
        this.initIntervallAndUnitByUpdateIntervalInSeconds();
    }

    private void initSelections() {
        SelectionsHelper.initSelectionAsEditor(this.updateIntervalSelection);
    }

    private void initComboBox() {
        this.intervalUnityComboBox.setAlignmentX(0.0f);
        this.intervalUnityComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.intervalUnityComboBox.getRenderer())).setHorizontalAlignment(0);
    }

    private void fillComboBox() {
        this.intervalUnityComboBox.removeAllItems();
        this.intervalUnityComboBox.addItem(UNITY_SECONDS);
        this.intervalUnityComboBox.addItem(UNITY_MINUTES);
        this.intervalUnityComboBox.addItem(UNITY_HOURS);
        this.intervalUnityComboBox.addItem(UNITY_DAYS);
    }

    private Component createDummyWidthPart() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(500, 0));
        return jPanel;
    }

    private Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.updateIntervalSelection.getPanel(), "Center");
        jPanel.add(this.intervalUnityComboBox, "East");
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOKButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton();
        jButton.setText("Beenden");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private Component createOKButton() {
        JButton jButton = new JButton();
        jButton.setText("\u00dcbernehmen");
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        String string = this.updateIntervalSelection.getTrimmedText();
        if (string.isEmpty()) {
            GuiTools.informUser(this.parentDialog, "Leeres Aktualisierungsintervall eingegeben!", "Bitte geben Sie eine Zahl ein!");
        } else if (NumberString.isDigitSequence(string)) {
            int n = Integer.parseInt(string);
            String string2 = (String)this.intervalUnityComboBox.getSelectedItem();
            this.updateIntervalInSeconds = this.calculateSeconds(n, string2);
            this.applied = true;
            this.closeDialog();
        } else {
            GuiTools.informUser(this.parentDialog, "Fehlerhaftes Aktualisierungsintervall eingegeben!", "Bitte geben Sie eine ganze Zahl ein!");
        }
    }

    private int calculateSeconds(int n, String string) {
        switch (string) {
            case "Sekunden": {
                return n;
            }
            case "Minuten": {
                return n * 60;
            }
            case "Stunden": {
                return n * 60 * 60;
            }
            case "Tage": {
                return n * 60 * 60 * 24;
            }
        }
        throw new RuntimeException("Unbekannte Einheit '" + string);
    }

    private void initIntervallAndUnitByUpdateIntervalInSeconds() {
        String string;
        int n;
        if (this.updateIntervalInSeconds < 60) {
            n = this.updateIntervalInSeconds;
            string = UNITY_SECONDS;
        } else if (this.updateIntervalInSeconds < 3600) {
            n = this.updateIntervalInSeconds / 60;
            string = UNITY_MINUTES;
        } else if (this.updateIntervalInSeconds < 86400) {
            n = this.updateIntervalInSeconds / 3600;
            string = UNITY_HOURS;
        } else {
            n = this.updateIntervalInSeconds / 86400;
            string = UNITY_DAYS;
        }
        this.updateIntervalSelection.setText(n);
        this.intervalUnityComboBox.setSelectedItem(string);
    }

    public boolean isApplied() {
        return this.applied;
    }

    public int getUpdateIntervalInSeconds() {
        return this.updateIntervalInSeconds;
    }
}

