/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.version;

import de.duehl.basics.system.SystemTools;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.generation.SwingHtmlBuilder;
import de.duehl.basics.version.ChangesBetweenVersionsCutter;
import de.duehl.basics.version.Version;
import de.duehl.swing.ui.text.html.HtmlDialog;
import de.duehl.swing.ui.text.html.HtmlFrame;
import java.awt.Image;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class NewsHelper {
    private static final long DEFAULT_WAIT_TIME = 1200L;
    private final Version actualVersion;
    private final Version lastVersion;
    private final String changesHtml;
    private final Image programImage;
    private final Point location;
    private long waitTime;
    private boolean showModal;

    public NewsHelper(Version version, Version version2, String string, Image image, Point point) {
        this.actualVersion = version;
        this.lastVersion = version2;
        this.changesHtml = string;
        this.programImage = image;
        this.location = point;
        this.waitTime = 1200L;
        this.showModal = true;
    }

    public void waitExtraMillis(long l) {
        this.waitTime += l;
    }

    public void waitExtraSeconds(int n) {
        this.waitExtraMillis(1000 * n);
    }

    public void setWaitTimeMillis(long l) {
        this.waitTime = l;
    }

    public void showNonModal() {
        this.showModal = false;
    }

    public void perhapsShowNews() {
        String string = this.cutNews();
        if (!string.isEmpty()) {
            this.showNews(string);
        }
    }

    private String cutNews() {
        if (this.actualVersion.isNewerThan(this.lastVersion)) {
            ChangesBetweenVersionsCutter changesBetweenVersionsCutter = new ChangesBetweenVersionsCutter(this.actualVersion, this.lastVersion, this.changesHtml);
            return changesBetweenVersionsCutter.detectChangesBetweenVersions();
        }
        return "";
    }

    private void showNews(String string) {
        String string2 = this.createFullHtml(string);
        new Thread(() -> this.showNewsAfterAWhile(string2)).start();
    }

    private String createFullHtml(String string) {
        SwingHtmlBuilder swingHtmlBuilder = new SwingHtmlBuilder();
        String string2 = "Neuerungen seit dem letzten Aufruf";
        swingHtmlBuilder.appendHtml5HeadWithOwnExtendedCss(string2, this.createCssExtension());
        swingHtmlBuilder.appendH1(string2);
        swingHtmlBuilder.appendP("Aktuelle Version: " + this.actualVersion.getVersionAndDate());
        swingHtmlBuilder.appendP("Version beim letzten Start: " + this.lastVersion.getVersionAndDate());
        swingHtmlBuilder.append(string);
        swingHtmlBuilder.appendFoot();
        return swingHtmlBuilder.toString();
    }

    private String createCssExtension() {
        return Text.removeLineBreakAtEndIfEndsWith("tt, pre, code {\n    color: green;\n    font-size: 1.0625em; /* 17pt;*/\n    font-family: monospace;\n}\npre {\n    margin-left: 10px;\n    margin-right: 10px;\n}".indent(4));
    }

    private void showNewsAfterAWhile(String string) {
        if (!this.showModal) {
            SystemTools.sleep(this.waitTime);
        }
        this.showHtmlViaHtml("Neuerungen seit dem letzten Aufruf", string);
    }

    private void showHtmlViaHtml(String string, String string2) {
        SwingUtilities.invokeLater(() -> this.showHtmlViaHtmlInEDT(string, string2));
    }

    private void showHtmlViaHtmlInEDT(String string, String string2) {
        if (this.showModal) {
            HtmlDialog htmlDialog = new HtmlDialog(string, this.programImage, this.location);
            htmlDialog.setText(string2);
            htmlDialog.scrollScrollbarToMinimumLater();
            htmlDialog.setVisible(true);
        } else {
            HtmlFrame htmlFrame = new HtmlFrame(string, this.programImage, this.location);
            htmlFrame.setText(string2);
            htmlFrame.scrollScrollbarToMinimumLater();
            htmlFrame.setVisible(true);
        }
    }
}

