/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.twosidecommander.ui;

import de.duehl.basics.text.html.generation.SwingHtmlBuilder;
import de.duehl.basics.text.html.generation.tools.Utf8MetaExchanger;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.text.html.HtmlDialog;
import de.duehl.twosidecommander.ui.data.Side;
import de.duehl.twosidecommander.ui.list.ListDisplayer;
import de.duehl.twosidecommander.ui.list.element.ListElementDisplayer;
import de.duehl.twosidecommander.ui.selector.ListSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TwoSideCommander
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1500, 1000);
    private ListSelector leftListSelector;
    private ListSelector rightListSelector;
    private ListDisplayer leftListDisplayer;
    private ListDisplayer rightListDisplayer;
    private Side activeSide = Side.LEFT;
    private final JPanel middleButtonPanel = new JPanel();
    private final JButton toggleMoveButtonsButton = new JButton();
    private boolean showMoveButtonsOnListElements = false;

    public TwoSideCommander(String string, Point point, Image image) {
        super(point, image, string, DIALOG_DIMENSION);
        this.init();
    }

    private void init() {
        this.initMiddleButtonPanel();
        this.setToggleMoveButtonsButtonShowAndHideText();
        this.initToggleMoveButtonsButton();
    }

    private void initMiddleButtonPanel() {
        this.middleButtonPanel.setLayout(new GridLayout(1, 0, 2, 2));
    }

    private void initToggleMoveButtonsButton() {
        this.toggleMoveButtonsButton.addActionListener(actionEvent -> this.toggleMoveButtons());
    }

    private void toggleMoveButtons() {
        this.showMoveButtonsOnListElements = !this.showMoveButtonsOnListElements;
        this.setToggleMoveButtonsButtonShowAndHideText();
        this.activateAndDeactivateMoveButtonsOnBothSides();
    }

    private void activateAndDeactivateMoveButtonsOnBothSides() {
        if (this.showMoveButtonsOnListElements) {
            ListDisplayer listDisplayer = this.getActiveListDisplayer();
            ListDisplayer listDisplayer2 = this.getInactiveListDisplayer();
            listDisplayer.showMoveButtonsOnListElements(true);
            listDisplayer.initButtonColorsAndEnabled();
            listDisplayer2.showMoveButtonsOnListElements(false);
            listDisplayer2.initButtonColorsAndEnabled();
        } else {
            this.leftListDisplayer.showMoveButtonsOnListElements(false);
            this.rightListDisplayer.showMoveButtonsOnListElements(false);
        }
        this.repaint();
        this.validate();
        this.invalidate();
    }

    public final void setLeftListDisplayer(ListDisplayer listDisplayer2) {
        this.leftListDisplayer = listDisplayer2;
        listDisplayer2.setListDisplayerClickReactor(listDisplayer -> this.clickedOnListElementOfList(listDisplayer));
        listDisplayer2.setLongTimeProcessInformer(this);
        listDisplayer2.setActive(true);
    }

    public final void setRightListDisplayer(ListDisplayer listDisplayer2) {
        this.rightListDisplayer = listDisplayer2;
        listDisplayer2.setListDisplayerClickReactor(listDisplayer -> this.clickedOnListElementOfList(listDisplayer));
        listDisplayer2.setLongTimeProcessInformer(this);
        listDisplayer2.setActive(false);
    }

    private void clickedOnListElementOfList(ListDisplayer listDisplayer) {
        ListDisplayer listDisplayer2 = this.getActiveListDisplayer();
        boolean bl = listDisplayer2 == listDisplayer;
        listDisplayer.showCorrectHighlighting();
        if (!bl) {
            if (listDisplayer == this.leftListDisplayer) {
                this.activateLeftSide();
            } else {
                this.activateRightSide();
            }
        }
    }

    public final void setLeftListSelector(ListSelector listSelector) {
        this.leftListSelector = listSelector;
        listSelector.setIsUsedCaller(() -> this.activateLeftSide());
    }

    private void activateLeftSide() {
        this.activeSide = Side.LEFT;
        this.showActiveSide();
    }

    public final void setRightListSelector(ListSelector listSelector) {
        this.rightListSelector = listSelector;
        listSelector.setIsUsedCaller(() -> this.activateRightSide());
    }

    private void activateRightSide() {
        this.activeSide = Side.RIGHT;
        this.showActiveSide();
    }

    public final void enableToggableMovingButtons() {
        this.middleButtonPanel.add(this.toggleMoveButtonsButton);
        this.setKeyBindingF2(() -> this.toggleMoveButtons());
    }

    private void setToggleMoveButtonsButtonShowAndHideText() {
        String string = "einblenden";
        String string2 = "ausblenden";
        String string3 = this.showMoveButtonsOnListElements ? string2 : string;
        this.toggleMoveButtonsButton.setText("<html><center>F2 - Die Buttons zum Verschieben<br>" + string3 + "</center></html>");
    }

    public final void setMiddleButtonBar(Component component) {
        this.middleButtonPanel.add(component);
    }

    public final void createGui() {
        this.checkIfObjectsAreInitialised();
        this.setOtherLists();
        this.fillDialog();
        this.setKeyBindings();
        this.showActiveSide();
    }

    private void checkIfObjectsAreInitialised() {
        if (null == this.leftListDisplayer) {
            throw new RuntimeException("Der Displayer f\u00fcr die linke Liste wurde nicht gesetzt.\nBitte die Methode setLeftListDisplayer() verwenden\n.");
        }
        if (null == this.rightListDisplayer) {
            throw new RuntimeException("Der Displayer f\u00fcr die rechte Liste wurde nicht gesetzt.\nBitte die Methode setRightListDisplayer() verwenden\n.");
        }
        if (null == this.leftListSelector) {
            throw new RuntimeException("Der Selector f\u00fcr die linke Liste wurde nicht gesetzt.\nBitte die Methode setLeftListSelector() verwenden\n.");
        }
        if (null == this.rightListSelector) {
            throw new RuntimeException("Der Selector f\u00fcr die rechte Liste wurde nicht gesetzt.\nBitte die Methode setRightListSelector() verwenden\n.");
        }
    }

    private void setOtherLists() {
        this.leftListDisplayer.setListDisplayerOnTheOtherSide(this.rightListDisplayer);
        this.rightListDisplayer.setListDisplayerOnTheOtherSide(this.leftListDisplayer);
    }

    @Override
    protected final void populateDialog() {
        this.add(this.createHeadPart(), "North");
        this.add(this.createTwoListsPart(), "Center");
        this.add(this.createButtonBar(), "South");
    }

    private Component createHeadPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 2, 2));
        jPanel.add(this.leftListSelector.getPanel());
        jPanel.add(this.rightListSelector.getPanel());
        return jPanel;
    }

    private Component createTwoListsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 2, 2));
        jPanel.add(this.leftListDisplayer.getComponent());
        jPanel.add(this.rightListDisplayer.getComponent());
        return jPanel;
    }

    private Component createButtonBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createLeftButtons(), "West");
        jPanel.add((Component)GuiTools.centerHorizontal(this.middleButtonPanel), "Center");
        jPanel.add(this.createRightButtons(), "East");
        return jPanel;
    }

    private Component createLeftButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 2, 2));
        jPanel.add(this.createKeyUsageButton());
        jPanel.add(this.createCopyButton());
        jPanel.add(this.createMoveButton());
        jPanel.add(this.createDeleteButton());
        return jPanel;
    }

    private Component createKeyUsageButton() {
        JButton jButton = new JButton("F1 - Tastenbelegung");
        jButton.addActionListener(actionEvent -> this.keyUsage());
        return jButton;
    }

    private Component createCopyButton() {
        JButton jButton = new JButton("F5 - Kopieren");
        jButton.addActionListener(actionEvent -> this.copy());
        return jButton;
    }

    private Component createMoveButton() {
        JButton jButton = new JButton("F6 - verschieben");
        jButton.addActionListener(actionEvent -> this.move());
        return jButton;
    }

    private Component createDeleteButton() {
        JButton jButton = new JButton("F8 - l\u00f6schen");
        jButton.addActionListener(actionEvent -> this.delete());
        return jButton;
    }

    private Component createRightButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "Center");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private void setKeyBindings() {
        this.setKeyBindingF1(() -> this.keyUsage());
        this.setKeyBindingF5(() -> this.copy());
        this.setKeyBindingF6(() -> this.move());
        this.setKeyBindingF8(() -> this.delete());
        this.setKeyBindingDelete(() -> this.delete());
        GuiTools.setFocusTraversalKeysToEmptySet(this.getWindowAsComponent());
        this.setKeyBindingTabulator(() -> this.toOtherSide());
        this.setKeyBindingUp(() -> this.up());
        this.setKeyBindingDown(() -> this.down());
        this.setKeyBindingHome(() -> this.home());
        this.setKeyBindingEnd(() -> this.end());
        this.setKeyBindingPageUp(() -> this.pageUp());
        this.setKeyBindingPageDown(() -> this.pageDown());
        this.setKeyBindingInsert(() -> this.insert());
        this.setKeyBindingNumpadPlus(() -> this.numpadPlus());
        this.setKeyBindingNumpadMinus(() -> this.numpadMinus());
    }

    private void keyUsage() {
        String string = "Tastenbelegung im Listen-Commander";
        SwingHtmlBuilder swingHtmlBuilder = new SwingHtmlBuilder().hideTopLinks().appendHtml5HeadWithOwnExtendedCssUtf8(string, SwingHtmlBuilder.createBodyFontSizeInPointCssExtension(16));
        swingHtmlBuilder.appendH1(string);
        swingHtmlBuilder.appendOpeningTableWithBorderWidth(2);
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendLeftAlignedTh("Taste");
        swingHtmlBuilder.appendLeftAlignedTh("Belegung");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>F1</tt>");
        swingHtmlBuilder.appendTd("Zeigt diese Tastenbelegung an");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>F5</tt>");
        swingHtmlBuilder.appendTd("Kopiert die selektierten Elemente, wenn keine selektiert sind, wird das aktive Element kopiert.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>F6</tt>");
        swingHtmlBuilder.appendTd("Verschiebt die selektierten Elemente, wenn keine selektiert sind, wird das aktive Element verschoben.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>F8</tt> oder <tt>Entf</tt>");
        swingHtmlBuilder.appendTd("L\u00f6scht die selektierten Elemente, wenn keine selektiert sind, wird das aktive Element gel\u00f6scht.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Tabulator</tt>");
        swingHtmlBuilder.appendTd("Wechselt zur anderen Seite, also zur rechten, wenn die linke aktiv war und andersherum.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Cursor hoch</tt>");
        swingHtmlBuilder.appendTd("Bewegt die Markierung des aktiven Elements nach oben.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Cursor runter</tt>");
        swingHtmlBuilder.appendTd("Bewegt die Markierung des aktiven Elements nach unten.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Pos 1</tt>");
        swingHtmlBuilder.appendTd("Bewegt die Markierung des aktiven Elements nach ganz oben.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Ende</tt>");
        swingHtmlBuilder.appendTd("Bewegt die Markierung des aktiven Elements nach ganz unten.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Bild hoch</tt>");
        swingHtmlBuilder.appendTd("Bewegt die Markierung des aktiven Elements einen Abschnitt nach oben.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Bild runter</tt>");
        swingHtmlBuilder.appendTd("Bewegt die Markierung des aktiven Elements einen Abschnitt nach unten.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Einfg</tt>");
        swingHtmlBuilder.appendTd("Selektiert das aktive Element.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Nummernblock-Plus</tt>");
        swingHtmlBuilder.appendTd("Selektiert alle Elemente.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendOpeningTr();
        swingHtmlBuilder.appendTd("<tt>Nummernblock-Minus</tt>");
        swingHtmlBuilder.appendTd("Leert die Selektion.");
        swingHtmlBuilder.appendClosingTr();
        swingHtmlBuilder.appendClosingTable();
        swingHtmlBuilder.appendFoot();
        String string2 = swingHtmlBuilder.toString();
        string2 = Utf8MetaExchanger.replaceLongToShort(string2);
        HtmlDialog htmlDialog = new HtmlDialog(string, this.getProgramImage(), this.getLocation());
        htmlDialog.setText(string2);
        htmlDialog.scrollScrollbarToMinimumLater();
        htmlDialog.setVisible(true);
    }

    private void copy() {
        this.startLongTimeProcess("Kopiere");
        new Thread(() -> this.copyInOwnThread()).start();
    }

    private void copyInOwnThread() {
        List<ListElementDisplayer> list = this.determineSelectedOrActiveElementDisplayers();
        ArrayList<ListElementDisplayer> arrayList = new ArrayList<ListElementDisplayer>();
        ListDisplayer listDisplayer = this.getActiveListDisplayer();
        ListDisplayer listDisplayer2 = this.getInactiveListDisplayer();
        for (ListElementDisplayer listElementDisplayer : list) {
            if (listDisplayer2.canAppend(listElementDisplayer)) {
                arrayList.add(listElementDisplayer);
                continue;
            }
            GuiTools.informUserInEdt(this.getWindowAsComponent(), "Kopieren nicht m\u00f6glich", "Das Element '" + listElementDisplayer.getElementDescription() + "' kann nicht in die Liste '" + listDisplayer2.getListDescription() + "' kopiert werden.");
        }
        listDisplayer2.append(arrayList);
        SwingUtilities.invokeLater(() -> this.endCopyMoveOrDeleteInEdt(listDisplayer));
    }

    private void endCopyMoveOrDeleteInEdt(ListDisplayer listDisplayer) {
        this.endLongTimeProcess();
        listDisplayer.deselectAll();
    }

    private void move() {
        this.startLongTimeProcess("Verschiebe");
        new Thread(() -> this.moveInOwnThread()).start();
    }

    private void moveInOwnThread() {
        List<ListElementDisplayer> list = this.determineSelectedOrActiveElementDisplayers();
        ArrayList<ListElementDisplayer> arrayList = new ArrayList<ListElementDisplayer>();
        ListDisplayer listDisplayer = this.getActiveListDisplayer();
        ListDisplayer listDisplayer2 = this.getInactiveListDisplayer();
        for (ListElementDisplayer listElementDisplayer : list) {
            if (listDisplayer2.canAppend(listElementDisplayer)) {
                arrayList.add(listElementDisplayer);
                continue;
            }
            GuiTools.informUserInEdt(this.getWindowAsComponent(), "Verschieben nicht m\u00f6glich", "Das Element '" + listElementDisplayer.getElementDescription() + "' kann nicht in die Liste '" + listDisplayer2.getListDescription() + "' verschoben werden.");
        }
        listDisplayer2.append(arrayList);
        listDisplayer.removeFromActiveList(arrayList);
        SwingUtilities.invokeLater(() -> this.endCopyMoveOrDeleteInEdt(listDisplayer));
    }

    private void delete() {
        this.startLongTimeProcess("L\u00f6sche");
        new Thread(() -> this.deleteInOwnThread()).start();
    }

    private void deleteInOwnThread() {
        List<ListElementDisplayer> list = this.determineSelectedOrActiveElementDisplayers();
        ListDisplayer listDisplayer = this.getActiveListDisplayer();
        listDisplayer.removeFromActiveList(list);
        SwingUtilities.invokeLater(() -> this.endCopyMoveOrDeleteInEdt(listDisplayer));
    }

    private List<ListElementDisplayer> determineSelectedOrActiveElementDisplayers() {
        ListDisplayer listDisplayer = this.getActiveListDisplayer();
        ListElementDisplayer listElementDisplayer = listDisplayer.getActiveElementDisplayer();
        List<ListElementDisplayer> list = listDisplayer.getSelectedListElementDisplayer();
        ArrayList<ListElementDisplayer> arrayList = new ArrayList<ListElementDisplayer>();
        if (list.isEmpty()) {
            arrayList.add(listElementDisplayer);
        } else {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private void toOtherSide() {
        switch (this.activeSide) {
            case LEFT: {
                this.activeSide = Side.RIGHT;
                break;
            }
            case RIGHT: {
                this.activeSide = Side.LEFT;
                break;
            }
            default: {
                throw new RuntimeException("Unbekannte Seite '" + this.activeSide + "'");
            }
        }
        this.showActiveSide();
    }

    private void showActiveSide() {
        switch (this.activeSide) {
            case LEFT: {
                this.showLeftSideAsActive();
                break;
            }
            case RIGHT: {
                this.showRightSideAsActive();
                break;
            }
            default: {
                throw new RuntimeException("Unbekannte Seite '" + this.activeSide + "'");
            }
        }
    }

    private void showLeftSideAsActive() {
        this.leftListSelector.showActive();
        this.rightListSelector.showInactive();
        this.leftListDisplayer.setActive(true);
        this.leftListDisplayer.showCorrectHighlighting();
        this.rightListDisplayer.setActive(false);
        this.rightListDisplayer.showCorrectHighlighting();
        this.activateAndDeactivateMoveButtonsOnBothSides();
    }

    private void showRightSideAsActive() {
        this.rightListSelector.showActive();
        this.leftListSelector.showInactive();
        this.rightListDisplayer.setActive(true);
        this.rightListDisplayer.showCorrectHighlighting();
        this.leftListDisplayer.setActive(false);
        this.leftListDisplayer.showCorrectHighlighting();
        this.activateAndDeactivateMoveButtonsOnBothSides();
    }

    private void up() {
        this.getActiveListDisplayer().up();
    }

    private void down() {
        this.getActiveListDisplayer().down();
    }

    private void home() {
        this.getActiveListDisplayer().home();
    }

    private void end() {
        this.getActiveListDisplayer().end();
    }

    private void pageUp() {
        this.getActiveListDisplayer().pageUp();
    }

    private void pageDown() {
        this.getActiveListDisplayer().pageDown();
    }

    private void insert() {
        this.getActiveListDisplayer().insertPressed();
        this.down();
    }

    private void numpadPlus() {
        this.getActiveListDisplayer().selectAll();
    }

    private void numpadMinus() {
        this.getActiveListDisplayer().deselectAll();
    }

    public final ListDisplayer getActiveListDisplayer() {
        switch (this.activeSide) {
            case LEFT: {
                return this.leftListDisplayer;
            }
            case RIGHT: {
                return this.rightListDisplayer;
            }
        }
        throw new RuntimeException("Unbekannte Seite '" + this.activeSide + "'");
    }

    private ListDisplayer getInactiveListDisplayer() {
        switch (this.activeSide) {
            case LEFT: {
                return this.rightListDisplayer;
            }
            case RIGHT: {
                return this.leftListDisplayer;
            }
        }
        throw new RuntimeException("Unbekannte Seite '" + this.activeSide + "'");
    }
}

