/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.data;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InternalAdditionalVocableData {
    public static final ImmutualDate NOT_SEEN_DATE = new ImmutualDate("01.01.1970");
    private String filename = "";
    private String key = "";
    private ImmutualDate firstSeenDate = NOT_SEEN_DATE;
    private int japaneseToGermanTestCount = 0;
    private int correctJapaneseToGermanTestCount = 0;
    private ImmutualDate lastJapaneseToGermanTestDate = NOT_SEEN_DATE;
    private ImmutualDate lastCorrectJapaneseToGermanTestDate = NOT_SEEN_DATE;
    private List<Boolean> lastTenJapaneseToGermanTestResults = new ArrayList<Boolean>();
    private int germanToJapaneseTestCount = 0;
    private int correctGermanToJapaneseTestCount = 0;
    private ImmutualDate lastGermanToJapaneseTestDate = NOT_SEEN_DATE;
    private ImmutualDate lastCorrectGermanToJapaneseTestDate = NOT_SEEN_DATE;
    private List<Boolean> lastTenGermanToJapaneseTestResults = new ArrayList<Boolean>();
    private static final int OLD_NUMBER_OF_LINES = 7;
    private static final int NEW_NUMBER_OF_LINES = 12;

    public String getFilename() {
        return this.filename;
    }

    public InternalAdditionalVocableData setFilename(String string) {
        this.filename = string;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public InternalAdditionalVocableData setKey(String string) {
        this.key = string;
        return this;
    }

    public ImmutualDate getFirstSeenDate() {
        return this.firstSeenDate;
    }

    public InternalAdditionalVocableData setFirstSeenDate(ImmutualDate immutualDate) {
        this.firstSeenDate = immutualDate;
        return this;
    }

    public int getJapaneseToGermanTestCount() {
        return this.japaneseToGermanTestCount;
    }

    public InternalAdditionalVocableData setJapaneseToGermanTestCount(int n) {
        this.japaneseToGermanTestCount = n;
        return this;
    }

    public int getCorrectJapaneseToGermanTestCount() {
        return this.correctJapaneseToGermanTestCount;
    }

    public InternalAdditionalVocableData setCorrectJapaneseToGermanTestCount(int n) {
        this.correctJapaneseToGermanTestCount = n;
        return this;
    }

    public ImmutualDate getLastJapaneseToGermanTestDate() {
        return this.lastJapaneseToGermanTestDate;
    }

    public InternalAdditionalVocableData setLastJapaneseToGermanTestDate(ImmutualDate immutualDate) {
        this.lastJapaneseToGermanTestDate = immutualDate;
        return this;
    }

    public ImmutualDate getLastCorrectJapaneseToGermanTestDate() {
        return this.lastCorrectJapaneseToGermanTestDate;
    }

    public InternalAdditionalVocableData setLastCorrectJapaneseToGermanTestDate(ImmutualDate immutualDate) {
        this.lastCorrectJapaneseToGermanTestDate = immutualDate;
        return this;
    }

    public String getLastTenJapaneseToGermanTestResultsAsStorageString() {
        return this.lastTenJapaneseToGermanTestResultsToStorageString();
    }

    public List<Boolean> getLastTenJapaneseToGermanTestResults() {
        return this.lastTenJapaneseToGermanTestResults;
    }

    public int getLastTenJapaneseToGermanTestsCount() {
        return this.lastTenJapaneseToGermanTestResults.size();
    }

    public int getLastCorrectJapaneseToGermanTestsCount() {
        return InternalAdditionalVocableData.getLastCorrectTestsCount(this.lastTenJapaneseToGermanTestResults);
    }

    public static int getLastCorrectTestsCount(List<Boolean> list) {
        int n = 0;
        for (boolean bl : list) {
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public int getGermanToJapaneseTestCount() {
        return this.germanToJapaneseTestCount;
    }

    public InternalAdditionalVocableData setGermanToJapaneseTestCount(int n) {
        this.germanToJapaneseTestCount = n;
        return this;
    }

    public int getCorrectGermanToJapaneseTestCount() {
        return this.correctGermanToJapaneseTestCount;
    }

    public InternalAdditionalVocableData setCorrectGermanToJapaneseTestCount(int n) {
        this.correctGermanToJapaneseTestCount = n;
        return this;
    }

    public ImmutualDate getLastGermanToJapaneseTestDate() {
        return this.lastGermanToJapaneseTestDate;
    }

    public InternalAdditionalVocableData setLastGermanToJapaneseTestDate(ImmutualDate immutualDate) {
        this.lastGermanToJapaneseTestDate = immutualDate;
        return this;
    }

    public ImmutualDate getLastCorrectGermanToJapaneseTestDate() {
        return this.lastCorrectGermanToJapaneseTestDate;
    }

    public InternalAdditionalVocableData setLastCorrectGermanToJapaneseTestDate(ImmutualDate immutualDate) {
        this.lastCorrectGermanToJapaneseTestDate = immutualDate;
        return this;
    }

    public String getLastTenGermanToJapaneseTestResultsAsStorageString() {
        return this.lastTenGermanToJapaneseTestResultsToStorageString();
    }

    public List<Boolean> getLastTenGermanToJapaneseTestResults() {
        return this.lastTenGermanToJapaneseTestResults;
    }

    public int getLastGermanToJapaneseTestsCount() {
        return this.lastTenGermanToJapaneseTestResults.size();
    }

    public int getLastCorrectGermanToJapaneseTestsCount() {
        return InternalAdditionalVocableData.getLastCorrectTestsCount(this.lastTenGermanToJapaneseTestResults);
    }

    String lastTenJapaneseToGermanTestResultsToStorageString() {
        return InternalAdditionalVocableData.lastTenTestResultsToStorageString(this.lastTenJapaneseToGermanTestResults);
    }

    String lastTenGermanToJapaneseTestResultsToStorageString() {
        return InternalAdditionalVocableData.lastTenTestResultsToStorageString(this.lastTenGermanToJapaneseTestResults);
    }

    public static String lastTenTestResultsToStorageString(List<Boolean> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (boolean bl : list) {
            if (bl) {
                stringBuilder.append("+");
                continue;
            }
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    public InternalAdditionalVocableData initLastTenJapaneseToGermanTestResultsFromStorageString(String string) {
        InternalAdditionalVocableData.initLastTenTestResultsFromStorageString(this.lastTenJapaneseToGermanTestResults, string);
        return this;
    }

    public InternalAdditionalVocableData initLastTenGermanToJapaneseTestResultsFromStorageString(String string) {
        InternalAdditionalVocableData.initLastTenTestResultsFromStorageString(this.lastTenGermanToJapaneseTestResults, string);
        return this;
    }

    public static void initLastTenTestResultsFromStorageString(List<Boolean> list, String string) {
        list.clear();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            if (string2.equals("+")) {
                list.add(true);
                continue;
            }
            if (string2.equals("-")) {
                list.add(false);
                continue;
            }
            throw new RuntimeException("Der Storage-String '" + string + "' enth\u00e4lt unzul\u00e4sige Zeichen.");
        }
    }

    public void testedJapaneseToGerman(boolean bl) {
        this.testedJapaneseToGermanWithoutSave(bl);
        this.save();
    }

    void testedJapaneseToGermanWithoutSave(boolean bl) {
        ImmutualDate immutualDate = new ImmutualDate();
        this.increaseJapaneseToGermanTestCount();
        this.setLastJapaneseToGermanTestDate(immutualDate);
        if (bl) {
            this.increaseCorrectJapaneseToGermanTestCount();
            this.setLastCorrectJapaneseToGermanTestDate(immutualDate);
        }
        this.lastTenJapaneseToGermanTestResults.add(bl);
        while (this.lastTenJapaneseToGermanTestResults.size() > 10) {
            this.lastTenJapaneseToGermanTestResults.remove(0);
        }
    }

    private void increaseJapaneseToGermanTestCount() {
        ++this.japaneseToGermanTestCount;
    }

    private void increaseCorrectJapaneseToGermanTestCount() {
        ++this.correctJapaneseToGermanTestCount;
    }

    public void testedGermanToJapanese(boolean bl) {
        this.testedGermanToJapaneseWithoutSave(bl);
        this.save();
    }

    void testedGermanToJapaneseWithoutSave(boolean bl) {
        ImmutualDate immutualDate = new ImmutualDate();
        this.increaseGermanToJapaneseTestCount();
        this.setLastGermanToJapaneseTestDate(immutualDate);
        if (bl) {
            this.increaseCorrectGermanToJapaneseTestCount();
            this.setLastCorrectGermanToJapaneseTestDate(immutualDate);
        }
        this.lastTenGermanToJapaneseTestResults.add(bl);
        while (this.lastTenGermanToJapaneseTestResults.size() > 10) {
            this.lastTenGermanToJapaneseTestResults.remove(0);
        }
    }

    private void increaseGermanToJapaneseTestCount() {
        ++this.germanToJapaneseTestCount;
    }

    private void increaseCorrectGermanToJapaneseTestCount() {
        ++this.correctGermanToJapaneseTestCount;
    }

    public static InternalAdditionalVocableData load(String string) {
        List<String> list = FileHelper.readFileToList(string, Charset.UTF_8);
        if (list.size() == 7) {
            return InternalAdditionalVocableData.loadFromFormatWithOnlyJapaneseToGerman(string, list);
        }
        if (list.size() == 12) {
            return InternalAdditionalVocableData.loadFromFormatWithBothDirections(string, list);
        }
        throw new RuntimeException("Die Datei " + string + " enth\u00e4lt nicht wie erwartet 7 oder 12 Zeilen.");
    }

    private static InternalAdditionalVocableData loadFromFormatWithOnlyJapaneseToGerman(String string, List<String> list) {
        int n = 0;
        String string2 = list.get(n++);
        String string3 = list.get(n++);
        String string4 = list.get(n++);
        String string5 = list.get(n++);
        String string6 = list.get(n++);
        String string7 = list.get(n++);
        String string8 = list.get(n++);
        int n2 = NumberString.parseInt(string3);
        int n3 = NumberString.parseInt(string4);
        ImmutualDate immutualDate = new ImmutualDate(string5);
        ImmutualDate immutualDate2 = new ImmutualDate(string6);
        ImmutualDate immutualDate3 = new ImmutualDate(string7);
        InternalAdditionalVocableData internalAdditionalVocableData = new InternalAdditionalVocableData();
        internalAdditionalVocableData.setFilename(string);
        internalAdditionalVocableData.setKey(string2);
        internalAdditionalVocableData.setFirstSeenDate(immutualDate);
        internalAdditionalVocableData.setJapaneseToGermanTestCount(n2);
        internalAdditionalVocableData.setCorrectJapaneseToGermanTestCount(n3);
        internalAdditionalVocableData.setLastJapaneseToGermanTestDate(immutualDate2);
        internalAdditionalVocableData.setLastCorrectJapaneseToGermanTestDate(immutualDate3);
        internalAdditionalVocableData.initLastTenJapaneseToGermanTestResultsFromStorageString(string8);
        return internalAdditionalVocableData;
    }

    private static InternalAdditionalVocableData loadFromFormatWithBothDirections(String string, List<String> list) {
        int n = 0;
        String string2 = list.get(n++);
        String string3 = list.get(n++);
        ImmutualDate immutualDate = new ImmutualDate(string3);
        String string4 = list.get(n++);
        String string5 = list.get(n++);
        String string6 = list.get(n++);
        String string7 = list.get(n++);
        String string8 = list.get(n++);
        int n2 = NumberString.parseInt(string4);
        int n3 = NumberString.parseInt(string5);
        ImmutualDate immutualDate2 = new ImmutualDate(string6);
        ImmutualDate immutualDate3 = new ImmutualDate(string7);
        String string9 = list.get(n++);
        String string10 = list.get(n++);
        String string11 = list.get(n++);
        String string12 = list.get(n++);
        String string13 = list.get(n++);
        int n4 = NumberString.parseInt(string9);
        int n5 = NumberString.parseInt(string10);
        ImmutualDate immutualDate4 = new ImmutualDate(string11);
        ImmutualDate immutualDate5 = new ImmutualDate(string12);
        InternalAdditionalVocableData internalAdditionalVocableData = new InternalAdditionalVocableData();
        internalAdditionalVocableData.setFilename(string);
        internalAdditionalVocableData.setKey(string2);
        internalAdditionalVocableData.setFirstSeenDate(immutualDate);
        internalAdditionalVocableData.setJapaneseToGermanTestCount(n2);
        internalAdditionalVocableData.setCorrectJapaneseToGermanTestCount(n3);
        internalAdditionalVocableData.setLastJapaneseToGermanTestDate(immutualDate2);
        internalAdditionalVocableData.setLastCorrectJapaneseToGermanTestDate(immutualDate3);
        internalAdditionalVocableData.initLastTenJapaneseToGermanTestResultsFromStorageString(string8);
        internalAdditionalVocableData.setGermanToJapaneseTestCount(n4);
        internalAdditionalVocableData.setCorrectGermanToJapaneseTestCount(n5);
        internalAdditionalVocableData.setLastGermanToJapaneseTestDate(immutualDate4);
        internalAdditionalVocableData.setLastCorrectGermanToJapaneseTestDate(immutualDate5);
        internalAdditionalVocableData.initLastTenGermanToJapaneseTestResultsFromStorageString(string13);
        return internalAdditionalVocableData;
    }

    public void save() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.key);
        arrayList.add(this.firstSeenDate.toString());
        arrayList.add(Integer.toString(this.japaneseToGermanTestCount));
        arrayList.add(Integer.toString(this.correctJapaneseToGermanTestCount));
        arrayList.add(this.lastJapaneseToGermanTestDate.toString());
        arrayList.add(this.lastCorrectJapaneseToGermanTestDate.toString());
        arrayList.add(this.lastTenJapaneseToGermanTestResultsToStorageString());
        arrayList.add(Integer.toString(this.germanToJapaneseTestCount));
        arrayList.add(Integer.toString(this.correctGermanToJapaneseTestCount));
        arrayList.add(this.lastGermanToJapaneseTestDate.toString());
        arrayList.add(this.lastCorrectGermanToJapaneseTestDate.toString());
        arrayList.add(this.lastTenGermanToJapaneseTestResultsToStorageString());
        FileHelper.writeLinesToFile(arrayList, this.filename, Charset.UTF_8);
    }

    public String toString() {
        return "InternalAdditionalVocableData [filename=" + this.filename + ", key=" + this.key + ", firstSeenDate=" + this.firstSeenDate + ", japaneseToGermanTestCount=" + this.japaneseToGermanTestCount + ", correctJapaneseToGermanTestCount=" + this.correctJapaneseToGermanTestCount + ", lastJapaneseToGermanTestDate=" + this.lastJapaneseToGermanTestDate + ", lastCorrectJapaneseToGermanTestDate=" + this.lastCorrectJapaneseToGermanTestDate + ", lastTenJapaneseToGermanTestResults=" + this.lastTenJapaneseToGermanTestResults + ", germanToJapaneseTestCount=" + this.germanToJapaneseTestCount + ", correctGermanToJapaneseTestCount=" + this.correctGermanToJapaneseTestCount + ", lastGermanToJapaneseTestDate=" + this.lastGermanToJapaneseTestDate + ", lastCorrectGermanToJapaneseTestDate=" + this.lastCorrectGermanToJapaneseTestDate + ", lastTenGermanToJapaneseTestResults=" + this.lastTenGermanToJapaneseTestResults + "]";
    }

    public String toNiceString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Text.multipleString(" ", n);
        stringBuilder.append(string + "InternalAdditionalVocableData:\n");
        stringBuilder.append(string + "filename           : " + this.filename + "\n");
        stringBuilder.append(string + "key                : " + this.key + "\n");
        stringBuilder.append(string + "firstSeenDate      : " + this.firstSeenDate + "\n");
        stringBuilder.append(string + "japaneseToGermanTestCount          : " + this.japaneseToGermanTestCount + "\n");
        stringBuilder.append(string + "correctJapaneseToGermanTestCount   : " + this.correctJapaneseToGermanTestCount + "\n");
        stringBuilder.append(string + "lastJapaneseToGermanTestDate       : " + this.lastJapaneseToGermanTestDate + "\n");
        stringBuilder.append(string + "lastCorrectJapaneseToGermanTestDate: " + this.lastCorrectJapaneseToGermanTestDate + "\n");
        stringBuilder.append(string + "lastTenJapaneseToGermanTestResults : " + this.lastTenJapaneseToGermanTestResultsToStorageString() + "\n");
        stringBuilder.append(string + "germanToJapaneseTestCount          : " + this.germanToJapaneseTestCount + "\n");
        stringBuilder.append(string + "correctGermanToJapaneseTestCount   : " + this.correctGermanToJapaneseTestCount + "\n");
        stringBuilder.append(string + "lastGermanToJapaneseTestDate       : " + this.lastGermanToJapaneseTestDate + "\n");
        stringBuilder.append(string + "lastCorrectGermanToJapaneseTestDate: " + this.lastCorrectGermanToJapaneseTestDate + "\n");
        stringBuilder.append(string + "lastTenGermanToJapaneseTestResults : " + this.lastTenGermanToJapaneseTestResultsToStorageString() + "\n");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.correctGermanToJapaneseTestCount, this.correctJapaneseToGermanTestCount, this.filename, this.firstSeenDate, this.germanToJapaneseTestCount, this.japaneseToGermanTestCount, this.key, this.lastCorrectGermanToJapaneseTestDate, this.lastCorrectJapaneseToGermanTestDate, this.lastGermanToJapaneseTestDate, this.lastJapaneseToGermanTestDate, this.lastTenGermanToJapaneseTestResults, this.lastTenJapaneseToGermanTestResults);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InternalAdditionalVocableData internalAdditionalVocableData = (InternalAdditionalVocableData)object;
        return this.correctGermanToJapaneseTestCount == internalAdditionalVocableData.correctGermanToJapaneseTestCount && this.correctJapaneseToGermanTestCount == internalAdditionalVocableData.correctJapaneseToGermanTestCount && Objects.equals(this.filename, internalAdditionalVocableData.filename) && Objects.equals(this.firstSeenDate, internalAdditionalVocableData.firstSeenDate) && this.germanToJapaneseTestCount == internalAdditionalVocableData.germanToJapaneseTestCount && this.japaneseToGermanTestCount == internalAdditionalVocableData.japaneseToGermanTestCount && Objects.equals(this.key, internalAdditionalVocableData.key) && Objects.equals(this.lastCorrectGermanToJapaneseTestDate, internalAdditionalVocableData.lastCorrectGermanToJapaneseTestDate) && Objects.equals(this.lastCorrectJapaneseToGermanTestDate, internalAdditionalVocableData.lastCorrectJapaneseToGermanTestDate) && Objects.equals(this.lastGermanToJapaneseTestDate, internalAdditionalVocableData.lastGermanToJapaneseTestDate) && Objects.equals(this.lastJapaneseToGermanTestDate, internalAdditionalVocableData.lastJapaneseToGermanTestDate) && Objects.equals(this.lastTenGermanToJapaneseTestResults, internalAdditionalVocableData.lastTenGermanToJapaneseTestResults) && Objects.equals(this.lastTenJapaneseToGermanTestResults, internalAdditionalVocableData.lastTenJapaneseToGermanTestResults);
    }
}

