/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.persistence;

import de.duehl.basics.system.SystemTools;
import de.duehl.basics.version.Version;
import de.duehl.swing.persistance.SwingSessionManagerHelper;
import de.duehl.vocabulary.japanese.common.color.data.ColorModificationType;
import de.duehl.vocabulary.japanese.common.color.data.DefaultColors;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.data.VocablesSubsetSelectionType;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.common.persistence.KanjiAndKanaColorOptions;
import de.duehl.vocabulary.japanese.common.persistence.RomajiAndPronunciationColorOptions;
import de.duehl.vocabulary.japanese.common.persistence.TranslationCommentAndVocabularyDescriptionColorOptions;
import de.duehl.vocabulary.japanese.common.persistence.data.EmptyTranslationsAcceptance;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Options
implements KanjiAndKanaColorOptions,
RomajiAndPronunciationColorOptions,
TranslationCommentAndVocabularyDescriptionColorOptions {
    private int stringSelectionFontSize = -1;
    private int stringSelectionLabelFontSize = -1;
    private Version lastUsedVersion;
    private String vocabulariesPath;
    private boolean switchToNextVocableAfterEntringTranslation;
    private boolean showRomajiWhenTestingVocable;
    private boolean showPronunciationWhenTestingVocable;
    private boolean showCommentWhenTestingVocable;
    private boolean showVocabularyDescriptionWhenTestingVocable;
    private boolean colorVocableDependingOnLastSuccessWhenTestingVocable;
    private boolean colorVocableDependingOnLastSuccessWhenViewingVocable;
    private VocabularySortOrder vocabularySortOrder;
    private boolean colorVocabularyDependingOnLastSuccess;
    private VocablesShuffleType vocablesShuffleType;
    private VocablesSubsetSelectionType vocablesSubsetSelectionType;
    private boolean reverseShuffledVocables;
    private boolean useVocablesShuffleTypeForShowingListsAndSheetsToo;
    private boolean hideStartOfVocabularyDescription;
    private boolean useTestOrderForViewingVocables;
    private int lastShownMainTabIndex;
    private int lastShownVocabularyCategoryTabIndex;
    private int lastShownOwnListCategoryTabIndex;
    private int lastShownVocabularySubCategoryTabIndex;
    private int lastShownOwnListSubCategoryTabIndex;
    private boolean showSuccessPercentInVocabularyBar;
    private int numberOfVocabularyBarColumns;
    private String lastUsedOwnListImportExportDirectory;
    private int numberOfDatasetsPerPageOfOwnListEditor;
    private int numberOfColumnsOfOwnListEditor;
    private Point locationOfOwnListEditor;
    private Dimension sizeOfOwnListEditor;
    private boolean hideVocablesFromListInSearchAreaInOwnListEditor;
    private boolean allowMissingMp3;
    private boolean reportMissingMp3;
    private int numberOfColumnsOfBlattDarstellung;
    private boolean informAboutDoubleMp3AtStartup;
    private boolean useOnlyFirstGermanTermWhenTestingVocableGermanToJapanese;
    private TranslationDirection translationDirection;
    private boolean showKanjiWhenTestingVocable;
    private boolean hideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana;
    private boolean hideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana;
    private boolean hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana;
    private boolean showDetailsButtonInEinzeldarstellung;
    private boolean showDetailsButtonInVokabelblattDarstellung;
    private boolean hideLessStartOfVocabularyDescriptionForVhs;
    private boolean informAboutEqualKanaAndKanjiAtStartup;
    private boolean showKanaWhenTestingVocable;
    private boolean checkNewOwnListsVersionAtStart;
    private boolean showKanaInKanjiSizeWhenTestingVocable;
    private EmptyTranslationsAcceptance emptyTranslationsAcceptance;
    private int numberOfDaysForAWhile;
    private int numberOfDaysAVocableIsNew;
    private List<Color> colors;
    private int deltaForForegroundColor;
    private int deltaForBackgroundColor;
    private ColorModificationType colorModificationType;
    private boolean useSplitPaneInOwnListEditor;
    private Color vocableColorStandard;
    private Color vocableColorKanji;
    private Color vocableColorKana;
    private Color vocableColorRomaji;
    private Color vocableColorPronunciation;
    private Color vocableColorTranslation;
    private Color vocableColorComment;
    private Color vocableColorSearchWords;
    private Color vocableColorPartOfSpeach;
    private boolean showTimestampsInStartup;
    private boolean createGermanJapaneseTranslationAtStartup;
    private String lastUsed7ZipDirectory;
    private String lastSelectedKanjiSetTextInCombobox;
    private boolean informAboutEOrUInVocableFieldAusspracheAtStartup;
    private int numberOfRememberedOwnLists;
    private HistoricalOwnListPersistanceDataList historicalLeftOwnListsInListCommander;
    private HistoricalOwnListPersistanceDataList historicalRightOwnListsInListCommander;
    private HistoricalOwnListPersistanceDataList historicalOwnLists;
    private boolean showAllTranslations;
    private int numberOfShownTranslations;
    private boolean showNumberOfListsInLister;
    private boolean showDetailBottomButonsInEinzeldarstellungToo;
    private boolean showDetailBottomButonsInTranslationEvaluationToo;
    private boolean playMP3WhenTestingVocables;
    private boolean colorUserInputAtKanjiTestEvaluationDialog;
    private boolean stopAfterStartup;
    private boolean waitForXAfterStartup;
    private boolean grammarTableShowKanji;
    private boolean grammarTableShowKana;
    private boolean grammarTableShowRomaji;
    private boolean grammarTableSearchForBaseForms;
    private boolean grammarTableLeaveNotFoundFormsBlank;
    private final Map<String, String> grammarTableVerbHeadersMap;
    private final Map<String, String> grammarTableIAdjectiveHeadersMap;
    private final Map<String, String> grammarTableNaAdjectiveHeadersMap;
    private boolean grammarTableUseUserHeaders;
    private String grammarTableLastUsedOwnHeadersDirectory;

    public Options(Version version) {
        this.lastUsedVersion = version;
        this.vocabulariesPath = "";
        this.switchToNextVocableAfterEntringTranslation = true;
        this.showRomajiWhenTestingVocable = true;
        this.showPronunciationWhenTestingVocable = true;
        this.showCommentWhenTestingVocable = false;
        this.showVocabularyDescriptionWhenTestingVocable = false;
        this.colorVocableDependingOnLastSuccessWhenTestingVocable = true;
        this.colorVocableDependingOnLastSuccessWhenViewingVocable = true;
        this.vocabularySortOrder = VocabularySortOrder.ALPHABETICAL;
        this.colorVocabularyDependingOnLastSuccess = true;
        this.vocablesShuffleType = VocablesShuffleType.RANDOM;
        this.vocablesSubsetSelectionType = VocablesSubsetSelectionType.RANDOM_AND_LAST_ANSWER_SUCCESS;
        this.reverseShuffledVocables = false;
        this.useVocablesShuffleTypeForShowingListsAndSheetsToo = false;
        this.hideStartOfVocabularyDescription = true;
        this.useTestOrderForViewingVocables = false;
        this.lastShownMainTabIndex = -1;
        this.lastShownVocabularyCategoryTabIndex = -1;
        this.lastShownOwnListCategoryTabIndex = -1;
        this.lastShownVocabularySubCategoryTabIndex = -1;
        this.lastShownOwnListSubCategoryTabIndex = -1;
        this.showSuccessPercentInVocabularyBar = true;
        this.numberOfVocabularyBarColumns = 3;
        this.lastUsedOwnListImportExportDirectory = SystemTools.getHomeDirectory();
        this.numberOfDatasetsPerPageOfOwnListEditor = 20;
        this.numberOfColumnsOfOwnListEditor = 2;
        this.locationOfOwnListEditor = SwingSessionManagerHelper.NOT_INITIALISED_POINT;
        this.sizeOfOwnListEditor = SwingSessionManagerHelper.NOT_INITIALISED_DIMENSION;
        this.hideVocablesFromListInSearchAreaInOwnListEditor = false;
        this.allowMissingMp3 = true;
        this.reportMissingMp3 = false;
        this.numberOfColumnsOfBlattDarstellung = 3;
        this.informAboutDoubleMp3AtStartup = false;
        this.useOnlyFirstGermanTermWhenTestingVocableGermanToJapanese = true;
        this.translationDirection = TranslationDirection.JAPANESE_TO_GERMAN;
        this.showKanjiWhenTestingVocable = true;
        this.hideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana = false;
        this.hideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana = false;
        this.hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana = false;
        this.showDetailsButtonInEinzeldarstellung = false;
        this.showDetailsButtonInVokabelblattDarstellung = false;
        this.hideLessStartOfVocabularyDescriptionForVhs = true;
        this.informAboutEqualKanaAndKanjiAtStartup = false;
        this.showKanaWhenTestingVocable = true;
        this.checkNewOwnListsVersionAtStart = true;
        this.showKanaInKanjiSizeWhenTestingVocable = false;
        this.emptyTranslationsAcceptance = EmptyTranslationsAcceptance.NOT_IMMEDIATELY;
        this.numberOfDaysForAWhile = 30;
        this.numberOfDaysAVocableIsNew = 7;
        this.colors = DefaultColors.INTENSIVE_COLORS;
        this.deltaForForegroundColor = -110;
        this.deltaForBackgroundColor = 180;
        this.colorModificationType = ColorModificationType.MULTIPLICATIVE;
        this.useSplitPaneInOwnListEditor = true;
        this.vocableColorStandard = Color.BLACK;
        this.vocableColorKanji = Color.RED;
        this.vocableColorKana = Color.BLUE;
        this.vocableColorRomaji = Color.BLACK;
        this.vocableColorPronunciation = Color.DARK_GRAY;
        this.vocableColorTranslation = Color.RED;
        this.vocableColorComment = Color.BLUE;
        this.vocableColorSearchWords = new Color(0, 160, 160);
        this.vocableColorPartOfSpeach = new Color(0, 180, 20);
        this.showTimestampsInStartup = false;
        this.createGermanJapaneseTranslationAtStartup = true;
        this.lastUsed7ZipDirectory = "";
        this.lastSelectedKanjiSetTextInCombobox = "";
        this.informAboutEOrUInVocableFieldAusspracheAtStartup = false;
        this.numberOfRememberedOwnLists = 10;
        this.historicalLeftOwnListsInListCommander = new HistoricalOwnListPersistanceDataList(this.numberOfRememberedOwnLists);
        this.historicalRightOwnListsInListCommander = new HistoricalOwnListPersistanceDataList(this.numberOfRememberedOwnLists);
        this.historicalOwnLists = new HistoricalOwnListPersistanceDataList(this.numberOfRememberedOwnLists);
        this.showAllTranslations = false;
        this.numberOfShownTranslations = 10;
        this.showNumberOfListsInLister = false;
        this.showDetailBottomButonsInEinzeldarstellungToo = true;
        this.showDetailBottomButonsInTranslationEvaluationToo = true;
        this.playMP3WhenTestingVocables = false;
        this.colorUserInputAtKanjiTestEvaluationDialog = true;
        this.stopAfterStartup = false;
        this.waitForXAfterStartup = false;
        this.grammarTableShowKanji = false;
        this.grammarTableShowKana = true;
        this.grammarTableShowRomaji = false;
        this.grammarTableSearchForBaseForms = true;
        this.grammarTableLeaveNotFoundFormsBlank = true;
        this.grammarTableVerbHeadersMap = new HashMap<String, String>();
        this.grammarTableIAdjectiveHeadersMap = new HashMap<String, String>();
        this.grammarTableNaAdjectiveHeadersMap = new HashMap<String, String>();
        this.grammarTableUseUserHeaders = true;
        this.grammarTableLastUsedOwnHeadersDirectory = SystemTools.getHomeDirectory();
    }

    public int getStringSelectionFontSize() {
        return this.stringSelectionFontSize;
    }

    public void setStringSelectionFontSize(int n) {
        this.stringSelectionFontSize = n;
    }

    public int getStringSelectionLabelFontSize() {
        return this.stringSelectionLabelFontSize;
    }

    public void setStringSelectionLabelFontSize(int n) {
        this.stringSelectionLabelFontSize = n;
    }

    public Version getLastUsedVersion() {
        return this.lastUsedVersion;
    }

    public void setLastUsedVersion(Version version) {
        this.lastUsedVersion = version;
    }

    public String getVocabulariesPath() {
        return this.vocabulariesPath;
    }

    public void setVocabulariesPath(String string) {
        this.vocabulariesPath = string;
    }

    public boolean isSwitchToNextVocableAfterEntringTranslation() {
        return this.switchToNextVocableAfterEntringTranslation;
    }

    public void setSwitchToNextVocableAfterEntringTranslation(boolean bl) {
        this.switchToNextVocableAfterEntringTranslation = bl;
    }

    public boolean isShowRomajiWhenTestingVocable() {
        return this.showRomajiWhenTestingVocable;
    }

    public void setShowRomajiWhenTestingVocable(boolean bl) {
        this.showRomajiWhenTestingVocable = bl;
    }

    public boolean isShowPronunciationWhenTestingVocable() {
        return this.showPronunciationWhenTestingVocable;
    }

    public void setShowPronunciationWhenTestingVocable(boolean bl) {
        this.showPronunciationWhenTestingVocable = bl;
    }

    public boolean isShowCommentWhenTestingVocable() {
        return this.showCommentWhenTestingVocable;
    }

    public void setShowCommentWhenTestingVocable(boolean bl) {
        this.showCommentWhenTestingVocable = bl;
    }

    public boolean isShowVocabularyDescriptionWhenTestingVocable() {
        return this.showVocabularyDescriptionWhenTestingVocable;
    }

    public void setShowVocabularyDescriptionWhenTestingVocable(boolean bl) {
        this.showVocabularyDescriptionWhenTestingVocable = bl;
    }

    public boolean isColorVocableDependingOnLastSuccessWhenTestingVocable() {
        return this.colorVocableDependingOnLastSuccessWhenTestingVocable;
    }

    public void setColorVocableDependingOnLastSuccessWhenTestingVocable(boolean bl) {
        this.colorVocableDependingOnLastSuccessWhenTestingVocable = bl;
    }

    public boolean isColorVocableDependingOnLastSuccessWhenViewingVocable() {
        return this.colorVocableDependingOnLastSuccessWhenViewingVocable;
    }

    public void setColorVocableDependingOnLastSuccessWhenViewingVocable(boolean bl) {
        this.colorVocableDependingOnLastSuccessWhenViewingVocable = bl;
    }

    public VocabularySortOrder getVocabularySortOrder() {
        return this.vocabularySortOrder;
    }

    public void setVocabularySortOrder(VocabularySortOrder vocabularySortOrder) {
        this.vocabularySortOrder = vocabularySortOrder;
    }

    public boolean isColorVocabularyDependingOnLastSuccess() {
        return this.colorVocabularyDependingOnLastSuccess;
    }

    public void setColorVocabularyDependingOnLastSuccess(boolean bl) {
        this.colorVocabularyDependingOnLastSuccess = bl;
    }

    public VocablesShuffleType getVocablesShuffleType() {
        return this.vocablesShuffleType;
    }

    public void setVocablesShuffleType(VocablesShuffleType vocablesShuffleType) {
        this.vocablesShuffleType = vocablesShuffleType;
    }

    public VocablesSubsetSelectionType getVocablesSubsetSelectionType() {
        return this.vocablesSubsetSelectionType;
    }

    public void setVocablesSubsetSelectionType(VocablesSubsetSelectionType vocablesSubsetSelectionType) {
        this.vocablesSubsetSelectionType = vocablesSubsetSelectionType;
    }

    public boolean isReverseShuffledVocables() {
        return this.reverseShuffledVocables;
    }

    public void setReverseShuffledVocables(boolean bl) {
        this.reverseShuffledVocables = bl;
    }

    public boolean isUseVocablesShuffleTypeForShowingListsAndSheetsToo() {
        return this.useVocablesShuffleTypeForShowingListsAndSheetsToo;
    }

    public void setUseVocablesShuffleTypeForShowingListsAndSheetsToo(boolean bl) {
        this.useVocablesShuffleTypeForShowingListsAndSheetsToo = bl;
    }

    public boolean isHideStartOfVocabularyDescription() {
        return this.hideStartOfVocabularyDescription;
    }

    public void setHideStartOfVocabularyDescription(boolean bl) {
        this.hideStartOfVocabularyDescription = bl;
    }

    public boolean isUseTestOrderForViewingVocables() {
        return this.useTestOrderForViewingVocables;
    }

    public void setUseTestOrderForViewingVocables(boolean bl) {
        this.useTestOrderForViewingVocables = bl;
    }

    public int getLastShownMainTabIndex() {
        return this.lastShownMainTabIndex;
    }

    public void setLastShownMainTabIndex(int n) {
        this.lastShownMainTabIndex = n;
    }

    public int getLastShownVocabularyCategoryTabIndex() {
        return this.lastShownVocabularyCategoryTabIndex;
    }

    public void setLastShownVocabularyCategoryTabIndex(int n) {
        this.lastShownVocabularyCategoryTabIndex = n;
    }

    public int getLastShownOwnListCategoryTabIndex() {
        return this.lastShownOwnListCategoryTabIndex;
    }

    public void setLastShownOwnListCategoryTabIndex(int n) {
        this.lastShownOwnListCategoryTabIndex = n;
    }

    public int getLastShownVocabularySubCategoryTabIndex() {
        return this.lastShownVocabularySubCategoryTabIndex;
    }

    public void setLastShownVocabularySubCategoryTabIndex(int n) {
        this.lastShownVocabularySubCategoryTabIndex = n;
    }

    public int getLastShownOwnListSubCategoryTabIndex() {
        return this.lastShownOwnListSubCategoryTabIndex;
    }

    public void setLastShownOwnListSubCategoryTabIndex(int n) {
        this.lastShownOwnListSubCategoryTabIndex = n;
    }

    public boolean isShowSuccessPercentInVocabularyBar() {
        return this.showSuccessPercentInVocabularyBar;
    }

    public void setShowSuccessPercentInVocabularyBar(boolean bl) {
        this.showSuccessPercentInVocabularyBar = bl;
    }

    public int getNumberOfVocabularyBarColumns() {
        return this.numberOfVocabularyBarColumns;
    }

    public void setNumberOfVocabularyBarColumns(int n) {
        this.numberOfVocabularyBarColumns = n;
    }

    public String getLastUsedOwnListImportExportDirectory() {
        return this.lastUsedOwnListImportExportDirectory;
    }

    public void setLastUsedOwnListImportExportDirectory(String string) {
        this.lastUsedOwnListImportExportDirectory = string;
    }

    public int getNumberOfDatasetsPerPageOfOwnListEditor() {
        return this.numberOfDatasetsPerPageOfOwnListEditor;
    }

    public void setNumberOfDatasetsPerPageOfOwnListEditor(int n) {
        this.numberOfDatasetsPerPageOfOwnListEditor = n;
    }

    public int getNumberOfColumnsOfOwnListEditor() {
        return this.numberOfColumnsOfOwnListEditor;
    }

    public void setNumberOfColumnsOfOwnListEditor(int n) {
        this.numberOfColumnsOfOwnListEditor = n;
    }

    public Point getLocationOfOwnListEditor() {
        return this.locationOfOwnListEditor;
    }

    public void setLocationOfOwnListEditor(Point point) {
        this.locationOfOwnListEditor = point;
    }

    public Dimension getSizeOfOwnListEditor() {
        return this.sizeOfOwnListEditor;
    }

    public void setSizeOfOwnListEditor(Dimension dimension) {
        this.sizeOfOwnListEditor = dimension;
    }

    public boolean isHideVocablesFromListInSearchAreaInOwnListEditor() {
        return this.hideVocablesFromListInSearchAreaInOwnListEditor;
    }

    public void setHideVocablesFromListInSearchAreaInOwnListEditor(boolean bl) {
        this.hideVocablesFromListInSearchAreaInOwnListEditor = bl;
    }

    public boolean isAllowMissingMp3() {
        return this.allowMissingMp3;
    }

    public void setAllowMissingMp3(boolean bl) {
        this.allowMissingMp3 = bl;
    }

    public boolean isReportMissingMp3() {
        return this.reportMissingMp3;
    }

    public void setReportMissingMp3(boolean bl) {
        this.reportMissingMp3 = bl;
    }

    public int getNumberOfColumnsOfBlattDarstellung() {
        return this.numberOfColumnsOfBlattDarstellung;
    }

    public void setNumberOfColumnsOfBlattDarstellung(int n) {
        this.numberOfColumnsOfBlattDarstellung = n;
    }

    public boolean isInformAboutDoubleMp3AtStartup() {
        return this.informAboutDoubleMp3AtStartup;
    }

    public void setInformAboutDoubleMp3AtStartup(boolean bl) {
        this.informAboutDoubleMp3AtStartup = bl;
    }

    public boolean isUseOnlyFirstGermanTermWhenTestingVocableGermanToJapanese() {
        return this.useOnlyFirstGermanTermWhenTestingVocableGermanToJapanese;
    }

    public void setUseOnlyFirstGermanTermWhenTestingVocableGermanToJapanese(boolean bl) {
        this.useOnlyFirstGermanTermWhenTestingVocableGermanToJapanese = bl;
    }

    public TranslationDirection getTranslationDirection() {
        return this.translationDirection;
    }

    public void setTranslationDirection(TranslationDirection translationDirection) {
        this.translationDirection = translationDirection;
    }

    public boolean isShowKanjiWhenTestingVocable() {
        return this.showKanjiWhenTestingVocable;
    }

    public void setShowKanjiWhenTestingVocable(boolean bl) {
        this.showKanjiWhenTestingVocable = bl;
    }

    public boolean isHideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana() {
        return this.hideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana;
    }

    public void setHideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana(boolean bl) {
        this.hideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana = bl;
    }

    public boolean isHideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana() {
        return this.hideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana;
    }

    public void setHideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana(boolean bl) {
        this.hideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana = bl;
    }

    public boolean isHidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana() {
        return this.hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana;
    }

    public void setHidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana(boolean bl) {
        this.hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana = bl;
    }

    public boolean isShowDetailsButtonInEinzeldarstellung() {
        return this.showDetailsButtonInEinzeldarstellung;
    }

    public void setShowDetailsButtonInEinzeldarstellung(boolean bl) {
        this.showDetailsButtonInEinzeldarstellung = bl;
    }

    public boolean isShowDetailsButtonInVokabelblattDarstellung() {
        return this.showDetailsButtonInVokabelblattDarstellung;
    }

    public void setShowDetailsButtonInVokabelblattDarstellung(boolean bl) {
        this.showDetailsButtonInVokabelblattDarstellung = bl;
    }

    public boolean isHideLessStartOfVocabularyDescriptionForVhs() {
        return this.hideLessStartOfVocabularyDescriptionForVhs;
    }

    public void setHideLessStartOfVocabularyDescriptionForVhs(boolean bl) {
        this.hideLessStartOfVocabularyDescriptionForVhs = bl;
    }

    public boolean isInformAboutEqualKanaAndKanjiAtStartup() {
        return this.informAboutEqualKanaAndKanjiAtStartup;
    }

    public void setInformAboutEqualKanaAndKanjiAtStartup(boolean bl) {
        this.informAboutEqualKanaAndKanjiAtStartup = bl;
    }

    public boolean isShowKanaWhenTestingVocable() {
        return this.showKanaWhenTestingVocable;
    }

    public void setShowKanaWhenTestingVocable(boolean bl) {
        this.showKanaWhenTestingVocable = bl;
    }

    public boolean isCheckNewOwnListsVersionAtStart() {
        return this.checkNewOwnListsVersionAtStart;
    }

    public void setCheckNewOwnListsVersionAtStart(boolean bl) {
        this.checkNewOwnListsVersionAtStart = bl;
    }

    public boolean isShowKanaInKanjiSizeWhenTestingVocable() {
        return this.showKanaInKanjiSizeWhenTestingVocable;
    }

    public void setShowKanaInKanjiSizeWhenTestingVocable(boolean bl) {
        this.showKanaInKanjiSizeWhenTestingVocable = bl;
    }

    public EmptyTranslationsAcceptance getEmptyTranslationsAcceptance() {
        return this.emptyTranslationsAcceptance;
    }

    public void setEmptyTranslationsAcceptance(EmptyTranslationsAcceptance emptyTranslationsAcceptance) {
        this.emptyTranslationsAcceptance = emptyTranslationsAcceptance;
    }

    public int getNumberOfDaysForAWhile() {
        return this.numberOfDaysForAWhile;
    }

    public void setNumberOfDaysForAWhile(int n) {
        this.numberOfDaysForAWhile = n;
    }

    public int getNumberOfDaysAVocableIsNew() {
        return this.numberOfDaysAVocableIsNew;
    }

    public void setNumberOfDaysAVocableIsNew(int n) {
        this.numberOfDaysAVocableIsNew = n;
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public void setColors(List<Color> list) {
        if (list.size() != 11) {
            throw new RuntimeException("Es gibt nicht wie erwartet 11 Farben, sondern " + list.size() + ".");
        }
        this.colors = list;
    }

    public int getDeltaForForegroundColor() {
        return this.deltaForForegroundColor;
    }

    public void setDeltaForForegroundColor(int n) {
        this.deltaForForegroundColor = n;
    }

    public int getDeltaForBackgroundColor() {
        return this.deltaForBackgroundColor;
    }

    public void setDeltaForBackgroundColor(int n) {
        this.deltaForBackgroundColor = n;
    }

    public ColorModificationType getColorModificationType() {
        return this.colorModificationType;
    }

    public void setColorModificationType(ColorModificationType colorModificationType) {
        this.colorModificationType = colorModificationType;
    }

    public boolean isUseSplitPaneInOwnListEditor() {
        return this.useSplitPaneInOwnListEditor;
    }

    public void setUseSplitPaneInOwnListEditor(boolean bl) {
        this.useSplitPaneInOwnListEditor = bl;
    }

    @Override
    public Color getVocableColorStandard() {
        return this.vocableColorStandard;
    }

    public void setVocableColorStandard(Color color) {
        this.vocableColorStandard = color;
    }

    @Override
    public Color getVocableColorKanji() {
        return this.vocableColorKanji;
    }

    public void setVocableColorKanji(Color color) {
        this.vocableColorKanji = color;
    }

    @Override
    public Color getVocableColorKana() {
        return this.vocableColorKana;
    }

    public void setVocableColorKana(Color color) {
        this.vocableColorKana = color;
    }

    @Override
    public Color getVocableColorRomaji() {
        return this.vocableColorRomaji;
    }

    public void setVocableColorRomaji(Color color) {
        this.vocableColorRomaji = color;
    }

    @Override
    public Color getVocableColorPronunciation() {
        return this.vocableColorPronunciation;
    }

    public void setVocableColorPronunciation(Color color) {
        this.vocableColorPronunciation = color;
    }

    @Override
    public Color getVocableColorTranslation() {
        return this.vocableColorTranslation;
    }

    public void setVocableColorTranslation(Color color) {
        this.vocableColorTranslation = color;
    }

    @Override
    public Color getVocableColorComment() {
        return this.vocableColorComment;
    }

    public void setVocableColorComment(Color color) {
        this.vocableColorComment = color;
    }

    @Override
    public Color getVocableColorSearchWords() {
        return this.vocableColorSearchWords;
    }

    public void setVocableColorSearchWords(Color color) {
        this.vocableColorSearchWords = color;
    }

    @Override
    public Color getVocableColorPartOfSpeach() {
        return this.vocableColorPartOfSpeach;
    }

    public void setVocableColorPartOfSpeach(Color color) {
        this.vocableColorPartOfSpeach = color;
    }

    public boolean isShowTimestampsInStartup() {
        return this.showTimestampsInStartup;
    }

    public void setShowTimestampsInStartup(boolean bl) {
        this.showTimestampsInStartup = bl;
    }

    public boolean isCreateGermanJapaneseTranslationAtStartup() {
        return this.createGermanJapaneseTranslationAtStartup;
    }

    public void setCreateGermanJapaneseTranslationAtStartup(boolean bl) {
        this.createGermanJapaneseTranslationAtStartup = bl;
    }

    public String getLastUsed7ZipDirectory() {
        return this.lastUsed7ZipDirectory;
    }

    public void setLastUsed7ZipDirectory(String string) {
        this.lastUsed7ZipDirectory = string;
    }

    public String getLastSelectedKanjiSetTextInCombobox() {
        return this.lastSelectedKanjiSetTextInCombobox;
    }

    public void setLastSelectedKanjiSetTextInCombobox(String string) {
        this.lastSelectedKanjiSetTextInCombobox = string;
    }

    public boolean isInformAboutEOrUInVocableFieldAusspracheAtStartup() {
        return this.informAboutEOrUInVocableFieldAusspracheAtStartup;
    }

    public void setInformAboutEOrUInVocableFieldAusspracheAtStartup(boolean bl) {
        this.informAboutEOrUInVocableFieldAusspracheAtStartup = bl;
    }

    public int getNumberOfRememberedOwnLists() {
        return this.numberOfRememberedOwnLists;
    }

    public void setNumberOfRememberedOwnLists(int n) {
        this.numberOfRememberedOwnLists = n;
        this.historicalLeftOwnListsInListCommander.setNumberOfRememberedOwnLists(n);
        this.historicalRightOwnListsInListCommander.setNumberOfRememberedOwnLists(n);
    }

    public HistoricalOwnListPersistanceDataList getHistoricalLeftOwnListsInListCommander() {
        return this.historicalLeftOwnListsInListCommander;
    }

    public void setHistoricalLeftOwnListsInListCommander(HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList) {
        this.historicalLeftOwnListsInListCommander = historicalOwnListPersistanceDataList;
    }

    public HistoricalOwnListPersistanceDataList getHistoricalRightOwnListsInListCommander() {
        return this.historicalRightOwnListsInListCommander;
    }

    public void setHistoricalRightOwnListsInListCommander(HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList) {
        this.historicalRightOwnListsInListCommander = historicalOwnListPersistanceDataList;
    }

    public HistoricalOwnListPersistanceDataList getHistoricalOwnLists() {
        return this.historicalOwnLists;
    }

    public void setHistoricalOwnLists(HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList) {
        this.historicalOwnLists = historicalOwnListPersistanceDataList;
    }

    public boolean isShowAllTranslations() {
        return this.showAllTranslations;
    }

    public void setShowAllTranslations(boolean bl) {
        this.showAllTranslations = bl;
    }

    public int getNumberOfShownTranslations() {
        return this.numberOfShownTranslations;
    }

    public void setNumberOfShownTranslations(int n) {
        this.numberOfShownTranslations = n;
    }

    public boolean isShowNumberOfListsInLister() {
        return this.showNumberOfListsInLister;
    }

    public void setShowNumberOfListsInLister(boolean bl) {
        this.showNumberOfListsInLister = bl;
    }

    public boolean isShowDetailBottomButonsInEinzeldarstellungToo() {
        return this.showDetailBottomButonsInEinzeldarstellungToo;
    }

    public void setShowDetailBottomButonsInEinzeldarstellungToo(boolean bl) {
        this.showDetailBottomButonsInEinzeldarstellungToo = bl;
    }

    public boolean isShowDetailBottomButonsInTranslationEvaluationToo() {
        return this.showDetailBottomButonsInTranslationEvaluationToo;
    }

    public void setShowDetailBottomButonsInTranslationEvaluationToo(boolean bl) {
        this.showDetailBottomButonsInTranslationEvaluationToo = bl;
    }

    public boolean isPlayMP3WhenTestingVocables() {
        return this.playMP3WhenTestingVocables;
    }

    public void setPlayMP3WhenTestingVocables(boolean bl) {
        this.playMP3WhenTestingVocables = bl;
    }

    public boolean isColorUserInputAtKanjiTestEvaluationDialog() {
        return this.colorUserInputAtKanjiTestEvaluationDialog;
    }

    public void setColorUserInputAtKanjiTestEvaluationDialog(boolean bl) {
        this.colorUserInputAtKanjiTestEvaluationDialog = bl;
    }

    public boolean isStopAfterStartup() {
        return this.stopAfterStartup;
    }

    public void setStopAfterStartup(boolean bl) {
        this.stopAfterStartup = bl;
    }

    public boolean isWaitForXAfterStartup() {
        return this.waitForXAfterStartup;
    }

    public void setWaitForXAfterStartup(boolean bl) {
        this.waitForXAfterStartup = bl;
    }

    public boolean isGrammarTableShowKanji() {
        return this.grammarTableShowKanji;
    }

    public void setGrammarTableShowKanji(boolean bl) {
        this.grammarTableShowKanji = bl;
    }

    public boolean isGrammarTableShowKana() {
        return this.grammarTableShowKana;
    }

    public void setGrammarTableShowKana(boolean bl) {
        this.grammarTableShowKana = bl;
    }

    public boolean isGrammarTableShowRomaji() {
        return this.grammarTableShowRomaji;
    }

    public void setGrammarTableShowRomaji(boolean bl) {
        this.grammarTableShowRomaji = bl;
    }

    public boolean isGrammarTableSearchForBaseForms() {
        return this.grammarTableSearchForBaseForms;
    }

    public void setGrammarTableSearchForBaseForms(boolean bl) {
        this.grammarTableSearchForBaseForms = bl;
    }

    public boolean isGrammarTableLeaveNotFoundFormsBlank() {
        return this.grammarTableLeaveNotFoundFormsBlank;
    }

    public void setGrammarTableLeaveNotFoundFormsBlank(boolean bl) {
        this.grammarTableLeaveNotFoundFormsBlank = bl;
    }

    public Map<String, String> getGrammarTableVerbHeadersMap() {
        return this.grammarTableVerbHeadersMap;
    }

    public Map<String, String> getGrammarTableIAdjectiveHeadersMap() {
        return this.grammarTableIAdjectiveHeadersMap;
    }

    public Map<String, String> getGrammarTableNaAdjectiveHeadersMap() {
        return this.grammarTableNaAdjectiveHeadersMap;
    }

    public boolean isGrammarTableUseUserHeaders() {
        return this.grammarTableUseUserHeaders;
    }

    public void setGrammarTableUseUserHeaders(boolean bl) {
        this.grammarTableUseUserHeaders = bl;
    }

    public String getGrammarTableLastUsedOwnHeadersDirectory() {
        return this.grammarTableLastUsedOwnHeadersDirectory;
    }

    public void setGrammarTableLastUsedOwnHeadersDirectory(String string) {
        this.grammarTableLastUsedOwnHeadersDirectory = string;
    }
}

