/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.persistence.data;

import de.duehl.basics.text.Text;
import java.util.List;
import java.util.Objects;

public class OwnListPersistanceData {
    private String category = "";
    private String subCategory = "";
    private String name = "";
    private static final String PERISTANCE_SEPARATOR = "#;#";

    public boolean isInitialised() {
        return !this.category.isBlank() && !this.subCategory.isBlank() && !this.name.isBlank();
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(String string) {
        this.subCategory = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toPersistanceString() {
        return this.category + PERISTANCE_SEPARATOR + this.subCategory + PERISTANCE_SEPARATOR + this.name;
    }

    public static OwnListPersistanceData createFromPersistanceString(String string) {
        List<String> list = Text.splitBy(string, PERISTANCE_SEPARATOR);
        if (list.size() == 3) {
            int n = 0;
            String string2 = list.get(n++);
            String string3 = list.get(n++);
            String string4 = list.get(n++);
            OwnListPersistanceData ownListPersistanceData = new OwnListPersistanceData();
            ownListPersistanceData.setCategory(string2);
            ownListPersistanceData.setSubCategory(string3);
            ownListPersistanceData.setName(string4);
            if (ownListPersistanceData.isInitialised()) {
                return ownListPersistanceData;
            }
        }
        return new OwnListPersistanceData();
    }

    public String toString() {
        return "OwListPersistanceData [category=" + this.category + ", subCategory=" + this.subCategory + ", name=" + this.name + "]";
    }

    public int hashCode() {
        return Objects.hash(this.category, this.name, this.subCategory);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OwnListPersistanceData ownListPersistanceData = (OwnListPersistanceData)object;
        return Objects.equals(this.category, ownListPersistanceData.category) && Objects.equals(this.name, ownListPersistanceData.name) && Objects.equals(this.subCategory, ownListPersistanceData.subCategory);
    }
}

