/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.ui.dialogs;

import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DialogWithCopyableUrl
extends ModalDialogBase {
    private static final int DIALOG_WIDTH = 750;
    private static final int BIGGER_TEXT_FACTOR = 5;
    private final String message;
    private final String beforeUrl;
    private final String afterUrl;
    private final JTextField textField;

    public DialogWithCopyableUrl(String string, String string2, String string3, String string4, String string5, Point point, Image image) {
        super(point, image, string);
        this.message = string2;
        this.beforeUrl = string3;
        this.afterUrl = string5;
        this.addEscapeBehaviour();
        this.addClosingWindowListener(() -> this.closeDialog());
        this.textField = new JTextField(string4);
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.textField.setEditable(false);
        this.textField.setFocusable(true);
        this.textField.setBackground(SelectionsHelper.NOT_EDITABLE_FIELD_COLOR);
        GuiTools.setMonospacedFont(this.textField);
        GuiTools.biggerFont(this.textField, 5);
    }

    @Override
    protected void populateDialog() {
        this.add(this.createMainPart(), "Center");
        this.add(this.createButtonPart(), "South");
    }

    private Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createDummyPanel(), "North");
        jPanel.add(this.createMessagePart(), "Center");
        jPanel.add(this.createUrlPart(), "South");
        return jPanel;
    }

    private Component createDummyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(750, 0));
        return jPanel;
    }

    private Component createMessagePart() {
        return DialogWithCopyableUrl.createLabel(this.message + "\n\n");
    }

    private Component createUrlPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createLabelBeforeUrl());
        jPanel.add(this.textField);
        jPanel.add(this.createLabelAfterUrl());
        return jPanel;
    }

    private Component createLabelBeforeUrl() {
        return DialogWithCopyableUrl.createLabel(this.beforeUrl);
    }

    private Component createLabelAfterUrl() {
        return DialogWithCopyableUrl.createLabel(this.afterUrl);
    }

    private static Component createLabel(String string) {
        JLabel jLabel = new JLabel(HtmlTool.htmlify(string));
        GuiTools.biggerFont(jLabel, 5);
        return jLabel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createOKButton(), "East");
        return jPanel;
    }

    private Component createOKButton() {
        JButton jButton = new JButton("Schlie\u00dfen");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }
}

