/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.data.symbol;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.data.symbol.Kana;
import de.duehl.vocabulary.japanese.data.symbol.KanaSubType;
import java.util.ArrayList;
import java.util.List;

public enum Katakana {
    A("\u30a2", "a", KanaSubType.STANDARD),
    I("\u30a4", "i", KanaSubType.STANDARD),
    U("\u30a6", "u", KanaSubType.STANDARD),
    E("\u30a8", "e", KanaSubType.STANDARD),
    O("\u30aa", "o", KanaSubType.STANDARD),
    KA("\u30ab", "ka", KanaSubType.STANDARD),
    KI("\u30ad", "ki", KanaSubType.STANDARD),
    KU("\u30af", "ku", KanaSubType.STANDARD),
    KE("\u30b1", "ke", KanaSubType.STANDARD),
    KO("\u30b3", "ko", KanaSubType.STANDARD),
    SA("\u30b5", "sa", KanaSubType.STANDARD),
    SHI("\u30b7", "shi", KanaSubType.STANDARD),
    SU("\u30b9", "su", KanaSubType.STANDARD),
    SE("\u30bb", "se", KanaSubType.STANDARD),
    SO("\u30bd", "so", KanaSubType.STANDARD),
    TA("\u30bf", "ta", KanaSubType.STANDARD),
    CHI("\u30c1", "chi", KanaSubType.STANDARD),
    TSU("\u30c4", "tsu", KanaSubType.STANDARD),
    TE("\u30c6", "te", KanaSubType.STANDARD),
    TO("\u30c8", "to", KanaSubType.STANDARD),
    NA("\u30ca", "na", KanaSubType.STANDARD),
    NI("\u30cb", "ni", KanaSubType.STANDARD),
    NU("\u30cc", "nu", KanaSubType.STANDARD),
    NE("\u30cd", "ne", KanaSubType.STANDARD),
    NO("\u30ce", "no", KanaSubType.STANDARD),
    HA("\u30cf", "ha", KanaSubType.STANDARD),
    HI("\u30d2", "hi", KanaSubType.STANDARD),
    FU("\u30d5", "fu", KanaSubType.STANDARD),
    HE("\u30d8", "he", KanaSubType.STANDARD),
    HO("\u30db", "ho", KanaSubType.STANDARD),
    MA("\u30de", "ma", KanaSubType.STANDARD),
    MI("\u30df", "mi", KanaSubType.STANDARD),
    MU("\u30e0", "mu", KanaSubType.STANDARD),
    ME("\u30e1", "me", KanaSubType.STANDARD),
    MO("\u30e2", "mo", KanaSubType.STANDARD),
    YA("\u30e4", "ya", KanaSubType.STANDARD),
    YU("\u30e6", "yu", KanaSubType.STANDARD),
    YO("\u30e8", "yo", KanaSubType.STANDARD),
    SMALL_YA("\u30e3", "kleines ya", KanaSubType.SMALL),
    SMALL_YU("\u30e5", "kleines yu", KanaSubType.SMALL),
    SMALL_YO("\u30e7", "kleines yo", KanaSubType.SMALL),
    RA("\u30e9", "ra", KanaSubType.STANDARD),
    RI("\u30ea", "ri", KanaSubType.STANDARD),
    RU("\u30eb", "ru", KanaSubType.STANDARD),
    RE("\u30ec", "re", KanaSubType.STANDARD),
    RO("\u30ed", "ro", KanaSubType.STANDARD),
    WA("\u30ef", "wa", KanaSubType.STANDARD),
    WO("\u30f2", "wo", KanaSubType.STANDARD),
    N("\u30f3", "n", KanaSubType.STANDARD),
    GA("\u30ac", "ga", KanaSubType.WITH_DAKUTEN),
    GI("\u30ae", "gi", KanaSubType.WITH_DAKUTEN),
    GU("\u30b0", "gu", KanaSubType.WITH_DAKUTEN),
    GE("\u30b2", "ge", KanaSubType.WITH_DAKUTEN),
    GO("\u30b4", "go", KanaSubType.WITH_DAKUTEN),
    ZA("\u30b6", "za", KanaSubType.WITH_DAKUTEN),
    JI1("\u30b8", "ji", KanaSubType.WITH_DAKUTEN),
    ZU1("\u30ba", "zu", KanaSubType.WITH_DAKUTEN),
    ZE("\u30bc", "ze", KanaSubType.WITH_DAKUTEN),
    ZO("\u30be", "zo", KanaSubType.WITH_DAKUTEN),
    DA("\u30c0", "da", KanaSubType.WITH_DAKUTEN),
    JI2("\u30c2", "ji", KanaSubType.WITH_DAKUTEN),
    ZU2("\u30c5", "zu", KanaSubType.WITH_DAKUTEN),
    DE("\u30c7", "de", KanaSubType.WITH_DAKUTEN),
    DO("\u30c9", "do", KanaSubType.WITH_DAKUTEN),
    BA("\u30d0", "ba", KanaSubType.WITH_DAKUTEN),
    BI("\u30d3", "bi", KanaSubType.WITH_DAKUTEN),
    BU("\u30d6", "bu", KanaSubType.WITH_DAKUTEN),
    BE("\u30d9", "be", KanaSubType.WITH_DAKUTEN),
    BO("\u30dc", "bo", KanaSubType.WITH_DAKUTEN),
    PA("\u30d1", "pa", KanaSubType.WITH_HANDAKUTEN),
    PI("\u30d4", "pi", KanaSubType.WITH_HANDAKUTEN),
    PU("\u30d7", "pu", KanaSubType.WITH_HANDAKUTEN),
    PE("\u30da", "pe", KanaSubType.WITH_HANDAKUTEN),
    PO("\u30dd", "po", KanaSubType.WITH_HANDAKUTEN),
    KYA("\u30ad\u30e3", "kya", KanaSubType.COMPOUND),
    KYU("\u30ad\u30e5", "kyu", KanaSubType.COMPOUND),
    KYO("\u30ad\u30e7", "kyo", KanaSubType.COMPOUND),
    SHA("\u30b7\u30e3", "sha", KanaSubType.COMPOUND),
    SHU("\u30b7\u30e5", "shu", KanaSubType.COMPOUND),
    SHO("\u30b7\u30e7", "sho", KanaSubType.COMPOUND),
    CHA("\u30c1\u30e3", "cha", KanaSubType.COMPOUND),
    CHU("\u30c1\u30e5", "chu", KanaSubType.COMPOUND),
    CHO("\u30c1\u30e7", "cho", KanaSubType.COMPOUND),
    NYA("\u30cb\u30e3", "nya", KanaSubType.COMPOUND),
    NYU("\u30cb\u30e5", "nyu", KanaSubType.COMPOUND),
    NYO("\u30cb\u30e7", "nyo", KanaSubType.COMPOUND),
    HYA("\u30d2\u30e3", "hya", KanaSubType.COMPOUND),
    HYU("\u30d2\u30e5", "hyu", KanaSubType.COMPOUND),
    HYO("\u30d2\u30e7", "hyo", KanaSubType.COMPOUND),
    MYA("\u30df\u30e3", "mya", KanaSubType.COMPOUND),
    MYU("\u30df\u30e5", "myu", KanaSubType.COMPOUND),
    MYO("\u30df\u30e7", "myo", KanaSubType.COMPOUND),
    RYA("\u30ea\u30e3", "rya", KanaSubType.COMPOUND),
    RYU("\u30ea\u30e5", "ryu", KanaSubType.COMPOUND),
    RYO("\u30ea\u30e7", "ryo", KanaSubType.COMPOUND),
    GYA("\u30ae\u30e3", "gya", KanaSubType.COMPOUND_WITH_DAKUTEN),
    GYU("\u30ae\u30e5", "gyu", KanaSubType.COMPOUND_WITH_DAKUTEN),
    GYO("\u30ae\u30e7", "gyo", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JA1("\u30b8\u30e3", "ja", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JU1("\u30b8\u30e5", "ju", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JO1("\u30b8\u30e7", "jo", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JA2("\u30c2\u30e3", "ja", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JU2("\u30c2\u30e5", "ju", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JO2("\u30c2\u30e7", "jo", KanaSubType.COMPOUND_WITH_DAKUTEN),
    BYA("\u30d3\u30e3", "bya", KanaSubType.COMPOUND_WITH_DAKUTEN),
    BYU("\u30d3\u30e5", "byu", KanaSubType.COMPOUND_WITH_DAKUTEN),
    BYO("\u30d3\u30e7", "byo", KanaSubType.COMPOUND_WITH_DAKUTEN),
    PYA("\u30d4\u30e3", "pya", KanaSubType.COMPOUND_WITH_HANDAKUTEN),
    PYU("\u30d4\u30e5", "pyu", KanaSubType.COMPOUND_WITH_HANDAKUTEN),
    PYO("\u30d4\u30e7", "pyo", KanaSubType.COMPOUND_WITH_HANDAKUTEN),
    LEHNWORT_F1("\u30d5\u30a9", "fo", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_F2("\u30d5\u30a7", "fe", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_F3("\u30d5\u30a3", "fi", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_F4("\u30d5\u30a1", "fa", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_W1("\u30f4\u30a9", "wo", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_W2("\u30f4\u30a7", "we", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_W3("\u30f4", "w", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_W4("\u30f4\u30a3", "wi", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_W5("\u30f4\u30a1", "wa", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_TI("\u30c6\u30a3", "ti", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_DI("\u30c7\u30a3", "di", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_TU("\u30c6\u30e5", "tu", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_DU("\u30c7\u30e5", "du", KanaSubType.FOR_FOREIGN_WORDS),
    SMALL_TSU("\u30c3", "kleines tsu", KanaSubType.SMALL);

    private final String character;
    private final String hepburn;
    private final KanaSubType subType;

    private Katakana(String string2, String string3, KanaSubType kanaSubType) {
        this.character = string2;
        this.hepburn = string3;
        this.subType = kanaSubType;
    }

    public String getCharacter() {
        return this.character;
    }

    public String getHepburn() {
        return this.hepburn;
    }

    public KanaSubType getSubType() {
        return this.subType;
    }

    public Kana toKana() {
        Kana kana = new Kana(this.character, this.hepburn);
        return kana;
    }

    public static List<String> getAllKatakanaAsStringList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Katakana katakana : Katakana.values()) {
            arrayList.add(katakana.getCharacter());
        }
        return arrayList;
    }

    public static boolean containsKatakana(String string) {
        return Text.contains(string, Katakana.getAllKatakanaAsStringList());
    }

    public static boolean containsOnlyKatakana(String string) {
        if (string.isEmpty()) {
            return false;
        }
        List<String> list = Katakana.getAllKatakanaAsStringList();
        for (String string2 : Text.textToCharactersList(string)) {
            if (list.contains(string2)) continue;
            return false;
        }
        return true;
    }

    public static int firstIndexOfKatakana(String string) {
        List<String> list = Katakana.getAllKatakanaAsStringList();
        List<String> list2 = Text.textToCharactersList(string);
        for (int i = 0; i < list2.size(); ++i) {
            String string2 = list2.get(i);
            if (!list.contains(string2)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfKatakana(String string) {
        List<String> list = Katakana.getAllKatakanaAsStringList();
        List<String> list2 = Text.textToCharactersList(string);
        for (int i = list2.size() - 1; i >= 0; --i) {
            String string2 = list2.get(i);
            if (!list.contains(string2)) continue;
            return i;
        }
        return -1;
    }

    public static List<Katakana> getKanasWithSubtypes(KanaSubType ... kanaSubTypeArray) {
        return Katakana.getKanasWithSubtypes(CollectionsHelper.arrayToList(kanaSubTypeArray));
    }

    public static List<Katakana> getKanasWithSubtypes(List<KanaSubType> list) {
        ArrayList<Katakana> arrayList = new ArrayList<Katakana>();
        for (Katakana katakana : Katakana.values()) {
            KanaSubType kanaSubType = katakana.getSubType();
            if (!list.contains((Object)kanaSubType)) continue;
            arrayList.add(katakana);
        }
        return arrayList;
    }

    public static int getNumberOfKnownKatakana() {
        return Katakana.values().length;
    }

    public static int getNumberOfKnownStandardKatakana() {
        List<Katakana> list = Katakana.getKanasWithSubtypes(KanaSubType.STANDARD);
        return list.size();
    }
}

