/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.grammar;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.Vocable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class VerbSearchWords {
    public static final String WOERERBUCHFORM = "W\u00f6rterbuchform";
    public static final List<String> SORTED_VERB_SEARCH_WORDS = CollectionsHelper.buildListFrom("W\u00f6rterbuchform", "h\u00f6flich Gegenwart/Zukunft", "h\u00f6flich Gegenwart/Zukunft verneint", "h\u00f6flich Vergangenheit", "h\u00f6flich Vergangenheit verneint", "normal Gegenwart/Zukunft", "normal Gegenwart/Zukunft verneint", "normal Vergangenheit", "normal Vergangenheit verneint", "Willensform", "normale Willensform", "Aufforderungsform", "Aufforderungsform verneint", "h\u00f6fliche Wunschform Gegenwart/Zukunft", "h\u00f6fliche Wunschform Gegenwart/Zukunft verneint", "h\u00f6fliche Wunschform Vergangenheit", "h\u00f6fliche Wunschform Vergangenheit verneint", "normale Wunschform Gegenwart/Zukunft", "normale Wunschform Gegenwart/Zukunft verneint", "normale Wunschform Vergangenheit", "normale Wunschform Vergangenheit verneint", "h\u00f6fliche Verlaufsform Gegenwart", "h\u00f6fliche Verlaufsform Gegenwart verneint", "h\u00f6fliche Verlaufsform Vergangenheit", "h\u00f6fliche Verlaufsform Vergangenheit verneint", "normale Verlaufsform Gegenwart", "normale Verlaufsform Gegenwart verneint", "normale Verlaufsform Vergangenheit", "normale Verlaufsform Vergangenheit verneint", "h\u00f6fliche Potentialform Gegenwart/Zukunft", "h\u00f6fliche Potentialform Gegenwart/Zukunft verneint", "h\u00f6fliche Potentialform Vergangenheit", "normale Potentialform Gegenwart/Zukunft", "normale Potentialform Gegenwart/Zukunft verneint", "normale Potentialform Vergangenheit", "Suru-Verb");

    public static void sortVocablesByVerbForms(List<Vocable> list) {
        Collections.sort(list, new Comparator<Vocable>(){

            @Override
            public int compare(Vocable vocable, Vocable vocable2) {
                int n = VerbSearchWords.determineLowestExistingVerbFormIndex(vocable.getSearchWords());
                int n2 = VerbSearchWords.determineLowestExistingVerbFormIndex(vocable2.getSearchWords());
                if (n == -1) {
                    n = Integer.MAX_VALUE;
                }
                if (n2 == -1) {
                    n2 = Integer.MAX_VALUE;
                }
                return n - n2;
            }
        });
    }

    private static int determineLowestExistingVerbFormIndex(List<String> list) {
        int n = Integer.MAX_VALUE;
        for (String string : list) {
            int n2 = SORTED_VERB_SEARCH_WORDS.indexOf(string);
            if (n2 == -1 || n2 >= n) continue;
            n = n2;
        }
        return n;
    }
}

