/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.grammar.table;

import de.duehl.basics.text.html.generation.HtmlBuilder;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.grammar.table.GrammarTableRowCreator;
import java.util.List;
import java.util.Map;

public class GrammarTableHtmlCreator {
    private static final String HTML_STYLE = "body {\n    font-size:14pt;\n    background-color:white;\n    color:black;\n}\np {\n    background-color:white;\n    color:black;\n}\ntable {\n    border: 1px solid;\n}\nth {\n    background-color:#DDD;\n    border: 1px solid;\n    margin:3px;\n    padding:5px 15px 5px 15px;\n}\ntd {\n    border: 1px solid;\n    margin:3px;\n    padding:5px 15px 5px 15px;\n}\n.pronunciationChangedCell {\n    background-color:#FFFFE6;\n}\n.exceptionCell {\n    background-color:#FFE6E6;\n}\n.emptyCell, td.emptyCell {\n    border: 0px solid;\n}\n.title {\n    font-size:28pt;\n}\n.kanji {\n    font-size:16pt;\n}\n.kana {\n    font-size:14pt;\n}\n.romaji {\n    font-size:12pt;\n}\n".indent(4).stripTrailing();
    private final List<List<Vocable>> listOfVocablesInRow;
    private final String tableTitle;
    private final List<String> searchWords;
    private final Options options;
    private final boolean showKanji;
    private final boolean showKana;
    private final boolean showRomaji;
    private final boolean leaveNotFoundFormsBlank;
    private HtmlBuilder html;

    public GrammarTableHtmlCreator(List<List<Vocable>> list, String string, List<String> list2, Options options) {
        this.listOfVocablesInRow = list;
        this.tableTitle = string;
        this.searchWords = list2;
        this.options = options;
        this.showKanji = options.isGrammarTableShowKanji();
        this.showKana = options.isGrammarTableShowKana();
        this.showRomaji = options.isGrammarTableShowRomaji();
        this.leaveNotFoundFormsBlank = options.isGrammarTableLeaveNotFoundFormsBlank();
    }

    public void create() {
        this.init();
        this.appendTableTitle();
        this.appendFormTable();
        this.appendFoot();
    }

    private void init() {
        this.html = new HtmlBuilder();
        this.html.appendHtml5HeadWithOwnExtendedCssUtf8(this.tableTitle, HTML_STYLE);
    }

    private void appendTableTitle() {
        this.html.appendPWithClass(this.tableTitle, "title");
        this.html.appendVerticalSpace();
    }

    private void appendFormTable() {
        this.html.appendOpeningTable();
        this.appendFormTableHeadRow();
        this.appendFormTableDataRows();
        this.html.appendClosingTable();
    }

    private void appendFormTableHeadRow() {
        this.html.appendOpeningTr();
        Map<String, String> map = this.options.getGrammarTableVerbHeadersMap();
        Map<String, String> map2 = this.options.getGrammarTableIAdjectiveHeadersMap();
        Map<String, String> map3 = this.options.getGrammarTableNaAdjectiveHeadersMap();
        for (String string : this.searchWords) {
            String string2 = !this.options.isGrammarTableUseUserHeaders() ? string : (map.containsKey(string) ? map.get(string) : (map2.containsKey(string) ? map2.get(string) : (map3.containsKey(string) ? map3.get(string) : string)));
            this.html.appendTh(string2);
        }
        this.html.appendClosingTr();
    }

    private void appendFormTableDataRows() {
        for (List<Vocable> list : this.listOfVocablesInRow) {
            this.appendFormTableDataRow(list);
        }
    }

    private void appendFormTableDataRow(List<Vocable> list) {
        this.html.appendOpeningTr();
        for (Vocable vocable : list) {
            this.appendTableCell(vocable);
        }
        this.html.appendClosingTr();
    }

    private void appendTableCell(Vocable vocable) {
        this.html.appendOpeningTd();
        if (vocable == GrammarTableRowCreator.NOT_FOUND_FORM) {
            if (!this.leaveNotFoundFormsBlank) {
                this.html.appendP("(noch nicht vorhanden)");
            }
        } else {
            String string = vocable.getKanji();
            String string2 = vocable.getKana();
            String string3 = vocable.getRomaji();
            if (string.isBlank()) {
                string = string2;
                if (this.showKanji && this.showKana) {
                    string2 = "";
                }
            }
            if (this.showKanji) {
                this.html.appendP(string);
            }
            if (this.showKana) {
                this.html.appendP(string2);
            }
            if (this.showRomaji) {
                this.html.appendP(string3);
            }
        }
        this.html.appendClosingTd();
    }

    private void appendFoot() {
        this.html.appendFoot();
    }

    public String getHtml() {
        return this.html.toString();
    }
}

