/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.io;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.definitions.DefinitionLineParser;
import de.duehl.vocabulary.japanese.data.Vocable;
import java.util.ArrayList;
import java.util.List;

public class VocabularyReader {
    private static final String VOCABULARY_CATEGORY_KEY = "vocabulary-category";
    private static final String VOCABULARY_SUB_CATEGORY_KEY = "vocabulary-sub-category";
    private static final String DEFAULT_VOCABULARY_CATEGORY = "Default";
    private static final String DEFAULT_VOCABULARY_SUB_CATEGORY = "Default";
    private static final String STOP_READING = "__BIS_HIER__";
    private final String filename;
    private List<String> lines;
    private List<Vocable> vocables;
    private String vocabularyCategory;
    private String vocabularySubCategory;

    public VocabularyReader(String string) {
        this.filename = string;
        this.vocabularyCategory = "Default";
        this.vocabularySubCategory = "Default";
    }

    public void read() {
        this.readLinesOfVocabularyFile();
        this.parseVariables();
    }

    private void readLinesOfVocabularyFile() {
        this.lines = FileHelper.readFileToList(this.filename, Charset.UTF_8);
    }

    private void parseVariables() {
        this.vocables = new ArrayList<Vocable>();
        boolean bl = false;
        Vocable vocable = null;
        for (String string : this.lines) {
            if (string.equals(STOP_READING)) break;
            if (string.startsWith("#")) continue;
            if (string.startsWith(VOCABULARY_CATEGORY_KEY)) {
                this.parseVocabularyCategory(string);
                continue;
            }
            if (string.startsWith(VOCABULARY_SUB_CATEGORY_KEY)) {
                this.parseVocabularySubCategory(string);
                continue;
            }
            if (string.isBlank()) {
                if (!bl) continue;
                this.vocables.add(vocable);
                bl = false;
                continue;
            }
            if (!bl) {
                vocable = new Vocable();
                bl = true;
            }
            this.parseLineAndAddToVocable(string, vocable);
        }
        if (bl) {
            this.vocables.add(vocable);
            bl = false;
        }
    }

    private void parseVocabularyCategory(String string) {
        DefinitionLineParser definitionLineParser = new DefinitionLineParser(string, this.filename);
        definitionLineParser.parse();
        String string2 = definitionLineParser.getKey();
        String string3 = definitionLineParser.getValue();
        if (!string2.equalsIgnoreCase(VOCABULARY_CATEGORY_KEY)) {
            throw new RuntimeException("Die Zeile mit der Kategorie des Vokabulars enth\u00e4lt den falschen Schl\u00fcssel.\n\tfilename = '" + this.filename + "'.\n\tZeile    = '" + string + "'.\n\tkey      = '" + string2 + "'.\n\terwartet = 'vocabulary-category'.\nDie Gro\u00df-/Kleinschreibung spielt keine Rolle.");
        }
        if (!this.vocabularyCategory.equals("Default")) {
            throw new RuntimeException("Es gibt mehr als eine Kategorie des Vokabulars.\n\tfilename   = '" + this.filename + "'.\n\tKategorie1 = '" + this.vocabularyCategory + "'.\n\tKategorie2 = '" + string3 + "'.\n");
        }
        this.vocabularyCategory = string3;
    }

    private void parseVocabularySubCategory(String string) {
        DefinitionLineParser definitionLineParser = new DefinitionLineParser(string, this.filename);
        definitionLineParser.parse();
        String string2 = definitionLineParser.getKey();
        String string3 = definitionLineParser.getValue();
        if (!string2.equalsIgnoreCase(VOCABULARY_SUB_CATEGORY_KEY)) {
            throw new RuntimeException("Die Zeile mit der Unterkategorie des Vokabulars enth\u00e4lt den falschen Schl\u00fcssel.\n\tfilename = '" + this.filename + "'.\n\tZeile    = '" + string + "'.\n\tkey      = '" + string2 + "'.\n\terwartet = 'vocabulary-sub-category'.\nDie Gro\u00df-/Kleinschreibung spielt keine Rolle.");
        }
        if (!this.vocabularySubCategory.equals("Default")) {
            throw new RuntimeException("Es gibt mehr als eine Unterkategorie des Vokabulars.\n\tfilename        = '" + this.filename + "'.\n\tUnterkategorie1 = '" + this.vocabularySubCategory + "'.\n\tUnterkategorie2 = '" + string3 + "'.\n");
        }
        this.vocabularySubCategory = string3;
    }

    private void parseLineAndAddToVocable(String string, Vocable vocable) {
        DefinitionLineParser definitionLineParser = new DefinitionLineParser(string, this.filename);
        definitionLineParser.parse();
        String string2 = definitionLineParser.getKey();
        String string3 = definitionLineParser.getValue();
        this.addToVocable(string2, string3, vocable);
    }

    private void addToVocable(String string, String string2, Vocable vocable) {
        if (string.equals("kana")) {
            this.checkEmptyValue(string, string2, vocable);
            vocable.setKana(string2);
        } else if (string.equals("kanji")) {
            vocable.setKanji(string2);
        } else if (string.equals("romaji")) {
            this.checkEmptyValue(string, string2, vocable);
            vocable.setRomaji(string2);
        } else if (string.equals("aussprache")) {
            this.checkEmptyValue(string, string2, vocable);
            vocable.setPronunciation(string2);
        } else if (string.startsWith("deutsch")) {
            this.checkEmptyValue(string, string2, vocable);
            vocable.addToTranslations(string2);
        } else if (string.equals("mp3")) {
            this.checkEmptyValue(string, string2, vocable);
            vocable.setBareMp3(string2);
        } else if (string.equals("bemerkung")) {
            vocable.setComment(string2);
        } else if (string.equals("suchbegriffe")) {
            List<String> list = Text.splitByKomma(string2);
            vocable.setSearchWords(list);
        } else if (string.equals("wortart") || string.equals("wortarten")) {
            List<String> list = Text.splitByKomma(string2);
            vocable.setPartsOfSpeech(list);
        } else {
            throw new RuntimeException("Unbekannter Schl\u00fcssel.\n\tfilename = '" + this.filename + "'.\n\tkey      = '" + string + "'.\n\tvocable  = '" + vocable + "'.\n");
        }
    }

    private void checkEmptyValue(String string, String string2, Vocable vocable) {
        if (string2.isBlank()) {
            throw new RuntimeException("Der Wert zum Schl\u00fcssel ist leer.\n\tfilename = '" + this.filename + "'.\n\tkey      = '" + string + "'.\n\tvocable  = '" + vocable + "'.\n");
        }
    }

    public List<Vocable> getVocables() {
        return this.vocables;
    }

    public String getVocabularyCategory() {
        return this.vocabularyCategory;
    }

    public String getVocabularySubCategory() {
        return this.vocabularySubCategory;
    }
}

