/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kana.html;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.html.KanaHtmlCreator;
import de.duehl.vocabulary.japanese.logic.symbol.kana.html.data.KanaStructure;

public class HiraganaHtmlCreator {
    private KanaStructure structure;
    private String html;

    public void create() {
        this.createStructure();
        this.createKanaHtml();
    }

    private void createStructure() {
        this.structure = new KanaStructure();
        this.structure.fillAIUEO(Hiragana.A.toKana(), Hiragana.I.toKana(), Hiragana.U.toKana(), Hiragana.E.toKana(), Hiragana.O.toKana());
        this.structure.fillKaKiKuKeKo(Hiragana.KA.toKana(), Hiragana.KI.toKana(), Hiragana.KU.toKana(), Hiragana.KE.toKana(), Hiragana.KO.toKana());
        this.structure.fillSaShiSuSeSo(Hiragana.SA.toKana(), Hiragana.SHI.toKana(), Hiragana.SU.toKana(), Hiragana.SE.toKana(), Hiragana.SO.toKana());
        this.structure.fillTaChiTsuTeTo(Hiragana.TA.toKana(), Hiragana.CHI.toKana(), Hiragana.TSU.toKana(), Hiragana.TE.toKana(), Hiragana.TO.toKana());
        this.structure.fillNaNiNuNeNo(Hiragana.NA.toKana(), Hiragana.NI.toKana(), Hiragana.NU.toKana(), Hiragana.NE.toKana(), Hiragana.NO.toKana());
        this.structure.fillHaHiFuHeHo(Hiragana.HA.toKana(), Hiragana.HI.toKana(), Hiragana.FU.toKana(), Hiragana.HE.toKana(), Hiragana.HO.toKana());
        this.structure.fillMaMiMuMeMo(Hiragana.MA.toKana(), Hiragana.MI.toKana(), Hiragana.MU.toKana(), Hiragana.ME.toKana(), Hiragana.MO.toKana());
        this.structure.fillYaYuYo(Hiragana.YA.toKana(), Hiragana.YU.toKana(), Hiragana.YO.toKana());
        this.structure.fillRaRiRuReRo(Hiragana.RA.toKana(), Hiragana.RI.toKana(), Hiragana.RU.toKana(), Hiragana.RE.toKana(), Hiragana.RO.toKana());
        this.structure.fillWaWo(Hiragana.WA.toKana(), Hiragana.WO.toKana());
        this.structure.fillN(Hiragana.N.toKana());
        this.structure.fillGaGiGuGeGo(Hiragana.GA.toKana(), Hiragana.GI.toKana(), Hiragana.GU.toKana(), Hiragana.GE.toKana(), Hiragana.GO.toKana());
        this.structure.fillZaJiZuZeZo(Hiragana.ZA.toKana(), Hiragana.JI1.toKana(), Hiragana.ZU1.toKana(), Hiragana.ZE.toKana(), Hiragana.ZO.toKana());
        this.structure.fillDaJiZuDeDo(Hiragana.DA.toKana(), Hiragana.JI2.toKana(), Hiragana.ZU2.toKana(), Hiragana.DE.toKana(), Hiragana.DO.toKana());
        this.structure.fillBaBiBuBeBo(Hiragana.BA.toKana(), Hiragana.BI.toKana(), Hiragana.BU.toKana(), Hiragana.BE.toKana(), Hiragana.BO.toKana());
        this.structure.fillPaPiPuPePo(Hiragana.PA.toKana(), Hiragana.PI.toKana(), Hiragana.PU.toKana(), Hiragana.PE.toKana(), Hiragana.PO.toKana());
        this.structure.fillKyaKyuKyo(Hiragana.KYA.toKana(), Hiragana.KYU.toKana(), Hiragana.KYO.toKana());
        this.structure.fillShaShuSho(Hiragana.SHA.toKana(), Hiragana.SHU.toKana(), Hiragana.SHO.toKana());
        this.structure.fillChaChuCho(Hiragana.CHA.toKana(), Hiragana.CHU.toKana(), Hiragana.CHO.toKana());
        this.structure.fillNyaNyuNyo(Hiragana.NYA.toKana(), Hiragana.NYU.toKana(), Hiragana.NYO.toKana());
        this.structure.fillHyaHyuHyo(Hiragana.HYA.toKana(), Hiragana.HYU.toKana(), Hiragana.HYO.toKana());
        this.structure.fillMyaMyuMyo(Hiragana.MYA.toKana(), Hiragana.MYU.toKana(), Hiragana.MYO.toKana());
        this.structure.fillRyaRyuRyo(Hiragana.RYA.toKana(), Hiragana.RYU.toKana(), Hiragana.RYO.toKana());
        this.structure.fillGyaGyuGyo(Hiragana.GYA.toKana(), Hiragana.GYU.toKana(), Hiragana.GYO.toKana());
        this.structure.fillJaJuJo1(Hiragana.JA1.toKana(), Hiragana.JU1.toKana(), Hiragana.JO1.toKana());
        this.structure.fillJaJuJo2(Hiragana.JA2.toKana(), Hiragana.JU2.toKana(), Hiragana.JO2.toKana());
        this.structure.fillByaByuByo(Hiragana.BYA.toKana(), Hiragana.BYU.toKana(), Hiragana.BYO.toKana());
        this.structure.fillPyaPyuPyo(Hiragana.PYA.toKana(), Hiragana.PYU.toKana(), Hiragana.PYO.toKana());
        this.structure.fillKanaLehnworte(CollectionsHelper.buildListFrom(Hiragana.LEHNWORT_WI.toKana(), Hiragana.LEHNWORT_FA.toKana(), Hiragana.LEHNWORT_TI.toKana(), Hiragana.LEHNWORT_DU.toKana(), Hiragana.LEHNWORT_WE.toKana(), Hiragana.LEHNWORT_FO.toKana()));
        this.structure.fillKleinesTsu(Hiragana.SMALL_TSU.toKana());
        this.structure.fillKleinesYaYuYoGo(Hiragana.SMALL_YA.toKana(), Hiragana.SMALL_YU.toKana(), Hiragana.SMALL_YO.toKana());
    }

    private void createKanaHtml() {
        KanaHtmlCreator kanaHtmlCreator = new KanaHtmlCreator(this.structure, "Hiragana");
        kanaHtmlCreator.create();
        this.html = kanaHtmlCreator.getHtml();
    }

    public String getHtml() {
        return this.html;
    }
}

