/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.logic.translation.GermanToJapaneseTranslation;
import de.duehl.vocabulary.japanese.logic.translation.JapaneseToGermanTranslation;
import de.duehl.vocabulary.japanese.logic.wrongtested.WrongTestedVocables;
import de.duehl.vocabulary.japanese.startup.logic.steps.StartupStep;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step01ReadVocabularies;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step02CheckVocabelIntegrety;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step03FindMP3AndStoreInVocables;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step04ReadInternalVocableData;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step05JoinVocablesAndInternalData;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step06StoreDateOfOldestVocableInEachVocabulary;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step07CreateJapaneseToGermanTranslation;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step08ACreateGermanToJapaneseTranslation;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step08BSkipCreateGermanToJapaneseTranslation;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step09InitOwnLists;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step10ReadWrongTestedVocableLists;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step11CheckDoubleKanji;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step12ReadInternalKanjiData;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step13LoadKanjiSets;
import de.duehl.vocabulary.japanese.startup.logic.steps.Step14LoadInternalKanaData;
import de.duehl.vocabulary.japanese.startup.ui.SplashScreen;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StartupLoader {
    public static final String INTERNAL_VARIABLE_DATA_EXTENSION = ".ivd";
    public static final String INTERNAL_DATA_DIRECTORY = FileHelper.concatPathes(SessionManager.VOCABLE_TRAINER_DIRECTORY, "internal_vocabulary_data");
    private static final String STEP_LOAD_VOCABLES_AND_MP3S = "Vokabeln laden";
    private static final String STEP_CHECK_VOCABLE_INTEGRITY = "Vokabeln auf Integrit\u00e4t pr\u00fcfen";
    private static final String STEP_FIND_MP3_AND_STORE_IN_VOCABLES = "MP3s finden und den Vokabeln zuordnen";
    private static final String STEP_LOAD_INTERNAL_VOCABLES_DATA = "Interne Daten zu den Vokabeln laden";
    private static final String STEP_LOAD_JOIN_INTERNAL_VOCABLES_DATA = "Interne Daten den Vokabeln zuordnen";
    private static final String STEP_STORE_OLDEST_VOCABLES_DATE = "\u00e4lteste Vokabel in Vokabularien eintragen";
    private static final String STEP_CREATE_TRANSLATION_J_D = "Erzeuge \u00dcbersetzungen Japanisch-Deutsch";
    private static final String STEP_CREATE_TRANSLATION_D_J = "Erzeuge \u00dcbersetzungen Deutsch-Japanisch";
    private static final String STEP_INIT_OWN_LISTS = "Erzeuge Verwaltung der eigenen Listen";
    private static final String STEP_READ_WRONG_TESTED_VOCABLES = "Lese falsch \u00fcbersetzte Vokabeln";
    private static final String STEP_CHECK_DOUBLE_KANJI = "Pr\u00fcfe Kanji auf Dublettenfreiheit";
    private static final String STEP_LOAD_INTERNAL_KANJI_DATA = "Interne Daten zu den Kanji laden";
    private static final String STEP_LOAD_KANJI_SETS = "Kanji-Mengen laden";
    private static final String STEP_LOAD_INTERNAL_KANA_DATA = "Interne Daten zu den Kana laden";
    private final VocabularyTrainerGui gui;
    private final Options options;
    private List<Vocabulary> vocabularies;
    private String vocabularyLoadMessage;
    private Map<String, InternalAdditionalVocableData> key2InternalDataMap;
    private List<String> allKeysFromReadInternalData;
    private Map<Vocable, InternalAdditionalVocableData> vocable2InternalDataMap;
    private InternalDataRequester internalDataRequester;
    private JapaneseToGermanTranslation japaneseToGermanTranslation;
    private GermanToJapaneseTranslation germanToJapaneseTranslation;
    private Map<String, Vocable> keyToVocable;
    private OwnLists ownLists;
    private WrongTestedVocables wrongTestedVocables;
    private InternalKanjiDataRequester internalKanjiDataRequester;
    private List<KanjiSet> kanjiSets;
    private InternalKanaDataRequester internalKanaDataRequester;
    private final SplashScreen splashScreen;
    private StopWatch watch;
    private FumikoDataStructures dataStructures;
    private boolean startUpErrorOccured;
    private String startupError;
    private List<String> startupWarnings;

    public StartupLoader(VocabularyTrainerGui vocabularyTrainerGui, Options options) {
        this.gui = vocabularyTrainerGui;
        this.options = options;
        List<String> list = CollectionsHelper.buildListFrom(STEP_LOAD_VOCABLES_AND_MP3S, STEP_CHECK_VOCABLE_INTEGRITY, STEP_FIND_MP3_AND_STORE_IN_VOCABLES, STEP_LOAD_INTERNAL_VOCABLES_DATA, STEP_LOAD_JOIN_INTERNAL_VOCABLES_DATA, STEP_STORE_OLDEST_VOCABLES_DATE, STEP_CREATE_TRANSLATION_J_D, STEP_CREATE_TRANSLATION_D_J, STEP_INIT_OWN_LISTS, STEP_READ_WRONG_TESTED_VOCABLES, STEP_CHECK_DOUBLE_KANJI, STEP_LOAD_INTERNAL_KANJI_DATA, STEP_LOAD_KANJI_SETS, STEP_LOAD_INTERNAL_KANA_DATA);
        this.splashScreen = new SplashScreen(list, vocabularyTrainerGui.getProgramImage());
        this.startUpErrorOccured = false;
        this.startupError = "";
        this.startupWarnings = new ArrayList<String>();
    }

    public void load() {
        try {
            this.tryToLoad();
        }
        catch (Exception exception) {
            this.startUpErrorOccured = true;
            this.startupError = "Fehler (Exception) beim Startup: " + exception.getMessage();
            exception.printStackTrace();
            this.closeSplashScreen();
        }
    }

    private void tryToLoad() {
        this.init();
        this.showSplashScreen();
        this.startup();
        this.closeSplashScreen();
        if (!this.startUpErrorOccured) {
            this.createFumikoDataStructures();
        }
    }

    private void init() {
        this.watch = new StopWatch();
    }

    private void showSplashScreen() {
        this.splashScreen.setVisible(true);
    }

    private void startup() {
        if (!this.startUpErrorOccured) {
            this.step01ReadVocabularies();
        }
        if (!this.startUpErrorOccured) {
            this.step02CheckVocabelintegrity();
        }
        if (!this.startUpErrorOccured) {
            this.step03FindMP3AndStoreInVocables();
        }
        if (!this.startUpErrorOccured) {
            this.step04ReadInternalVocableData();
        }
        if (!this.startUpErrorOccured) {
            this.step05JoinVocablesWithInternalData();
        }
        if (!this.startUpErrorOccured) {
            this.step06StoreDateOfOldestVocableInEachVocabulary();
        }
        if (!this.startUpErrorOccured) {
            this.step07CreateJapaneseToGermanTranslation();
        }
        if (!this.startUpErrorOccured) {
            this.step08CreateGermanToJapaneseTranslation();
        }
        if (!this.startUpErrorOccured) {
            this.step09InitOwnListsAndReadWrongTestedVocableLists();
        }
        if (!this.startUpErrorOccured) {
            this.step10ReadWrongTestedVocableLists();
        }
        if (!this.startUpErrorOccured) {
            this.step11CheckDoubleKanji();
        }
        if (!this.startUpErrorOccured) {
            this.step12LoadInternalKanjiData();
        }
        if (!this.startUpErrorOccured) {
            this.step13LoadKanjiSets();
        }
        if (!this.startUpErrorOccured) {
            this.step14LoadInternalKanaData();
        }
    }

    private void step01ReadVocabularies() {
        Step01ReadVocabularies step01ReadVocabularies = new Step01ReadVocabularies(STEP_LOAD_VOCABLES_AND_MP3S, this.options, this.splashScreen, this.watch);
        step01ReadVocabularies.runStep();
        this.vocabularies = step01ReadVocabularies.getVocabularies();
        this.vocabularyLoadMessage = step01ReadVocabularies.getVocabularyLoadMessage();
        this.postprocessActualStep(step01ReadVocabularies);
    }

    private void step02CheckVocabelintegrity() {
        Step02CheckVocabelIntegrety step02CheckVocabelIntegrety = new Step02CheckVocabelIntegrety(STEP_CHECK_VOCABLE_INTEGRITY, this.options, this.splashScreen, this.watch, this.vocabularies);
        step02CheckVocabelIntegrety.runStep();
        this.postprocessActualStep(step02CheckVocabelIntegrety);
    }

    private void step03FindMP3AndStoreInVocables() {
        Step03FindMP3AndStoreInVocables step03FindMP3AndStoreInVocables = new Step03FindMP3AndStoreInVocables(STEP_FIND_MP3_AND_STORE_IN_VOCABLES, this.options, this.splashScreen, this.watch, this.vocabularies);
        step03FindMP3AndStoreInVocables.runStep();
        this.postprocessActualStep(step03FindMP3AndStoreInVocables);
    }

    private void step04ReadInternalVocableData() {
        Step04ReadInternalVocableData step04ReadInternalVocableData = new Step04ReadInternalVocableData(STEP_LOAD_INTERNAL_VOCABLES_DATA, this.options, this.splashScreen, this.watch);
        step04ReadInternalVocableData.runStep();
        this.key2InternalDataMap = step04ReadInternalVocableData.getKey2InternalDataMap();
        this.allKeysFromReadInternalData = step04ReadInternalVocableData.getAllKeysFromReadInternalData();
        this.postprocessActualStep(step04ReadInternalVocableData);
    }

    private void step05JoinVocablesWithInternalData() {
        Step05JoinVocablesAndInternalData step05JoinVocablesAndInternalData = new Step05JoinVocablesAndInternalData(STEP_LOAD_JOIN_INTERNAL_VOCABLES_DATA, this.options, this.splashScreen, this.watch, this.vocabularies, this.key2InternalDataMap, this.allKeysFromReadInternalData);
        step05JoinVocablesAndInternalData.runStep();
        this.vocable2InternalDataMap = step05JoinVocablesAndInternalData.getVocable2InternalDataMap();
        this.internalDataRequester = step05JoinVocablesAndInternalData.getInternalDataRequester();
        this.postprocessActualStep(step05JoinVocablesAndInternalData);
    }

    private void step06StoreDateOfOldestVocableInEachVocabulary() {
        Step06StoreDateOfOldestVocableInEachVocabulary step06StoreDateOfOldestVocableInEachVocabulary = new Step06StoreDateOfOldestVocableInEachVocabulary(STEP_STORE_OLDEST_VOCABLES_DATE, this.options, this.splashScreen, this.watch, this.vocabularies, this.vocable2InternalDataMap);
        step06StoreDateOfOldestVocableInEachVocabulary.runStep();
        this.postprocessActualStep(step06StoreDateOfOldestVocableInEachVocabulary);
    }

    private void step07CreateJapaneseToGermanTranslation() {
        Step07CreateJapaneseToGermanTranslation step07CreateJapaneseToGermanTranslation = new Step07CreateJapaneseToGermanTranslation(STEP_CREATE_TRANSLATION_J_D, this.options, this.splashScreen, this.watch, this.vocabularies);
        step07CreateJapaneseToGermanTranslation.runStep();
        this.japaneseToGermanTranslation = step07CreateJapaneseToGermanTranslation.getJapaneseToGermanTranslation();
        this.postprocessActualStep(step07CreateJapaneseToGermanTranslation);
    }

    private void step08CreateGermanToJapaneseTranslation() {
        if (this.options.isCreateGermanJapaneseTranslationAtStartup()) {
            Step08ACreateGermanToJapaneseTranslation step08ACreateGermanToJapaneseTranslation = new Step08ACreateGermanToJapaneseTranslation(STEP_CREATE_TRANSLATION_D_J, this.options, this.splashScreen, this.watch, this.vocabularies);
            step08ACreateGermanToJapaneseTranslation.runStep();
            this.germanToJapaneseTranslation = step08ACreateGermanToJapaneseTranslation.getGermanToJapaneseTranslation();
            this.postprocessActualStep(step08ACreateGermanToJapaneseTranslation);
        } else {
            Step08BSkipCreateGermanToJapaneseTranslation step08BSkipCreateGermanToJapaneseTranslation = new Step08BSkipCreateGermanToJapaneseTranslation(STEP_CREATE_TRANSLATION_D_J, this.options, this.splashScreen, this.watch);
            step08BSkipCreateGermanToJapaneseTranslation.runStep();
            this.postprocessActualStep(step08BSkipCreateGermanToJapaneseTranslation);
        }
    }

    private void step09InitOwnListsAndReadWrongTestedVocableLists() {
        Step09InitOwnLists step09InitOwnLists = new Step09InitOwnLists(STEP_INIT_OWN_LISTS, this.gui, this.options, this.splashScreen, this.watch, this.vocabularies, this.internalDataRequester);
        step09InitOwnLists.runStep();
        this.keyToVocable = step09InitOwnLists.getKeyToVocable();
        this.ownLists = step09InitOwnLists.getOwnLists();
        this.postprocessActualStep(step09InitOwnLists);
    }

    private void step10ReadWrongTestedVocableLists() {
        Step10ReadWrongTestedVocableLists step10ReadWrongTestedVocableLists = new Step10ReadWrongTestedVocableLists(STEP_READ_WRONG_TESTED_VOCABLES, this.options, this.splashScreen, this.watch, this.vocabularies, this.internalDataRequester, this.keyToVocable);
        step10ReadWrongTestedVocableLists.runStep();
        this.wrongTestedVocables = step10ReadWrongTestedVocableLists.getWrongTestedVocables();
        this.postprocessActualStep(step10ReadWrongTestedVocableLists);
    }

    private void step11CheckDoubleKanji() {
        Step11CheckDoubleKanji step11CheckDoubleKanji = new Step11CheckDoubleKanji(STEP_CHECK_DOUBLE_KANJI, this.options, this.splashScreen, this.watch);
        step11CheckDoubleKanji.runStep();
        this.postprocessActualStep(step11CheckDoubleKanji);
    }

    private void step12LoadInternalKanjiData() {
        Step12ReadInternalKanjiData step12ReadInternalKanjiData = new Step12ReadInternalKanjiData(STEP_LOAD_INTERNAL_KANJI_DATA, this.options, this.splashScreen, this.watch);
        step12ReadInternalKanjiData.runStep();
        this.internalKanjiDataRequester = step12ReadInternalKanjiData.getInternalKanjiDataRequester();
        this.postprocessActualStep(step12ReadInternalKanjiData);
    }

    private void step13LoadKanjiSets() {
        Step13LoadKanjiSets step13LoadKanjiSets = new Step13LoadKanjiSets(STEP_LOAD_KANJI_SETS, this.options, this.splashScreen, this.watch);
        step13LoadKanjiSets.runStep();
        this.kanjiSets = step13LoadKanjiSets.getKanjiSets();
        this.postprocessActualStep(step13LoadKanjiSets);
    }

    private void step14LoadInternalKanaData() {
        Step14LoadInternalKanaData step14LoadInternalKanaData = new Step14LoadInternalKanaData(STEP_LOAD_INTERNAL_KANA_DATA, this.options, this.splashScreen, this.watch);
        step14LoadInternalKanaData.runStep();
        this.internalKanaDataRequester = step14LoadInternalKanaData.getInternalKanaDataRequester();
        this.postprocessActualStep(step14LoadInternalKanaData);
    }

    private void postprocessActualStep(StartupStep startupStep) {
        if (startupStep.isErrorsInStep()) {
            this.startUpErrorOccured = true;
            this.startupError = startupStep.getErrorMessage();
        }
        this.startupWarnings.addAll(startupStep.getWarningMessages());
    }

    private void closeSplashScreen() {
        if (this.startUpErrorOccured) {
            String string = "Es ist ein Fehler beim Startup aufgetreten, der den Start des Vokabeltrainers verhindert:\n\n" + this.startupError + "\n\nDa Fehler auftraten, wird die Anwendung geschlossen.";
            this.splashScreen.appendMessage(string);
            System.err.println(string);
            GuiTools.informUser(this.splashScreen.getWindowAsComponent(), "Es traten Fehler auf", string);
            this.splashScreen.closeDialog();
            System.err.println("Wegen Fehlern beim Startup wird der Vokabeltrainer beendet.");
            System.exit(1);
        } else if (this.options.isStopAfterStartup()) {
            GuiTools.informUser(this.splashScreen.getWindowAsComponent(), "Halt nach dem Startup", "Nach Best\u00e4tigung geht es weiter.");
            this.splashScreen.closeDialog();
        } else if (this.options.isWaitForXAfterStartup()) {
            this.splashScreen.canClose();
        } else {
            this.splashScreen.closeDialog();
        }
    }

    private void createFumikoDataStructures() {
        this.dataStructures = new FumikoDataStructures(this.options, this.vocabularies, this.internalDataRequester, this.japaneseToGermanTranslation, this.germanToJapaneseTranslation, this.ownLists, this.wrongTestedVocables, this.internalKanjiDataRequester, this.kanjiSets, this.internalKanaDataRequester);
    }

    public FumikoDataStructures getDataStructures() {
        return this.dataStructures;
    }

    public String getVocabularyLoadMessage() {
        return this.vocabularyLoadMessage;
    }

    public String getStartUpLog() {
        return this.splashScreen.getSplashText();
    }

    public List<String> getStartupWarnings() {
        return this.startupWarnings;
    }
}

