/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.startup.logic.steps.StartupStep;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import java.util.List;
import java.util.Map;

public class Step06StoreDateOfOldestVocableInEachVocabulary
extends StartupStep {
    private final List<Vocabulary> vocabularies;
    private final Map<Vocable, InternalAdditionalVocableData> vocable2InternalDataMap;

    public Step06StoreDateOfOldestVocableInEachVocabulary(String string, Options options, SplashScreenable splashScreenable, StopWatch stopWatch, List<Vocabulary> list, Map<Vocable, InternalAdditionalVocableData> map) {
        super(string, options, splashScreenable, stopWatch);
        this.vocabularies = list;
        this.vocable2InternalDataMap = map;
    }

    @Override
    protected void runInternalStep() {
        this.appendMessage("Trage Datum der \u00e4ltesten Vokabel in allen Vokabularien ein ...");
        for (Vocabulary vocabulary : this.vocabularies) {
            this.storeDateOfOldestVocableInVocabulary(vocabulary);
        }
    }

    private void storeDateOfOldestVocableInVocabulary(Vocabulary vocabulary) {
        ImmutualDate immutualDate = new ImmutualDate();
        for (Vocable vocable : vocabulary.getVocables()) {
            InternalAdditionalVocableData internalAdditionalVocableData = this.vocable2InternalDataMap.get(vocable);
            ImmutualDate immutualDate2 = internalAdditionalVocableData.getFirstSeenDate();
            if (immutualDate2.equals(InternalAdditionalVocableData.NOT_SEEN_DATE) || !immutualDate2.before(immutualDate)) continue;
            immutualDate = immutualDate2;
        }
        vocabulary.setFirstSeenDate(immutualDate);
    }
}

