/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TranslationDirectionGuiWithRadioButtons {
    private final Options options;
    private final VocabularyTrainerGui gui;
    private final JPanel panel;
    private final JRadioButton japaneseToGermanTranslation;
    private final JRadioButton germanToJapaneseTranslation;

    public TranslationDirectionGuiWithRadioButtons(Options options, VocabularyTrainerGui vocabularyTrainerGui) {
        this.options = options;
        this.gui = vocabularyTrainerGui;
        this.panel = new JPanel();
        this.japaneseToGermanTranslation = new JRadioButton("Japanisch - Deutsch");
        this.germanToJapaneseTranslation = new JRadioButton("Deutsch - Japanisch");
        this.init();
        this.selectRadioButton();
    }

    private void init() {
        this.initRadioButtons();
        this.initButtonGroup();
        this.initPanel();
    }

    private void initRadioButtons() {
        this.japaneseToGermanTranslation.addActionListener(actionEvent -> this.toggled());
        this.germanToJapaneseTranslation.addActionListener(actionEvent -> this.toggled());
    }

    private void toggled() {
        TranslationDirection translationDirection = this.japaneseToGermanTranslation.isSelected() ? TranslationDirection.JAPANESE_TO_GERMAN : TranslationDirection.GERMAN_TO_JAPANESE;
        this.options.setTranslationDirection(translationDirection);
        this.gui.showTranslationDirectionOnBarButtons();
        this.gui.setCorrectForegroundColorOfVocabularyBarsLater();
    }

    private void initButtonGroup() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.japaneseToGermanTranslation);
        buttonGroup.add(this.germanToJapaneseTranslation);
    }

    private void initPanel() {
        this.panel.setLayout(new GridLayout(0, 1, 2, 2));
        GuiTools.createTitle(this.panel);
        this.panel.add(this.japaneseToGermanTranslation);
        this.panel.add(this.germanToJapaneseTranslation);
    }

    private void selectRadioButton() {
        TranslationDirection translationDirection = this.options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            this.japaneseToGermanTranslation.setSelected(true);
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            this.germanToJapaneseTranslation.setSelected(true);
        } else {
            throw new RuntimeException("Unbekannte TranslationDirection " + translationDirection + ".");
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

