/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.button;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.components.button.ViewButtonPressedReactor;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.lister.VocabularyListerDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.sheet.VocableSheetsCreator;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.sheet.VocabularySheetDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.single.SingleVocableVocabularyViewerDialog;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OtherViewButtonPanel {
    private final List<Vocable> vocables;
    private final ViewButtonPressedReactor reactor;
    private final String description;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final LongTimeProcessInformer informer;
    private final JPanel panel;
    private final JButton einzeldarstellungButton;
    private final JButton listenDarstellungButton;
    private final JButton blattDarstellungButton;

    public OtherViewButtonPanel(List<Vocable> list, ViewButtonPressedReactor viewButtonPressedReactor, String string, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, LongTimeProcessInformer longTimeProcessInformer) {
        this.vocables = list;
        this.reactor = viewButtonPressedReactor;
        this.description = string;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.informer = longTimeProcessInformer;
        this.panel = new JPanel();
        this.einzeldarstellungButton = new JButton();
        this.listenDarstellungButton = new JButton();
        this.blattDarstellungButton = new JButton();
        this.createGui();
    }

    private void createGui() {
        this.initPanel();
        this.initEinzeldarstellungButton();
        this.initListenDarstellungButton();
        this.initVokabelblattDarstellungButton();
        this.fillPanel();
    }

    private void initPanel() {
        this.panel.setLayout(new GridLayout(0, 3, 5, 5));
    }

    private void initEinzeldarstellungButton() {
        this.einzeldarstellungButton.setText("Einzeldarstellung");
        this.einzeldarstellungButton.addActionListener(actionEvent -> this.einzeldarstellung());
    }

    private void einzeldarstellung() {
        this.closeOldViewer();
        SingleVocableVocabularyViewerDialog singleVocableVocabularyViewerDialog = new SingleVocableVocabularyViewerDialog(this.vocables, this.description, this.dataStructures, this.uiObjects);
        singleVocableVocabularyViewerDialog.setVisible(true);
    }

    private void closeOldViewer() {
        this.reactor.otherViewOpened();
    }

    private void initListenDarstellungButton() {
        this.listenDarstellungButton.setText("Liste");
        this.listenDarstellungButton.addActionListener(actionEvent -> this.listenDarstellung());
    }

    private void listenDarstellung() {
        this.closeOldViewer();
        VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(this.vocables, this.description, this.dataStructures, this.uiObjects, this.uiObjects.getGuiLocation(), this.uiObjects.getInformer());
        vocabularyListerDialog.setVisible(true);
    }

    private void initVokabelblattDarstellungButton() {
        this.blattDarstellungButton.setText("Blatt");
        this.blattDarstellungButton.addActionListener(actionEvent -> this.vokabelblattDarstellung());
    }

    private void vokabelblattDarstellung() {
        this.closeOldViewer();
        this.informer.startLongTimeProcess("\u00d6ffne Blattdarstellung mit " + NumberString.taupu(this.vocables.size()) + " Vokabeln");
        new Thread(() -> this.listVocabularyAsSheetInOwnThread()).start();
    }

    private void listVocabularyAsSheetInOwnThread() {
        try {
            this.tryToListVocabularyAsSheetInOwnThread();
        }
        catch (Exception exception) {
            GuiTools.informUser("Hier ging etwas schief", "Bei der Erzeugng der Panel f\u00fcr die Blattdarstellung gab es ein Problem.");
            this.informer.endLongTimeProcess();
        }
    }

    private void tryToListVocabularyAsSheetInOwnThread() {
        VocableSheetsCreator vocableSheetsCreator = new VocableSheetsCreator(this.vocables, this.dataStructures, this.uiObjects, (list, list2) -> this.listVocabularyAsSheetInEdt(list, list2), this.uiObjects.getGuiLocation());
        vocableSheetsCreator.create();
    }

    private void listVocabularyAsSheetInEdt(List<Vocable> list, List<Component> list2) {
        try {
            this.tryToListVocabularyAsSheetInEdt(list, list2);
        }
        catch (Exception exception) {
            GuiTools.informUser("Hier ging etwas schief", "Bei der Anzeige der Blattdarstellung gab es ein Problem.");
            this.informer.endLongTimeProcess();
        }
    }

    private void tryToListVocabularyAsSheetInEdt(List<Vocable> list, List<Component> list2) {
        VocabularySheetDialog vocabularySheetDialog = new VocabularySheetDialog(list, list2, this.description, this.dataStructures, this.uiObjects, this.informer, this.uiObjects.getGuiLocation());
        vocabularySheetDialog.setVisible(true);
        vocabularySheetDialog.requestFocus();
        this.informer.endLongTimeProcess();
    }

    private void fillPanel() {
        this.panel.add(this.einzeldarstellungButton);
        this.panel.add(this.listenDarstellungButton);
        this.panel.add(this.blattDarstellungButton);
    }

    public void disableEinzeldarstellungButton() {
        this.einzeldarstellungButton.setEnabled(false);
    }

    public void disableListenDarstellungButton() {
        this.listenDarstellungButton.setEnabled(false);
    }

    public void disableVokabelblattDarstellungButton() {
        this.blattDarstellungButton.setEnabled(false);
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

